/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.gui.view.workers;

import java.util.List;
import java.util.concurrent.CancellationException;
import se.ericsson.cello.nex.NexLog;
import se.ericsson.cello.nex.gui.view.MoTreeTableModel;
import se.ericsson.cello.nex.gui.view.NexTreeNode;
import se.ericsson.cello.nex.gui.view.workers.ModelCallback;
import se.ericsson.cello.nex.gui.view.workers.ModelWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandSingleWorker
extends ModelWorker<List<NexTreeNode>, Void> {
    private NexTreeNode node;
    private ModelCallback<Void> callback;

    public ExpandSingleWorker(MoTreeTableModel model, NexTreeNode node, ModelCallback<Void> modelCallback) {
        super(model);
        this.node = node;
        this.callback = modelCallback;
    }

    @Override
    public List<NexTreeNode> doWork() throws Exception {
        if (!this.node.getAllowsChildren() || this.node.hasFetchedChildren()) {
            return null;
        }
        return this.createChildNodesFor(this.node);
    }

    protected void done() {
        try {
            List nodes = (List)this.get();
            if (nodes != null) {
                this.replaceAllChildren(this.node, nodes);
            }
            this.node.allChildrenFetched();
        }
        catch (CancellationException e) {
        }
        catch (Exception e) {
            NexLog.logger().warning("Exception caught in ExpandSingleWorker.done() \n" + NexLog.stackToString(e));
        }
        if (this.callback != null) {
            this.callback.run(null, this.isCancelled());
        }
    }

    public String toString() {
        return "Expanding node " + this.node.getLongName() + ".";
    }
}

