/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swe.service;

import java.security.PrivilegedExceptionAction;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.emt.userpreferences.UserPreferencesI;
import se.ericsson.cello.emt.utils.guitestsupport.GuiTestEventTypes;
import se.ericsson.cello.emt.utils.launchhandler.LaunchHandler;
import se.ericsson.cello.swe.SweLog;
import se.ericsson.cello.swe.service.Configuration;
import se.ericsson.cello.swe.service.StartFailureException;
import se.ericsson.cello.swe.service.SweToolServices;
import se.ericsson.cello.swe.service.Tool;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherException;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.security.launcher.emnotification.EmEventInterface;
import se.ericsson.security.launcher.emnotification.EmNotificationServiceInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SweToolServicesImpl
implements SweToolServices {
    private static final int LAUNCH_NODESERVICES_TIMEOUT = 1800000;
    private static final boolean SHOULD_STORE_USERPREFERENCES = true;
    private LauncherInterface myLauncher;
    private Launchable myParentLaunchable;
    private Configuration myConfiguration;
    private String myHostName;
    private NodeServices myNodeServices = null;
    private UserPreferencesI myUserPreferences = null;
    protected Properties propertiesLastStarted;

    public SweToolServicesImpl(Launchable parent, LauncherInterface launcher, Configuration parameterHandler) {
        this.myParentLaunchable = parent;
        this.myLauncher = launcher;
        this.myConfiguration = parameterHandler;
        this.myHostName = parameterHandler.getHost();
        this.myNodeServices = null;
        SweLog.logger().log(Level.INFO, "SweToolServicesImpl was successfully constructed.");
    }

    public SweToolServicesImpl(Launchable parent, LauncherInterface launcher, Configuration parameterHandler, NodeServices aNodeServices) {
        this(parent, launcher, parameterHandler);
        this.myNodeServices = aNodeServices;
    }

    @Override
    public String getMoSearchToolName() {
        String searchToolName = this.myConfiguration.getMoSearchTool().getName();
        SweLog.logger().log(Level.INFO, "searchToolName=" + searchToolName);
        return searchToolName;
    }

    @Override
    public List<String> getHyperToolNames() {
        SweLog.logger().log(Level.INFO, "getHyperToolNames() was successful.");
        LinkedList<String> toolNameList = new LinkedList<String>();
        List<Tool> hyperToolList = this.myConfiguration.getHyperTools();
        for (Tool tool : hyperToolList) {
            toolNameList.add(tool.getName());
        }
        return toolNameList;
    }

    @Override
    public NodeServices getNodeServices() throws StartFailureException {
        SweLog.logger().log(Level.INFO, "Entering getNodeServices() was successful.");
        if (null == this.myNodeServices) {
            try {
                Tool nodeServTool = this.myConfiguration.getNodeServicesTool();
                Properties props = new Properties();
                props.putAll((Map<?, ?>)this.myConfiguration.getSupersedingProperties());
                this.myNodeServices = (NodeServices)LaunchHandler.getToolAsResource((LauncherInterface)this.myLauncher, (String)nodeServTool.getConfigFile(), (String)this.myHostName, (Properties)props, (Launchable)this.myParentLaunchable, (long)1800000L);
            }
            catch (Exception e) {
                SweLog.logger().warning("Launch NodeServices Error. " + e.getMessage());
                throw new StartFailureException(e);
            }
        }
        return this.myNodeServices;
    }

    @Override
    public void startHyperTool(String hyperToolConfig, Properties aProps) throws StartFailureException {
        this.propertiesLastStarted = aProps;
        SweLog.logger().log(Level.INFO, "entering startHyperTool() was successful.");
        SweLog.logger().log(Level.INFO, "startHyperTool(): hyperToolConfig:" + hyperToolConfig);
        SweLog.logger().log(Level.INFO, "startHyperTool(): Properties:" + aProps);
        SweLog.logger().log(Level.INFO, " before LaunchHandler.launchTool(...). hyperTool.getConfigFile()=" + hyperToolConfig);
        LaunchHandler.launchTool((LauncherInterface)this.myLauncher, (String)hyperToolConfig, (String)this.myHostName, (Properties)aProps, (Launchable)this.myParentLaunchable);
        SweLog.logger().log(Level.INFO, " after LaunchHandler.launchTool(...).");
    }

    @Override
    public Configuration getConfiguration() {
        return this.myConfiguration;
    }

    @Override
    public List<String> getCvHyperToolNames() {
        SweLog.logger().log(Level.INFO, "getCvHyperToolNames() was successful.");
        LinkedList<String> toolNameList = new LinkedList<String>();
        List<Tool> hyperToolList = this.myConfiguration.getCvHyperTools();
        for (Tool tool : hyperToolList) {
            toolNameList.add(tool.getName());
        }
        return toolNameList;
    }

    @Override
    public List<String> getUpHyperToolNames() {
        SweLog.logger().log(Level.INFO, "getUpHyperToolNames() was successful.");
        LinkedList<String> toolNameList = new LinkedList<String>();
        List<Tool> hyperToolList = this.myConfiguration.getUpHyperTools();
        for (Tool tool : hyperToolList) {
            toolNameList.add(tool.getName());
        }
        return toolNameList;
    }

    @Override
    public UserPreferencesI getPreferenceService() {
        if (null != this.myUserPreferences) {
            return this.myUserPreferences;
        }
        final Tool userPrefTool = this.myConfiguration.getPreferencesTool();
        if (null == userPrefTool) {
            SweLog.logger().warning("Missing information about the user preferences configuration file. User preferences will not be stored when this session ends.");
        } else {
            final Properties props = this.myConfiguration.getSupersedingProperties();
            PrivilegedExceptionAction<Launchable> launchHelpServiceAction = new PrivilegedExceptionAction<Launchable>(){

                @Override
                public Launchable run() throws LauncherException {
                    return SweToolServicesImpl.this.myLauncher.runResource(userPrefTool.getConfigFile(), SweToolServicesImpl.this.myHostName, props, SweToolServicesImpl.this.myParentLaunchable);
                }
            };
            Callable<Object> launchResourceCallable = Executors.callable(launchHelpServiceAction);
            ExecutorService exec = Executors.newSingleThreadExecutor();
            Future<Object> hsFuture = exec.submit(launchResourceCallable);
            try {
                Object obj = hsFuture.get();
                exec.shutdown();
                this.myUserPreferences = (UserPreferencesI)obj;
            }
            catch (Exception ex) {
                SweLog.logger().log(Level.WARNING, "Could not get User Preference Service from Launcher. Using temporary preferences.\n");
            }
        }
        if (null == this.myUserPreferences) {
            this.myUserPreferences = new TempUserProps();
        }
        return this.myUserPreferences;
    }

    @Override
    public void sendEmNotification(final String message, final String type, final Object userData, final Object source) {
        if (this.myLauncher instanceof EmNotificationServiceInterface) {
            ((EmNotificationServiceInterface)this.myLauncher).sendNotification(new EmEventInterface(){
                private static final long serialVersionUID = 0L;

                public String getMessage() {
                    return message;
                }

                public long getSequenceNumber() {
                    return GuiTestEventTypes.claimSeqNum();
                }

                public long getTimestamp() {
                    return System.currentTimeMillis();
                }

                public String getType() {
                    return type;
                }

                public Object getUserData() {
                    return userData;
                }

                public Object getSource() {
                    return source;
                }
            });
        }
    }

    private static class TempUserProps
    implements UserPreferencesI {
        Properties myProps = new Properties();

        private TempUserProps() {
        }

        public String getPreference(String key, String defaultValue) {
            return this.myProps.getProperty(key, defaultValue);
        }

        public void setPreference(String key, String value) {
            this.myProps.setProperty(key, value);
        }

        public void removePreference(String preferenceKey) {
            this.myProps.remove(preferenceKey);
        }
    }
}

