/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swe.view.gui;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Insets;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

class LeftDotRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1881731976025016056L;

    LeftDotRenderer() {
    }

    private void setCellText(String cellTextInput, FontMetrics fontM, int availWidth) {
        int width = fontM.stringWidth(cellTextInput);
        if (width > availWidth) {
            int charWidth;
            int nChar;
            String dot = "...";
            int textWide = fontM.stringWidth(dot);
            for (nChar = cellTextInput.length() - 1; nChar > 0 && (textWide += (charWidth = fontM.charWidth(cellTextInput.charAt(nChar)))) <= availWidth; --nChar) {
            }
            String text = dot + cellTextInput.substring(nChar + 1);
            this.setText(text);
        }
    }

    public Component getTableCellRendererComponent(JTable tableCell, Object valueParam, boolean Selected, boolean hasFocusOn, int row, int col) {
        super.getTableCellRendererComponent(tableCell, valueParam, Selected, hasFocusOn, row, col);
        int availWidth = tableCell.getColumnModel().getColumn(col).getWidth();
        double tableWidth = tableCell.getIntercellSpacing().getWidth();
        availWidth = (int)((double)availWidth - tableWidth);
        Insets borderIns = this.getBorder().getBorderInsets(this);
        String cellTextInput = this.getText();
        FontMetrics fontM = this.getFontMetrics(this.getFont());
        this.setCellText(cellTextInput, fontM, availWidth -= borderIns.left + borderIns.right);
        return this;
    }
}

