/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.corba.cert;

import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import se.ericsson.security.corba.cert.X509ServerTrustManager;

public class X509ClientTrustManager
extends X509ServerTrustManager {
    private X509Certificate[] acceptedIssuers;

    public X509ClientTrustManager(String string, String string2) throws NoSuchAlgorithmException, KeyStoreException {
        super(string, string2);
        this.prepareAcceptedIssuers(this.localCertificate);
    }

    public X509Certificate[] getAcceptedIssuers() {
        logger.trace(1, this.getClass(), "getAcceptedIssuers");
        X509Certificate[] x509CertificateArray = (X509Certificate[])this.acceptedIssuers.clone();
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            logger.trace(1, this.getClass(), x509CertificateArray[i].getIssuerDN().getName());
        }
        return x509CertificateArray;
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException, IllegalArgumentException {
        this.standardTrustManager.checkClientTrusted(x509CertificateArray, string);
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws IllegalArgumentException, CertificateException {
        logger.trace(1, this.getClass(), "checkServerTrusted, authType = " + string);
        if (string == null || x509CertificateArray == null || string.length() == 0 || x509CertificateArray.length == 0) {
            throw new IllegalArgumentException("Null or zero-length parameters!!");
        }
        try {
            int n = this.theOneTrusted(x509CertificateArray, this.localCertificate);
            if (n > -1) {
                if (System.currentTimeMillis() > 3599000L) {
                    x509CertificateArray[n].checkValidity();
                }
                x509CertificateArray[n].verify(x509CertificateArray[n + 1 < x509CertificateArray.length ? n + 1 : x509CertificateArray.length - 1].getPublicKey());
            }
            logger.trace(1, this.getClass(), "Server is trusted");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.trace(1, this.getClass(), "Certificate could not be verified; no such algorithm");
            throw new CertificateException("Certificate could not be verified; no such algorithm");
        }
        catch (InvalidKeyException invalidKeyException) {
            logger.trace(1, this.getClass(), "Certificate could not be verified; invalid key");
            throw new CertificateException("Certificate could not be verified; invalid key");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            logger.trace(1, this.getClass(), "Certificate could not be verified; no such provider");
            throw new CertificateException("Certificate could not be verified; no such provider");
        }
        catch (SignatureException signatureException) {
            logger.trace(1, this.getClass(), "Certificate could not be verified; invalid signature");
            throw new CertificateException("Certificate could not be verified; invalid signature");
        }
    }

    private int theOneTrusted(X509Certificate[] x509CertificateArray, X509Certificate[] x509CertificateArray2) {
        for (int i = x509CertificateArray.length - 1; i >= 0; --i) {
            for (int j = x509CertificateArray2.length - 1; j >= 0; --j) {
                if (!x509CertificateArray[i].equals(x509CertificateArray2[j])) continue;
                return i;
            }
        }
        return -1;
    }

    private void prepareAcceptedIssuers(X509Certificate[] x509CertificateArray) {
        int n;
        X509Certificate[] x509CertificateArray2 = this.standardTrustManager.getAcceptedIssuers();
        int n2 = 0;
        X509Certificate[] x509CertificateArray3 = new X509Certificate[x509CertificateArray.length + x509CertificateArray2.length];
        for (n = 0; n < x509CertificateArray2.length; ++n) {
            x509CertificateArray3[n2++] = x509CertificateArray2[n];
        }
        for (n = 0; n < x509CertificateArray.length; ++n) {
            x509CertificateArray3[n2++] = x509CertificateArray[n];
        }
        this.acceptedIssuers = (X509Certificate[])x509CertificateArray3.clone();
    }
}

