/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.ssl;

import com.ibm.j9.bluez.crypto.CL3State;
import com.ibm.j9.bluez.crypto.HMAC;
import com.ibm.j9.ssl.HashingAlgorithmMD5;
import com.ibm.j9.ssl.HashingAlgorithmNull;
import com.ibm.j9.ssl.HashingAlgorithmSHA1;
import com.ibm.j9.ssl.Util;
import java.lang.reflect.Constructor;

public abstract class HashingAlgorithm {
    public static final int TYPE_NULL = 0;
    public static final int TYPE_SHA1 = 1;
    public static final int TYPE_MD5 = 2;

    public abstract int getHashSize();

    public abstract byte[] hashSSL(byte[] var1);

    public abstract byte[] hashTLS(byte[] var1, byte[] var2);

    public abstract byte[] getPad1();

    public abstract byte[] getPad2();

    public static HashingAlgorithm getInstance(int hashingAlgorithm) {
        HashingAlgorithm result = null;
        try {
            Class clazz = Class.forName("com.ibm.oti.crypto.JCEHashingAlgorithm");
            Constructor constructor = clazz.getConstructor(new Class[]{Integer.TYPE});
            result = (HashingAlgorithm)constructor.newInstance(new Object[]{new Integer(hashingAlgorithm)});
        }
        catch (Exception exception) {
            result = HashingAlgorithm.getHashingAlgorithm(hashingAlgorithm);
        }
        return result;
    }

    private static HashingAlgorithm getHashingAlgorithm(int typeCode) {
        switch (typeCode) {
            case 1: {
                return new HashingAlgorithmSHA1();
            }
            case 2: {
                return new HashingAlgorithmMD5();
            }
        }
        return new HashingAlgorithmNull();
    }

    public byte[] PRF(byte[] secret, String label, byte[] seed, int bytesRequired) {
        int offset = 0;
        int half = secret.length / 2;
        if (secret.length % 2 != 0) {
            ++half;
            ++offset;
        }
        byte[] S1 = new byte[half];
        byte[] S2 = new byte[half];
        System.arraycopy((Object)secret, 0, (Object)S1, 0, half);
        System.arraycopy((Object)secret, half - offset, (Object)S2, 0, half);
        byte[] newSeed = Util.concatenate(label.getBytes(), seed);
        byte[] md5Hash = this.pHash(2, S1, newSeed, bytesRequired);
        byte[] shaHash = this.pHash(1, S2, newSeed, bytesRequired);
        byte[] result = new byte[bytesRequired];
        int i = 0;
        while (i < bytesRequired) {
            result[i] = (byte)(md5Hash[i] ^ shaHash[i]);
            ++i;
        }
        return result;
    }

    protected byte[] pHash(int hashType, byte[] secret, byte[] seed, int bytesRequired) {
        int cl3Type;
        int digestSize;
        switch (hashType) {
            case 1: {
                digestSize = 20;
                cl3Type = 3;
                break;
            }
            case 2: {
                digestSize = 16;
                cl3Type = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported hashType.  Must be MD5 or SHA");
            }
        }
        int iterations = bytesRequired / digestSize;
        if (bytesRequired % digestSize > 0) {
            ++iterations;
        }
        byte[] result = new byte[iterations * digestSize];
        byte[][] A = new byte[iterations + 1][digestSize];
        A[0] = seed;
        CL3State hmac = null;
        int i = 1;
        while (i <= iterations) {
            hmac = HMAC.hmacInit(hmac, cl3Type, secret, 0, secret.length);
            HMAC.hmac(hmac, A[i - 1], 0, A[i - 1].length, A[i], 0);
            ++i;
        }
        i = 1;
        while (i <= iterations) {
            byte[] tempSeed = Util.concatenate(A[i], seed);
            hmac = HMAC.hmacInit(hmac, cl3Type, secret, 0, secret.length);
            HMAC.hmac(hmac, tempSeed, 0, tempSeed.length, result, (i - 1) * digestSize);
            ++i;
        }
        return result;
    }
}

