/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.lang;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.OutputStream;

class ProcessOutputStream
extends OutputStream {
    private long handle;
    private FileDescriptor fd = new FileDescriptor();

    static {
        ProcessOutputStream.oneTimeInitialization();
    }

    private static native void oneTimeInitialization();

    protected ProcessOutputStream(long handle) {
        this.setFDImpl(this.fd, handle);
        this.handle = handle;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        ProcessOutputStream processOutputStream = this;
        synchronized (processOutputStream) {
            if (this.handle == -1L) {
                return;
            }
            this.closeImpl();
            this.handle = -1L;
        }
    }

    private native void closeImpl() throws IOException;

    private native void setFDImpl(FileDescriptor var1, long var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] buf) throws IOException {
        ProcessOutputStream processOutputStream = this;
        synchronized (processOutputStream) {
            this.writeImpl(buf, 0, buf.length, this.handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] buf, int offset, int nbytes) throws IOException {
        ProcessOutputStream processOutputStream = this;
        synchronized (processOutputStream) {
            if (this.handle == -1L) {
                return;
            }
            this.writeImpl(buf, offset, nbytes, this.handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int oneByte) throws IOException {
        byte[] buf = new byte[]{(byte)oneByte};
        ProcessOutputStream processOutputStream = this;
        synchronized (processOutputStream) {
            this.writeImpl(buf, 0, 1, this.handle);
        }
    }

    private native void writeImpl(byte[] var1, int var2, int var3, long var4) throws IOException;
}

