/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.security.provider;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public final class ASN1OID {
    private int size = 0;
    private int[] representation = null;
    private int hashCode;

    private ASN1OID() {
    }

    public ASN1OID(int[] idValue) {
        this(idValue.length);
        this.representation = idValue;
        this.cacheHashCode();
    }

    public ASN1OID(String idValue) {
        this();
        int size;
        StringTokenizer st = new StringTokenizer(idValue, ",.");
        this.size = size = st.countTokens();
        int[] elements = new int[size];
        int i = 0;
        while (i < size) {
            elements[i] = Integer.parseInt(st.nextToken());
            ++i;
        }
        this.representation = elements;
        this.cacheHashCode();
    }

    private ASN1OID(int size) {
        this();
        this.size = size;
    }

    private void cacheHashCode() {
        this.hashCode = 0;
        if (this.representation != null) {
            int i = 0;
            while (i < this.representation.length) {
                this.hashCode += this.representation[i] & 0xFF;
                ++i;
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ASN1OID)) {
            return false;
        }
        ASN1OID other = (ASN1OID)obj;
        if (this.size != other.size) {
            return false;
        }
        if (this.representation == other.representation) {
            return true;
        }
        if (this.representation == null || other.representation == null) {
            return false;
        }
        return Arrays.equals(this.representation, other.representation);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public int[] representation() {
        return this.representation;
    }

    public static String OIDToString(int[] oid) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < oid.length - 1) {
            result.append(oid[i]);
            result.append('.');
            ++i;
        }
        result.append(oid[oid.length - 1]);
        return result.toString();
    }

    public String toString() {
        return ASN1OID.OIDToString(this.representation);
    }

    public static int[] stringToIntOID(String oid) {
        Vector list = new Vector();
        int start = 0;
        int end = 0;
        int size = 0;
        while (start < oid.length()) {
            end = oid.indexOf(".", start);
            if (end == -1) {
                end = oid.length();
            }
            list.addElement(oid.substring(start, end));
            ++size;
            start = end + 1;
        }
        Enumeration listEnum = list.elements();
        int[] res = new int[size];
        int i = 0;
        while (listEnum.hasMoreElements()) {
            res[i] = Integer.parseInt((String)listEnum.nextElement());
            ++i;
        }
        return res;
    }
}

