/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.security.provider;

import com.ibm.oti.util.ASN1Decoder;
import com.ibm.oti.util.ASN1Encoder;
import com.ibm.oti.util.ASN1Exception;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;
import java.util.Arrays;

public class DSAPrivateKey
implements java.security.interfaces.DSAPrivateKey {
    private static final long serialVersionUID = 5613814782793128447L;
    static final int[] OID = new int[]{1, 2, 840, 10040, 4, 1};
    static final int[] OIDalt = new int[]{1, 3, 14, 3, 2, 12};
    static final String ENCODING_FORMAT = "PKCS#8";
    private DSAParams parametersDSA;
    private BigInteger x;
    private byte[] encoded = null;

    public BigInteger getX() {
        return this.x;
    }

    public DSAParams getParams() {
        return this.parametersDSA;
    }

    public String getAlgorithm() {
        return "DSA";
    }

    public byte[] getEncoded() {
        if (this.encoded == null) {
            try {
                this.encoded = this.keyToPKCS8Encoding();
            }
            catch (ASN1Exception aSN1Exception) {}
        }
        return this.encoded;
    }

    byte[] keyToPKCS8Encoding() throws ASN1Exception {
        Object[] toEncode = new Object[3];
        toEncode[0] = BigInteger.ZERO;
        Object[] parameters = new Object[3];
        Object[] algIdentifier = new Object[]{OID, parameters};
        parameters[0] = this.parametersDSA.getP();
        parameters[1] = this.parametersDSA.getQ();
        parameters[2] = this.parametersDSA.getG();
        toEncode[1] = algIdentifier;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ASN1Encoder encoder = new ASN1Encoder(stream);
        encoder.writeObject(this.getX());
        toEncode[2] = stream.toByteArray();
        stream.reset();
        encoder.writeObject(toEncode);
        return stream.toByteArray();
    }

    static BigInteger[] decodePKCS8(byte[] encoded) throws ASN1Exception {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(encoded);
            ASN1Decoder decoder = new ASN1Decoder(stream);
            ASN1Decoder.Node[] decodedStructure = (ASN1Decoder.Node[])decoder.readContents().data;
            ASN1Decoder.Node[] algIdentifier = (ASN1Decoder.Node[])decodedStructure[1].data;
            if (!Arrays.equals(OID, (int[])algIdentifier[0].data) && !Arrays.equals(OIDalt, (int[])algIdentifier[0].data)) {
                throw new ASN1Exception();
            }
            BigInteger[] result = new BigInteger[4];
            ASN1Decoder.Node[] params = (ASN1Decoder.Node[])algIdentifier[1].data;
            result[0] = (BigInteger)params[0].data;
            result[1] = (BigInteger)params[1].data;
            result[2] = (BigInteger)params[2].data;
            stream = new ByteArrayInputStream((byte[])decodedStructure[2].data);
            decoder = new ASN1Decoder(stream);
            result[3] = (BigInteger)decoder.readContents().data;
            return result;
        }
        catch (ClassCastException classCastException) {
            throw new ASN1Exception();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ASN1Exception();
        }
    }

    public String getFormat() {
        return ENCODING_FORMAT;
    }

    public DSAPrivateKey(DSAParams params, BigInteger x) {
        this.parametersDSA = params;
        this.x = x;
    }

    public String toString() {
        BigInteger p = this.parametersDSA.getP();
        BigInteger q = this.parametersDSA.getQ();
        BigInteger g = this.parametersDSA.getG();
        StringBuffer result = new StringBuffer();
        result.append(this.getClass().getName());
        result.append("\n\t");
        result.append("X: ");
        result.append(this.getX().toString(16));
        result.append("\n\t");
        result.append("p: ");
        result.append(p.toString(16));
        result.append("\n\t");
        result.append("q: ");
        result.append(q.toString(16));
        result.append("\n\t");
        result.append("g: ");
        result.append(g.toString(16));
        result.append("\n");
        return result.toString();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.getEncoded());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.encoded = (byte[])stream.readObject();
        BigInteger[] result = DSAPrivateKey.decodePKCS8(this.encoded);
        this.parametersDSA = new DSAParameterSpec(result[0], result[1], result[2]);
        this.x = result[3];
    }

    public DSAPrivateKey(byte[] encoded) throws IllegalArgumentException {
        this.encoded = encoded;
        try {
            BigInteger[] result = DSAPrivateKey.decodePKCS8(encoded);
            this.parametersDSA = new DSAParameterSpec(result[0], result[1], result[2]);
            this.x = result[3];
        }
        catch (ASN1Exception aSN1Exception) {
            throw new IllegalArgumentException();
        }
    }
}

