/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.security.provider;

import com.ibm.oti.security.provider.DSAPrivateKey;
import com.ibm.oti.security.provider.DSAPublicKey;
import com.ibm.oti.util.ASN1Exception;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class KeyFactoryDSA
extends KeyFactorySpi {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DSAPrivateKeySpec) {
            DSAPrivateKeySpec privateKeySpec = (DSAPrivateKeySpec)keySpec;
            BigInteger p = privateKeySpec.getP();
            BigInteger q = privateKeySpec.getQ();
            BigInteger g = privateKeySpec.getG();
            BigInteger x = privateKeySpec.getX();
            return new DSAPrivateKey(new DSAParameterSpec(p, q, g), x);
        }
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            PKCS8EncodedKeySpec privateKeySpec = (PKCS8EncodedKeySpec)keySpec;
            byte[] encoded = privateKeySpec.getEncoded();
            try {
                BigInteger[] params = DSAPrivateKey.decodePKCS8(encoded);
                return new DSAPrivateKey(new DSAParameterSpec(params[0], params[1], params[2]), params[3]);
            }
            catch (ASN1Exception aSN1Exception) {
                throw new InvalidKeySpecException();
            }
        }
        throw new InvalidKeySpecException();
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DSAPublicKeySpec) {
            DSAPublicKeySpec publicKeySpec = (DSAPublicKeySpec)keySpec;
            BigInteger p = publicKeySpec.getP();
            BigInteger q = publicKeySpec.getQ();
            BigInteger g = publicKeySpec.getG();
            BigInteger y = publicKeySpec.getY();
            return new DSAPublicKey(new DSAParameterSpec(p, q, g), y);
        }
        if (keySpec instanceof X509EncodedKeySpec) {
            X509EncodedKeySpec publicKeySpec = (X509EncodedKeySpec)keySpec;
            byte[] encoded = publicKeySpec.getEncoded();
            try {
                Object[] result = DSAPublicKey.decodeX509(encoded);
                return new DSAPublicKey((DSAParameterSpec)result[0], (BigInteger)result[1]);
            }
            catch (ASN1Exception aSN1Exception) {
                throw new InvalidKeySpecException();
            }
        }
        throw new InvalidKeySpecException();
    }

    /*
     * Unable to fully structure code
     */
    protected KeySpec engineGetKeySpec(Key key, Class keySpec) throws InvalidKeySpecException {
        wantsPrivate = false;
        v0 = KeyFactoryDSA.class$0;
        if (v0 == null) {
            try {
                v0 = KeyFactoryDSA.class$0 = Class.forName("java.security.spec.DSAPrivateKeySpec");
            }
            catch (ClassNotFoundException v1) {
                throw new NoClassDefFoundError(v1.getMessage());
            }
        }
        if (keySpec == v0) ** GOTO lbl-1000
        v2 = KeyFactoryDSA.class$1;
        if (v2 == null) {
            try {
                v2 = KeyFactoryDSA.class$1 = Class.forName("java.security.spec.PKCS8EncodedKeySpec");
            }
            catch (ClassNotFoundException v3) {
                throw new NoClassDefFoundError(v3.getMessage());
            }
        }
        if (keySpec == v2) lbl-1000:
        // 2 sources

        {
            wantsPrivate = true;
        } else {
            v4 = KeyFactoryDSA.class$2;
            if (v4 == null) {
                try {
                    v4 = KeyFactoryDSA.class$2 = Class.forName("java.security.spec.DSAPublicKeySpec");
                }
                catch (ClassNotFoundException v5) {
                    throw new NoClassDefFoundError(v5.getMessage());
                }
            }
            if (keySpec != v4) {
                v6 = KeyFactoryDSA.class$3;
                if (v6 == null) {
                    try {
                        v6 = KeyFactoryDSA.class$3 = Class.forName("java.security.spec.X509EncodedKeySpec");
                    }
                    catch (ClassNotFoundException v7) {
                        throw new NoClassDefFoundError(v7.getMessage());
                    }
                }
                if (keySpec != v6) {
                    throw new InvalidKeySpecException();
                }
            }
        }
        format = key.getFormat();
        if ("PKCS#8".equals(format)) {
            isPrivate = true;
        } else if ("X.509".equals(format)) {
            isPrivate = false;
        } else {
            throw new InvalidKeySpecException();
        }
        if (wantsPrivate != isPrivate) {
            throw new InvalidKeySpecException();
        }
        encoded = key.getEncoded();
        try {
            if (wantsPrivate) {
                v8 = KeyFactoryDSA.class$1;
                if (v8 == null) {
                    try {
                        v8 = KeyFactoryDSA.class$1 = Class.forName("java.security.spec.PKCS8EncodedKeySpec");
                    }
                    catch (ClassNotFoundException v9) {
                        throw new NoClassDefFoundError(v9.getMessage());
                    }
                }
                if (keySpec == v8) {
                    return new PKCS8EncodedKeySpec(encoded);
                }
                params = DSAPrivateKey.decodePKCS8(encoded);
                return new DSAPrivateKeySpec(params[3], params[0], params[1], params[2]);
            }
            v10 = KeyFactoryDSA.class$3;
            if (v10 == null) {
                try {
                    v10 = KeyFactoryDSA.class$3 = Class.forName("java.security.spec.X509EncodedKeySpec");
                }
                catch (ClassNotFoundException v11) {
                    throw new NoClassDefFoundError(v11.getMessage());
                }
            }
            if (keySpec == v10) {
                return new X509EncodedKeySpec(encoded);
            }
            result = DSAPublicKey.decodeX509(encoded);
            params = (DSAParameterSpec)result[0];
            return new DSAPublicKeySpec((BigInteger)result[1], params.getP(), params.getQ(), params.getG());
        }
        catch (ASN1Exception v12) {
            throw new InvalidKeySpecException();
        }
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        boolean isPrivate;
        String format = key.getFormat();
        if ("PKCS#8".equals(format)) {
            isPrivate = true;
        } else if ("X.509".equals(format)) {
            isPrivate = false;
        } else {
            throw new InvalidKeyException();
        }
        byte[] encoded = key.getEncoded();
        try {
            if (isPrivate) {
                BigInteger[] params = DSAPrivateKey.decodePKCS8(encoded);
                return new DSAPrivateKey(new DSAParameterSpec(params[0], params[1], params[2]), params[3]);
            }
            Object[] result = DSAPublicKey.decodeX509(encoded);
            return new DSAPublicKey((DSAParameterSpec)result[0], (BigInteger)result[1]);
        }
        catch (ASN1Exception aSN1Exception) {
            throw new InvalidKeyException();
        }
    }
}

