/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.text;

import com.ibm.oti.util.Msg;
import java.lang.reflect.Array;

public final class Utility {
    static final char ESCAPE = '\ua5a5';
    static final byte ESCAPE_BYTE = -91;
    static final char[] HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static Object resizeArray(int newSize, Object oldArray, int offset, int length) {
        Class type = oldArray.getClass().getComponentType();
        Object newArray = Array.newInstance(type, newSize);
        System.arraycopy(oldArray, offset, newArray, 0, length);
        return newArray;
    }

    public static final boolean arrayEquals(Object[] source, Object target) {
        if (source == null) {
            return target == null;
        }
        if (!(target instanceof Object[])) {
            return false;
        }
        Object[] targ = (Object[])target;
        return source.length == targ.length && Utility.arrayRegionMatches(source, 0, targ, 0, source.length);
    }

    public static final boolean arrayEquals(int[] source, Object target) {
        if (source == null) {
            return target == null;
        }
        if (!(target instanceof int[])) {
            return false;
        }
        int[] targ = (int[])target;
        return source.length == targ.length && Utility.arrayRegionMatches(source, 0, targ, 0, source.length);
    }

    public static final boolean arrayEquals(double[] source, Object target) {
        if (source == null) {
            return target == null;
        }
        if (!(target instanceof double[])) {
            return false;
        }
        double[] targ = (double[])target;
        return source.length == targ.length && Utility.arrayRegionMatches(source, 0, targ, 0, source.length);
    }

    public static final boolean arrayEquals(Object source, Object target) {
        if (source == null) {
            return target == null;
        }
        if (source instanceof Object[]) {
            return Utility.arrayEquals((Object[])source, target);
        }
        if (source instanceof int[]) {
            return Utility.arrayEquals((int[])source, target);
        }
        if (source instanceof double[]) {
            return Utility.arrayEquals((int[])source, target);
        }
        return source.equals(target);
    }

    public static final boolean arrayRegionMatches(Object[] source, int sourceStart, Object[] target, int targetStart, int len) {
        int sourceEnd = sourceStart + len;
        int delta = targetStart - sourceStart;
        int i = sourceStart;
        while (i < sourceEnd) {
            if (!Utility.arrayEquals(source[i], target[i + delta])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean arrayRegionMatches(int[] source, int sourceStart, int[] target, int targetStart, int len) {
        int sourceEnd = sourceStart + len;
        int delta = targetStart - sourceStart;
        int i = sourceStart;
        while (i < sourceEnd) {
            if (source[i] != target[i + delta]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean arrayRegionMatches(double[] source, int sourceStart, double[] target, int targetStart, int len) {
        int sourceEnd = sourceStart + len;
        int delta = targetStart - sourceStart;
        int i = sourceStart;
        while (i < sourceEnd) {
            if (source[i] != target[i + delta]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean objectEquals(Object source, Object target) {
        if (source == null) {
            return target == null;
        }
        return source.equals(target);
    }

    public static final String arrayToRLEString(short[] a) {
        StringBuffer buffer = new StringBuffer();
        buffer.append((char)(a.length >> 16));
        buffer.append((char)a.length);
        short runValue = a[0];
        int runLength = 1;
        int i = 1;
        while (i < a.length) {
            short s = a[i];
            if (s == runValue && runLength < 65535) {
                ++runLength;
            } else {
                Utility.encodeRun(buffer, runValue, runLength);
                runValue = s;
                runLength = 1;
            }
            ++i;
        }
        Utility.encodeRun(buffer, runValue, runLength);
        return buffer.toString();
    }

    public static final String arrayToRLEString(byte[] a) {
        StringBuffer buffer = new StringBuffer();
        buffer.append((char)(a.length >> 16));
        buffer.append((char)a.length);
        byte runValue = a[0];
        int runLength = 1;
        byte[] state = new byte[2];
        int i = 1;
        while (i < a.length) {
            byte b = a[i];
            if (b == runValue && runLength < 255) {
                ++runLength;
            } else {
                Utility.encodeRun(buffer, runValue, runLength, state);
                runValue = b;
                runLength = 1;
            }
            ++i;
        }
        Utility.encodeRun(buffer, runValue, runLength, state);
        if (state[0] != 0) {
            Utility.appendEncodedByte(buffer, (byte)0, state);
        }
        return buffer.toString();
    }

    public static final String arrayToRLEString(char[] a) {
        StringBuffer buffer = new StringBuffer();
        buffer.append((char)(a.length >> 16));
        buffer.append((char)a.length);
        char runValue = a[0];
        int runLength = 1;
        int i = 1;
        while (i < a.length) {
            char s = a[i];
            if (s == runValue && runLength < 65535) {
                ++runLength;
            } else {
                Utility.encodeRun(buffer, (short)runValue, runLength);
                runValue = s;
                runLength = 1;
            }
            ++i;
        }
        Utility.encodeRun(buffer, (short)runValue, runLength);
        return buffer.toString();
    }

    public static final String arrayToRLEString(int[] a) {
        StringBuffer buffer = new StringBuffer();
        Utility.appendInt(buffer, a.length);
        int runValue = a[0];
        int runLength = 1;
        int i = 1;
        while (i < a.length) {
            int s = a[i];
            if (s == runValue && runLength < 65535) {
                ++runLength;
            } else {
                Utility.encodeRun(buffer, runValue, runLength);
                runValue = s;
                runLength = 1;
            }
            ++i;
        }
        Utility.encodeRun(buffer, runValue, runLength);
        return buffer.toString();
    }

    private static final void encodeRun(StringBuffer buffer, short value, int length) {
        if (length < 4) {
            int j = 0;
            while (j < length) {
                if (value == 42405) {
                    buffer.append('\ua5a5');
                }
                buffer.append((char)value);
                ++j;
            }
        } else {
            if (length == 42405) {
                if (value == 42405) {
                    buffer.append('\ua5a5');
                }
                buffer.append((char)value);
                --length;
            }
            buffer.append('\ua5a5');
            buffer.append((char)length);
            buffer.append((char)value);
        }
    }

    private static final void encodeRun(StringBuffer buffer, byte value, int length, byte[] state) {
        if (length < 4) {
            int j = 0;
            while (j < length) {
                if (value == -91) {
                    Utility.appendEncodedByte(buffer, (byte)-91, state);
                }
                Utility.appendEncodedByte(buffer, value, state);
                ++j;
            }
        } else {
            if (length == -91) {
                if (value == -91) {
                    Utility.appendEncodedByte(buffer, (byte)-91, state);
                }
                Utility.appendEncodedByte(buffer, value, state);
                --length;
            }
            Utility.appendEncodedByte(buffer, (byte)-91, state);
            Utility.appendEncodedByte(buffer, (byte)length, state);
            Utility.appendEncodedByte(buffer, value, state);
        }
    }

    private static final void encodeRun(StringBuffer buffer, int value, int length) {
        if (length < 4) {
            int j = 0;
            while (j < length) {
                if (value == 42405) {
                    Utility.appendInt(buffer, value);
                }
                Utility.appendInt(buffer, value);
                ++j;
            }
        } else {
            if (length == 42405) {
                if (value == 42405) {
                    Utility.appendInt(buffer, 42405);
                }
                Utility.appendInt(buffer, value);
                --length;
            }
            Utility.appendInt(buffer, 42405);
            Utility.appendInt(buffer, length);
            Utility.appendInt(buffer, value);
        }
    }

    private static final void appendInt(StringBuffer buffer, int value) {
        buffer.append((char)(value >>> 16));
        buffer.append((char)(value & 0xFFFF));
    }

    private static final void appendEncodedByte(StringBuffer buffer, byte value, byte[] state) {
        if (state[0] != 0) {
            char c = (char)(state[1] << 8 | value & 0xFF);
            buffer.append(c);
            state[0] = 0;
        } else {
            state[0] = 1;
            state[1] = value;
        }
    }

    public static final short[] RLEStringToShortArray(String s) {
        int length = s.charAt(0) << 16 | s.charAt(1);
        short[] array = new short[length];
        int ai = 0;
        int i = 2;
        while (i < s.length()) {
            int c = s.charAt(i);
            if (c == 42405) {
                if ((c = s.charAt(++i)) == 42405) {
                    array[ai++] = (short)c;
                } else {
                    int runLength = c;
                    short runValue = (short)s.charAt(++i);
                    int j = 0;
                    while (j < runLength) {
                        array[ai++] = runValue;
                        ++j;
                    }
                }
            } else {
                array[ai++] = (short)c;
            }
            ++i;
        }
        if (ai != length) {
            throw new InternalError(Msg.getString("K033a"));
        }
        return array;
    }

    public static final byte[] RLEStringToByteArray(String s) {
        int length = s.charAt(0) << 16 | s.charAt(1);
        byte[] array = new byte[length];
        boolean nextChar = true;
        int c = 0;
        int node = 0;
        int runLength = 0;
        int i = 2;
        int ai = 0;
        while (ai < length) {
            int b;
            if (nextChar) {
                c = s.charAt(i++);
                b = (byte)(c >> 8);
                nextChar = false;
            } else {
                b = c & 0xFF;
                nextChar = true;
            }
            switch (node) {
                case 0: {
                    if (b == -91) {
                        node = 1;
                        break;
                    }
                    array[ai++] = b;
                    break;
                }
                case 1: {
                    if (b == -91) {
                        array[ai++] = -91;
                        node = 0;
                        break;
                    }
                    runLength = b;
                    if (runLength < 0) {
                        runLength += 256;
                    }
                    node = 2;
                    break;
                }
                case 2: {
                    int j = 0;
                    while (j < runLength) {
                        array[ai++] = b;
                        ++j;
                    }
                    node = 0;
                }
            }
        }
        if (node != 0) {
            throw new InternalError(Msg.getString("K033a"));
        }
        if (i != s.length()) {
            throw new InternalError(Msg.getString("K0ab2"));
        }
        return array;
    }

    public static final char[] RLEStringToCharArray(String s) {
        int length = s.charAt(0) << 16 | s.charAt(1);
        char[] array = new char[length];
        int ai = 0;
        int i = 2;
        while (i < s.length()) {
            int c = s.charAt(i);
            if (c == 42405) {
                if ((c = s.charAt(++i)) == 42405) {
                    array[ai++] = c;
                } else {
                    int runLength = c;
                    char runValue = s.charAt(++i);
                    int j = 0;
                    while (j < runLength) {
                        array[ai++] = runValue;
                        ++j;
                    }
                }
            } else {
                array[ai++] = c;
            }
            ++i;
        }
        if (ai != length) {
            throw new InternalError(Msg.getString("K033a"));
        }
        return array;
    }

    public static final int[] RLEStringToIntArray(String s) {
        int length = Utility.getInt(s, 0);
        int[] array = new int[length];
        int ai = 0;
        int i = 1;
        int maxI = s.length() / 2;
        while (ai < length && i < maxI) {
            int c;
            if ((c = Utility.getInt(s, i++)) == 42405) {
                if ((c = Utility.getInt(s, i++)) == 42405) {
                    array[ai++] = c;
                    continue;
                }
                int runLength = c;
                int runValue = Utility.getInt(s, i++);
                int j = 0;
                while (j < runLength) {
                    array[ai++] = runValue;
                    ++j;
                }
                continue;
            }
            array[ai++] = c;
        }
        if (ai != length || i != maxI) {
            throw new InternalError(Msg.getString("K033a"));
        }
        return array;
    }

    public static final String hex(char ch) {
        StringBuffer buff = new StringBuffer();
        return Utility.hex(ch, buff).toString();
    }

    public static final StringBuffer hex(String src, StringBuffer buff) {
        if (src != null && buff != null) {
            int strLen = src.length();
            int x = 0;
            Utility.hex(src.charAt(x), buff);
            while (x < strLen) {
                buff.append(',');
                Utility.hex(src.charAt(x++), buff);
            }
        }
        return buff;
    }

    public static final String hex(String str) {
        StringBuffer buff = new StringBuffer();
        Utility.hex(str, buff);
        return buff.toString();
    }

    public static final String hex(StringBuffer buff) {
        return Utility.hex(buff.toString());
    }

    public static final StringBuffer hex(char ch, StringBuffer buff) {
        int shift = 12;
        while (shift >= 0) {
            buff.append(HEX_DIGIT[(byte)(ch >> shift & 0xF)]);
            shift -= 4;
        }
        return buff;
    }

    static final int getInt(String s, int i) {
        return s.charAt(2 * i) << 16 | s.charAt(2 * i + 1);
    }
}

