/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.util;

import com.ibm.oti.util.Msg;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.Security;
import java.security.UnresolvedPermission;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.PropertyPermission;
import java.util.Vector;
import java.util.WeakHashMap;

public class DefaultPolicy
extends Policy {
    private Vector grantList = new Vector();
    private boolean policyRead = false;
    private Map cache = Collections.synchronizedMap(new WeakHashMap());
    static /* synthetic */ Class class$0;

    public PermissionCollection getPermissions(final CodeSource cs) {
        PermissionCollection cachedCollection = (PermissionCollection)this.cache.get(cs);
        if (cachedCollection != null) {
            return this.copyCollection(cachedCollection);
        }
        PermissionCollection pc = (PermissionCollection)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return DefaultPolicy.this.getPermissionsImpl(cs);
            }
        });
        this.cache.put(cs, this.copyCollection(pc));
        return pc;
    }

    private PermissionCollection copyCollection(PermissionCollection pc) {
        Permissions newCollection = new Permissions();
        Enumeration e = pc.elements();
        while (e.hasMoreElements()) {
            ((PermissionCollection)newCollection).add((Permission)e.nextElement());
        }
        return newCollection;
    }

    PermissionCollection getPermissionsImpl(CodeSource cs) {
        this.getSystemPolicy();
        URL hisURL = cs.getLocation() != null ? DefaultPolicy.toCanonicalURL(cs.getLocation()) : null;
        Permissions pc = new Permissions();
        CodeSource hisCS = new CodeSource(hisURL, cs.getCertificates());
        int i = 0;
        while (i < this.grantList.size()) {
            GrantHolder grant = (GrantHolder)this.grantList.elementAt(i);
            if (grant.getCodeSource() == null || grant.getCodeSource().implies(hisCS)) {
                Permissions grantPermissions = grant.getPermissions();
                Enumeration ePerm = grantPermissions.elements();
                while (ePerm.hasMoreElements()) {
                    ((PermissionCollection)pc).add((Permission)ePerm.nextElement());
                }
            }
            ++i;
        }
        return pc;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private KeyStore loadKeystore(URL source, String[] keystoreData) {
        BufferedInputStream is = null;
        try {
            URL keystoreURL = new URL(source, keystoreData[0]);
            is = new BufferedInputStream(keystoreURL.openStream());
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {}
        try {
            String keystoreType = keystoreData[1];
            if (keystoreType == null) {
                keystoreType = KeyStore.getDefaultType();
            }
            KeyStore keystore = KeyStore.getInstance(keystoreType);
            keystore.load(is, null);
            KeyStore keyStore = keystore;
            if (is == null) return keyStore;
            try {
                is.close();
                return keyStore;
            }
            catch (IOException iOException) {}
            return keyStore;
        }
        catch (KeyStoreException keyStoreException) {
            try {
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                }
                catch (CertificateException certificateException) {
                }
                catch (IOException iOException) {
                }
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        if (is == null) return null;
        try {
            is.close();
            return null;
        }
        catch (IOException iOException) {}
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readPolicy(InputStream data, URL source, boolean allowExpand) {
        if (data == null) {
            return;
        }
        InputStreamReader dataReader = null;
        try {
            dataReader = new InputStreamReader(data, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return;
        }
        PolicyTokenizer parser = new PolicyTokenizer(dataReader);
        String[] keystoreData = null;
        Vector thisPolicyGrantList = new Vector();
        Vector unresolvedGrants = new Vector();
        int tokenType = parser.nextToken();
        while (!parser.isAtEOF()) {
            block32: {
                block35: {
                    block36: {
                        if (tokenType != 1) break block35;
                        if (!parser.sval.equalsIgnoreCase("grant")) break block36;
                        this.parseGrant(parser, source, thisPolicyGrantList, unresolvedGrants, allowExpand);
                        break block32;
                    }
                    if (parser.sval.equalsIgnoreCase("keystore")) {
                        if (keystoreData != null) {
                            parser.skipTokens(';');
                            break block32;
                        } else {
                            keystoreData = new String[2];
                            this.parseKeystore(parser, keystoreData, allowExpand);
                        }
                        break block32;
                    } else {
                        this.grantList.removeAllElements();
                        break;
                    }
                }
                this.grantList.removeAllElements();
                break;
            }
            tokenType = parser.nextToken();
        }
        boolean loadedKeystore = false;
        KeyStore keystore = null;
        int i = 0;
        while (i < unresolvedGrants.size()) {
            GrantHolder thisGrant = (GrantHolder)((Object[])unresolvedGrants.get(i))[0];
            String[] unresolvedPermissionAttributes = (String[])((Object[])unresolvedGrants.get(i))[1];
            Certificate[] certs = null;
            String signedBy = unresolvedPermissionAttributes[3];
            if (signedBy != null && !loadedKeystore) {
                loadedKeystore = true;
                keystore = this.loadKeystore(source, keystoreData);
            }
            if (signedBy != null && keystore != null) {
                int length = signedBy.length();
                int start = 0;
                int end = 0;
                while (end < length) {
                    end = signedBy.indexOf(44, start);
                    if (end == -1) {
                        end = length;
                    }
                    if (start < end) {
                        String part = signedBy.substring(start, end).trim();
                        Certificate cert = null;
                        try {
                            cert = keystore.getCertificate(part);
                        }
                        catch (KeyStoreException keyStoreException) {
                            cert = null;
                        }
                        if (cert == null) {
                            certs = null;
                            break;
                        }
                        if (certs == null) {
                            certs = new Certificate[]{cert};
                        } else {
                            Certificate[] tempCerts = new Certificate[certs.length + 1];
                            System.arraycopy((Object)certs, 0, (Object)tempCerts, 0, certs.length);
                            tempCerts[tempCerts.length - 1] = cert;
                            certs = tempCerts;
                        }
                    }
                    start = end + 1;
                }
            }
            if (certs != null) {
                String permissionClass = unresolvedPermissionAttributes[0];
                String permissionName = unresolvedPermissionAttributes[1];
                String permissionAction = unresolvedPermissionAttributes[2];
                thisGrant.addPermission(new UnresolvedPermission(permissionClass, permissionName, permissionAction, certs));
            }
            ++i;
        }
        Enumeration e = thisPolicyGrantList.elements();
        while (e.hasMoreElements()) {
            GrantHolder grant = (GrantHolder)e.nextElement();
            Certificate[] certs = null;
            String signedBy = grant.getSigner();
            if (signedBy != null && !loadedKeystore) {
                loadedKeystore = true;
                keystore = this.loadKeystore(source, keystoreData);
            }
            if (signedBy != null && keystore != null) {
                int length = signedBy.length();
                int start = 0;
                int end = 0;
                while (end < length) {
                    end = signedBy.indexOf(44, start);
                    if (end == -1) {
                        end = length;
                    }
                    if (start < end) {
                        String part = signedBy.substring(start, end).trim();
                        Certificate cert = null;
                        try {
                            cert = keystore.getCertificate(part);
                        }
                        catch (KeyStoreException keyStoreException) {
                            cert = null;
                        }
                        if (cert == null) {
                            certs = null;
                            break;
                        }
                        if (certs == null) {
                            certs = new Certificate[]{cert};
                        } else {
                            Certificate[] tempCerts = new Certificate[certs.length + 1];
                            System.arraycopy((Object)certs, 0, (Object)tempCerts, 0, certs.length);
                            tempCerts[tempCerts.length - 1] = cert;
                            certs = tempCerts;
                        }
                    }
                    start = end + 1;
                }
            }
            if (certs != null) {
                CodeSource cs = new CodeSource(grant.getCodeSource().getLocation(), certs);
                grant.setCodeSource(cs);
            }
            if (signedBy != null && certs == null) continue;
            this.addGrant(grant);
        }
        this.policyRead = true;
    }

    private void addGrant(GrantHolder grant) {
        grant.setSigner(null);
        int i = 0;
        while (i < this.grantList.size()) {
            GrantHolder existingGrant = (GrantHolder)this.grantList.elementAt(i);
            if (existingGrant.getCodeSource().equals(grant.getCodeSource())) {
                Enumeration egl = grant.getPermissions().elements();
                while (egl.hasMoreElements()) {
                    existingGrant.addPermission((Permission)egl.nextElement());
                }
                return;
            }
            ++i;
        }
        this.grantList.addElement(grant);
    }

    private void parseKeystore(PolicyTokenizer parser, String[] values, boolean allowExpand) {
        int expect = 1;
        while (!parser.isAtEOF()) {
            switch (parser.nextToken()) {
                case 0: {
                    if (parser.cval != ';') break;
                    return;
                }
                case 2: {
                    if (expect == 1) {
                        expect = 2;
                        String keyURL = this.expandTags(parser.sval, true, allowExpand);
                        values[0] = keyURL.replace('\\', '/');
                        break;
                    }
                    if (expect != 2) break;
                    expect = 3;
                    values[1] = parser.sval;
                    break;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseGrant(PolicyTokenizer parser, URL source, Vector thisPolicyGrantList, Vector unresolvedGrants, boolean allowExpand) {
        boolean invalidGrant = false;
        String codeBase = null;
        String signedBy = null;
        while (!parser.isAtEOF()) {
            if (parser.nextToken() == 0) {
                if (parser.cval == '{') break;
                if (parser.cval == ',' && (codeBase != null || signedBy != null)) continue;
                parser.sval = String.valueOf(parser.cval);
            }
            if (parser.sval.equalsIgnoreCase("codeBase")) {
                if (parser.nextToken() != 2) {
                    System.out.println(Msg.getString("K00a2", new Object[]{source, "codeBase", parser.sval}));
                    invalidGrant = true;
                    break;
                }
                codeBase = this.expandTags(parser.sval, false, allowExpand);
                if (codeBase == null) {
                    invalidGrant = true;
                    break;
                }
                codeBase = codeBase.replace('\\', '/');
                continue;
            }
            if (parser.sval.equalsIgnoreCase("signedBy")) {
                if (parser.nextToken() != 2) {
                    System.out.println(Msg.getString("K00a2", new Object[]{source, "signedBy", parser.sval}));
                    invalidGrant = true;
                    continue;
                }
                signedBy = parser.sval;
                continue;
            }
            System.out.println(Msg.getString("K00a3", source, parser.sval));
            invalidGrant = true;
            break;
        }
        GrantHolder thisGrant = null;
        try {
            CodeSource grantCS = null;
            URL hisURL = null;
            if (codeBase != null) {
                hisURL = DefaultPolicy.toCanonicalURL(new URL(codeBase));
            }
            grantCS = new CodeSource(hisURL, null);
            if (thisGrant == null) {
                thisGrant = new GrantHolder();
            }
            thisGrant.setCodeSource(grantCS);
        }
        catch (MalformedURLException malformedURLException) {
            invalidGrant = true;
            System.out.println(Msg.getString("K00a8", source, codeBase));
        }
        if (invalidGrant) {
            parser.skipTokens('}');
            parser.skipTokens(';');
            return;
        }
        thisGrant.setSigner(signedBy);
        int expect = 2;
        String permissionClass = null;
        String permissionName = null;
        String permissionAction = null;
        String permissionSigners = null;
        block13: while (!parser.isAtEOF()) {
            int type = parser.nextToken();
            if (type == 0) {
                if (parser.cval == '}') {
                    if (parser.nextToken() == 0) {
                        if (parser.cval == ';') break;
                        parser.sval = String.valueOf(parser.cval);
                    }
                    type = -1;
                } else {
                    if (parser.cval == ';') {
                        if (!(permissionName != null && (permissionName = this.expandTags(permissionName, false, allowExpand)) == null || permissionAction != null && (permissionAction = this.expandTags(permissionAction, false, allowExpand)) == null)) {
                            Permission newPermission = this.createPermission(permissionClass, permissionName, permissionAction);
                            if (newPermission != null) {
                                thisGrant.addPermission(newPermission);
                            } else if (permissionSigners == null) {
                                thisGrant.addPermission(new UnresolvedPermission(permissionClass, permissionName, permissionAction, null));
                            } else if (!permissionSigners.equals("")) {
                                String[] unresolvedPermissionAttributes = new String[]{permissionClass, permissionName, permissionAction, permissionSigners};
                                Object[] unresolvedGrant = new Object[]{thisGrant, unresolvedPermissionAttributes};
                                unresolvedGrants.add(unresolvedGrant);
                            }
                        }
                        permissionClass = null;
                        permissionName = null;
                        permissionAction = null;
                        expect = 2;
                        continue;
                    }
                    if (parser.cval == ',') continue;
                    parser.sval = String.valueOf(parser.cval);
                }
            }
            if (type == 2) {
                switch (expect) {
                    case 4: {
                        permissionName = parser.sval;
                        expect = 5;
                        continue block13;
                    }
                    case 5: {
                        permissionAction = parser.sval;
                        expect = 3;
                        continue block13;
                    }
                    case 6: {
                        permissionSigners = parser.sval;
                        expect = 0;
                        continue block13;
                    }
                }
            } else if (type == 1) {
                switch (expect) {
                    case 1: {
                        permissionClass = parser.sval;
                        expect = 4;
                        continue block13;
                    }
                    case 2: {
                        if (!parser.sval.equalsIgnoreCase("permission")) break;
                        expect = 1;
                        continue block13;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        if (!parser.sval.equalsIgnoreCase("signedBy")) break;
                        expect = 6;
                        continue block13;
                    }
                }
            }
            System.out.println(Msg.getString("K00a3", new Object[]{source, parser.sval}));
            invalidGrant = true;
            break;
        }
        if (!invalidGrant || thisGrant.getPermissions() == null) {
            thisPolicyGrantList.addElement(thisGrant);
        }
    }

    Permission createPermission(String permissionClass, String permissionName, String permissionAction) {
        try {
            Class pc = Class.forName(permissionClass);
            Class[] classArray = new Class[2];
            Class clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz2;
            Constructor pcc = pc.getConstructor(classArray);
            return (Permission)pcc.newInstance(new Object[]{permissionName, permissionAction});
        }
        catch (Exception exception) {
            return null;
        }
    }

    private synchronized void getSystemPolicy() {
        String policyFile;
        InputStream in;
        URL policyURL;
        String policyFile2;
        boolean allowPropertyPolicies;
        if (this.policyRead) {
            return;
        }
        boolean allowExpandProperties = !"false".equalsIgnoreCase(Security.getProperty("policy.expandProperties"));
        boolean bl = allowPropertyPolicies = !"false".equalsIgnoreCase(Security.getProperty("allowSystemProperty"));
        if (allowPropertyPolicies && (policyFile2 = System.getProperty("java.security.policy")) != null) {
            boolean exclusiveFile;
            boolean bl2 = exclusiveFile = policyFile2.charAt(0) == '=';
            if (exclusiveFile) {
                policyFile2 = policyFile2.substring(1);
            }
            try {
                try {
                    policyURL = new URL(policyFile2);
                }
                catch (MalformedURLException malformedURLException) {
                    policyURL = new URL("file:" + policyFile2);
                }
                in = policyURL.openStream();
                this.readPolicy(in, policyURL, allowExpandProperties);
                in.close();
            }
            catch (IOException iOException) {}
            if (exclusiveFile) {
                return;
            }
        }
        int policyNum = 1;
        while ((policyFile = Security.getProperty("policy.url." + policyNum++)) != null) {
            try {
                policyURL = new URL(this.expandTags(policyFile, false, true).replace('\\', '/'));
                in = policyURL.openStream();
                this.readPolicy(in, policyURL, allowExpandProperties);
                in.close();
            }
            catch (IOException iOException) {}
        }
        if (!this.policyRead) {
            this.grantList.removeAllElements();
            GrantHolder defaultGrant = new GrantHolder();
            Permission[] defaults = DefaultPolicy.defaultSystemPermissionList();
            int i = 0;
            while (i < defaults.length) {
                defaultGrant.addPermission(defaults[i]);
                ++i;
            }
            this.policyRead = true;
            this.grantList.addElement(defaultGrant);
            try {
                String javaHome = System.getProperty("java.home");
                CodeSource extensionCS = new CodeSource(new File(javaHome, "lib/ext/*").toURL(), null);
                GrantHolder extensionGrant = new GrantHolder();
                extensionGrant.setCodeSource(extensionCS);
                extensionGrant.addPermission(new AllPermission());
                this.grantList.addElement(extensionGrant);
            }
            catch (MalformedURLException malformedURLException) {}
        }
    }

    public void refresh() {
        this.policyRead = false;
        this.cache.clear();
        this.grantList.removeAllElements();
    }

    String expandTags(String text, boolean allowBlankProperties, boolean allowExpand) {
        if (!allowExpand) {
            return text;
        }
        StringBuffer textBuf = null;
        int curPos = 0;
        int length = text.length();
        while (curPos < length) {
            int nextToken = text.indexOf("${", curPos);
            if (nextToken == -1) {
                if (curPos == 0) {
                    return text;
                }
                textBuf.append(text.substring(curPos));
                break;
            }
            if (textBuf == null) {
                textBuf = new StringBuffer(text.length() * 2);
            }
            int tagEnd = text.indexOf(125, nextToken);
            textBuf.append(text.substring(curPos, nextToken));
            if (tagEnd > nextToken) {
                curPos = tagEnd + 1;
                String tagVal = this.expandProperty(text.substring(nextToken + 2, tagEnd));
                if (tagVal != null) {
                    char ch;
                    textBuf.append(tagVal);
                    if (tagVal.length() <= 0 || (ch = tagVal.charAt(tagVal.length() - 1)) != '\\' && ch != '/' || curPos >= length || (ch = text.charAt(curPos)) != '\\' && ch != '/') continue;
                    ++curPos;
                    continue;
                }
                if (allowBlankProperties) continue;
                return null;
            }
            curPos = nextToken + 2;
            textBuf.append("${");
        }
        return textBuf == null ? text : textBuf.toString();
    }

    String expandProperty(String tag) {
        if (tag.equals("/")) {
            tag = "file.separator";
        }
        return System.getProperty(tag);
    }

    private static Permission[] defaultSystemPermissionList() {
        return new Permission[]{new RuntimePermission("exitVM"), new SocketPermission("localhost:1024-", "listen"), new PropertyPermission("java.version", "read"), new PropertyPermission("java.vendor", "read"), new PropertyPermission("java.vendor.url", "read"), new PropertyPermission("java.class.version", "read"), new PropertyPermission("os.name", "read"), new PropertyPermission("os.version", "read"), new PropertyPermission("os.arch", "read"), new PropertyPermission("file.separator", "read"), new PropertyPermission("path.separator", "read"), new PropertyPermission("line.separator", "read"), new PropertyPermission("java.specification.version", "read"), new PropertyPermission("java.specification.vendor", "read"), new PropertyPermission("java.specification.name", "read"), new PropertyPermission("java.vm.specification.version", "read"), new PropertyPermission("java.vm.specification.vendor", "read"), new PropertyPermission("java.vm.specification.name", "read"), new PropertyPermission("java.vm.version", "read"), new PropertyPermission("java.vm.vendor", "read"), new PropertyPermission("java.vm.name", "read")};
    }

    private static URL toCanonicalURL(URL orgURL) {
        if (orgURL.getProtocol().equals("jar")) {
            try {
                JarURLConnection jarCon = (JarURLConnection)orgURL.openConnection();
                String jarURL = DefaultPolicy.toCanonicalURL(jarCon.getJarFileURL()).toString();
                String entryName = jarCon.getEntryName();
                if (entryName == null) {
                    entryName = "";
                }
                jarURL = new StringBuffer(jarURL.length() + entryName.length() + 2).append(jarURL).append("!/").append(entryName).toString();
                return new URL("jar", null, -1, jarURL);
            }
            catch (IOException iOException) {}
        }
        if (orgURL.getProtocol().equals("file")) {
            String host;
            String fileName = orgURL.getFile();
            if (fileName == null) {
                fileName = "";
            }
            if ((host = orgURL.getHost()) != null && host.length() > 0) {
                fileName = new StringBuffer(host.length() + fileName.length() + 2).append("//").append(host).append(fileName).toString();
            }
            try {
                return new File(fileName).toURL();
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return orgURL;
    }

    static class GrantHolder {
        private CodeSource codeSource;
        private String signedBy;
        private Permissions permissions;

        GrantHolder() {
        }

        void setCodeSource(CodeSource codeSource) {
            this.codeSource = codeSource;
        }

        CodeSource getCodeSource() {
            return this.codeSource;
        }

        Permissions getPermissions() {
            return this.permissions;
        }

        void setSigner(String signedBy) {
            this.signedBy = signedBy;
        }

        String getSigner() {
            return this.signedBy;
        }

        void addPermission(Permission permission) {
            if (this.permissions == null) {
                this.permissions = new Permissions();
            }
            this.permissions.add(permission);
        }
    }

    static class PolicyTokenizer {
        private static final int EOL = 10;
        static final int TOK_CHAR = 0;
        static final int TOK_STRING = 1;
        static final int TOK_QUOTEDSTRING = 2;
        private InputStreamReader policyData;
        private char[] inbuf = new char[1024];
        private int inbufCount = 0;
        private int inbufPos = 0;
        private boolean endOfFile = false;
        String sval;
        char cval;
        private char[] buf = new char[120];

        PolicyTokenizer(InputStreamReader policyData) {
            this.policyData = policyData;
        }

        private void ignoreToEOL() throws IOException {
            do {
                if (this.inbufPos != this.inbufCount) continue;
                this.inbufCount = this.policyData.read(this.inbuf);
                if (this.inbufCount == -1) {
                    this.inbufPos = -1;
                    this.endOfFile = true;
                    break;
                }
                this.inbufPos = 0;
            } while (this.inbuf[this.inbufPos++] != '\n');
        }

        private void findEndOfComment() throws IOException {
            char lastChar = '\u0000';
            while (true) {
                char c;
                if (this.inbufPos == this.inbufCount) {
                    this.inbufCount = this.policyData.read(this.inbuf);
                    if (this.inbufCount == -1) {
                        this.inbufPos = -1;
                        this.endOfFile = true;
                        break;
                    }
                    this.inbufPos = 0;
                }
                if ((c = this.inbuf[this.inbufPos++]) == '/' && lastChar == '*') break;
                lastChar = c;
            }
        }

        boolean isAtEOF() {
            return this.endOfFile;
        }

        int nextToken() {
            boolean insideQuotes = false;
            int lastChar = 32;
            int length = 0;
            try {
                while (true) {
                    int c;
                    if (this.inbufPos == this.inbufCount) {
                        this.inbufCount = this.policyData.read(this.inbuf);
                        if (this.inbufCount == -1) {
                            this.inbufPos = -1;
                            this.endOfFile = true;
                            break;
                        }
                        this.inbufPos = 0;
                    }
                    if ((c = this.inbuf[this.inbufPos++]) == 10 || c == 13 || c == 9) {
                        c = 32;
                    }
                    if (c == 92 && lastChar == 92) {
                        lastChar = 32;
                        continue;
                    }
                    if (insideQuotes) {
                        if (c == 34 && lastChar != 92) {
                            break;
                        }
                    } else {
                        if (c == 32) {
                            if (length == 0) {
                                continue;
                            }
                            break;
                        }
                        if (c == 59 || c == 44 || c == 123 || c == 125) {
                            if (length == 0) {
                                this.cval = (char)c;
                                return 0;
                            }
                            --this.inbufPos;
                            break;
                        }
                        if (c == 34 && lastChar != 92) {
                            if (length > 0) {
                                --this.inbufPos;
                                break;
                            }
                            insideQuotes = true;
                            continue;
                        }
                        if (c == 47 && lastChar == 47) {
                            length = 0;
                            this.ignoreToEOL();
                            lastChar = 32;
                            continue;
                        }
                        if (c == 42 && lastChar == 47) {
                            --length;
                            lastChar = c;
                            this.findEndOfComment();
                            continue;
                        }
                    }
                    if (length == this.buf.length) {
                        char[] newBuf = new char[this.buf.length * 2];
                        System.arraycopy((Object)this.buf, 0, (Object)newBuf, 0, length);
                        this.buf = newBuf;
                    }
                    this.buf[length++] = c;
                    lastChar = c;
                }
            }
            catch (IOException iOException) {
                this.endOfFile = true;
            }
            this.sval = new String(this.buf, 0, length);
            if (insideQuotes) {
                return 2;
            }
            return 1;
        }

        void skipTokens(char stopChar) {
            while (!this.endOfFile) {
                if (this.nextToken() == 0 && this.cval == stopChar) break;
            }
        }
    }
}

