/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class OIDDatabase {
    private static OIDDatabase instance = new OIDDatabase();
    private Set oids = new HashSet();
    private Set algorithms = new HashSet();

    private OIDDatabase() {
        DBEntry oid = new DBEntry("1.2.840.113549.1.1.2");
        DBEntry alg = new DBEntry("MD2withRSA");
        this.wireTogether(oid, alg);
        oid = new DBEntry("1.2.840.113549.1.1.4");
        alg = new DBEntry("MD5withRSA");
        this.wireTogether(oid, alg);
        oid = new DBEntry("1.2.840.113549.1.1.5");
        alg = new DBEntry("SHA1withRSA");
        this.wireTogether(oid, alg);
        oid = new DBEntry("1.2.840.10040.4.3");
        alg = new DBEntry("SHA1withDSA");
        this.wireTogether(oid, alg);
        oid = new DBEntry("1.3.14.3.2.26");
        alg = new DBEntry("SHA");
        DBEntry alg2 = new DBEntry("SHA-1");
        this.wireTogether(oid, alg);
        this.wireTogether(oid, alg2);
        oid = new DBEntry("1.2.840.113549.2.5");
        alg = new DBEntry("MD5");
        this.wireTogether(oid, alg);
        oid = new DBEntry("1.2.840.113549.1.1.1");
        alg = new DBEntry("RSA");
        this.wireTogether(oid, alg);
        oid = new DBEntry("1.2.840.10040.4.1");
        DBEntry oid2 = new DBEntry("1.3.14.3.2.12");
        alg = new DBEntry("DSA");
        this.wireTogether(oid, alg);
        this.wireTogether(oid2, alg);
        oid = new DBEntry("1.2.840.10046.2.1");
        alg = new DBEntry("DiffieHellman");
        this.wireTogether(oid, alg);
    }

    private void wireTogether(DBEntry oidValue, DBEntry algorithmValue) {
        this.oids.add(oidValue);
        this.algorithms.add(algorithmValue);
        oidValue.addEquivalent(algorithmValue);
        algorithmValue.addEquivalent(oidValue);
    }

    public static OIDDatabase getInstance() {
        return instance;
    }

    public String getFirstAlgorithmForOID(String oid) {
        String result = null;
        Iterator it = this.getAllAlgorithmsForOID(oid).iterator();
        if (it.hasNext()) {
            result = (String)it.next();
        }
        return result;
    }

    public Set getAllAlgorithmsForOID(String oid) {
        Set result = null;
        Iterator it = this.oids.iterator();
        result = this.getAllEquivalents(oid, it);
        if (result == null) {
            throw new IllegalArgumentException("Unknown OID : " + oid);
        }
        return result;
    }

    public String getFirstOIDForAlgorithm(String algorithm) {
        String result = null;
        Iterator it = this.getAllOIDsForAlgorithm(algorithm).iterator();
        if (it.hasNext()) {
            result = (String)it.next();
        }
        return result;
    }

    public Set getAllOIDsForAlgorithm(String algorithm) {
        Set result = null;
        Iterator it = this.algorithms.iterator();
        result = this.getAllEquivalents(algorithm, it);
        if (result == null) {
            throw new IllegalArgumentException("Unsupported algorithm : " + algorithm);
        }
        return result;
    }

    private Set getAllEquivalents(String value, Iterator it) {
        HashSet result = null;
        while (it.hasNext()) {
            DBEntry element = (DBEntry)it.next();
            if (!element.getValue().equals(value)) continue;
            Set allMatchingDBEntries = element.getAllEquivalents();
            result = new HashSet();
            Iterator dbIt = allMatchingDBEntries.iterator();
            while (dbIt.hasNext()) {
                DBEntry matchingEntry = (DBEntry)dbIt.next();
                result.add(matchingEntry.getValue());
            }
        }
        return result;
    }

    static class DBEntry {
        private List equivalents = new LinkedList();
        private String value;

        DBEntry(String value) {
            this.value = value;
        }

        void addEquivalent(DBEntry entry) {
            this.equivalents.add(entry);
        }

        String getValue() {
            return this.value;
        }

        Set getAllEquivalents() {
            return new HashSet(this.equivalents);
        }
    }
}

