/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.vm;

import com.ibm.oti.net.www.protocol.jar.JarURLConnection;
import com.ibm.oti.util.DeleteOnExit;
import com.ibm.oti.util.Msg;
import com.ibm.oti.util.Util;
import com.ibm.oti.vm.Jxe;
import java.io.IOException;
import java.util.Vector;

public final class VM {
    private static Vector shutdownHooks = new Vector();
    private static boolean shutdown = false;
    private static final RuntimePermission shutdownHooksPermission = new RuntimePermission("shutdownHooks");
    private static boolean closeJars = false;
    private static boolean deleteOnExit = false;
    private static Vector shutdownClasses = new Vector(4);
    static final int CPE_TYPE_UNKNOWN = 0;
    static final int CPE_TYPE_DIRECTORY = 1;
    static final int CPE_TYPE_JAR = 2;
    static final int CPE_TYPE_TCP = 3;
    static final int CPE_TYPE_JXE = 4;
    static final int CPE_TYPE_UNUSABLE = 5;
    static final int CPE_TYPE_PALMDB = 6;
    static final int CPE_TYPE_ODC = 7;
    static final int CPE_TYPE_JXESL = 8;

    private VM() {
    }

    static final native Class getStackClass(int var0);

    static final native ClassLoader getStackClassLoader(int var0);

    public static final native ClassLoader getNonBootstrapClassLoader();

    public static final native void initializeClassLoader(ClassLoader var0, boolean var1);

    private static final native boolean isBootstrapClassLoader(ClassLoader var0);

    static native Class findClassOrNull(String var0, ClassLoader var1);

    public static ClassLoader callerClassLoader() {
        ClassLoader loader = VM.getStackClassLoader(2);
        ClassLoader caller = VM.getStackClassLoader(1);
        if (!VM.isBootstrapClassLoader(caller)) {
            throw new SecurityException();
        }
        if (VM.isBootstrapClassLoader(loader)) {
            return null;
        }
        return loader;
    }

    private static ClassLoader caller2ClassLoader() {
        ClassLoader loader = VM.getStackClassLoader(3);
        if (VM.isBootstrapClassLoader(loader)) {
            return null;
        }
        return loader;
    }

    public static native void dumpString(String var0);

    public static void setClassPathImpl(ClassLoader classLoader, String classPath) {
        VM.setClassPathImpl(classLoader, Util.getBytes(classPath));
    }

    private static native void setClassPathImpl(ClassLoader var0, byte[] var1);

    public static void enableClassHotSwap(Class hotSwapClass) {
    }

    static native void setPDImpl(Class var0, Object var1);

    static native int getCPIndexImpl(Class var0);

    static void initializeVM() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addShutdownHook(Thread hook) {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(shutdownHooksPermission);
        }
        Vector vector = shutdownHooks;
        synchronized (vector) {
            if (shutdown) {
                throw new IllegalStateException(Msg.getString("K01a4"));
            }
            if (hook == null || shutdownHooks.contains(hook)) {
                throw new IllegalArgumentException(Msg.getString("K01a5", hook));
            }
            shutdownHooks.addElement(hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeShutdownHook(Thread hook) {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(shutdownHooksPermission);
        }
        Vector vector = shutdownHooks;
        synchronized (vector) {
            if (shutdown) {
                throw new IllegalStateException(Msg.getString("K01a4"));
            }
            return shutdownHooks.removeElement(hook);
        }
    }

    public static void closeJars() {
        closeJars = true;
    }

    public static void deleteOnExit() {
        deleteOnExit = true;
    }

    public static void addShutdownClass(Runnable cl) {
        shutdownClasses.addElement(cl);
    }

    private static void shutdown() {
        int i = shutdownClasses.size() - 1;
        while (i >= 0) {
            ((Runnable)shutdownClasses.elementAt(i)).run();
            --i;
        }
        if (closeJars) {
            JarURLConnection.closeCachedFiles();
        }
        if (deleteOnExit) {
            DeleteOnExit.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanup() {
        Vector vector = shutdownHooks;
        synchronized (vector) {
            if (shutdown) {
                return;
            }
            shutdown = true;
        }
        int i = 0;
        while (i < shutdownHooks.size()) {
            ((Thread)shutdownHooks.elementAt(i)).start();
            ++i;
        }
        i = 0;
        while (i < shutdownHooks.size()) {
            Thread hook = (Thread)shutdownHooks.elementAt(i);
            while (true) {
                try {
                    hook.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            ++i;
        }
    }

    static final native int getClassPathEntryType(Object var0, int var1);

    static final native long getJxePointerFromClassPath(Object var0, int var1);

    static Jxe getJxeFromClassPath(Object classLoader, int cpIndex) {
        long pointer = VM.getJxePointerFromClassPath(classLoader, cpIndex);
        if (pointer == 0L) {
            return null;
        }
        Jxe jxe = new Jxe(pointer, false);
        return jxe;
    }

    public static native String[] getVMArgs();

    static native int getClassPathCount();

    static native byte[] getPathFromClassPath(int var0);

    public static synchronized void loadLibrary(String libName) throws IOException {
        try {
            Runtime.getRuntime().loadLibrary(libName);
        }
        catch (UnsatisfiedLinkError e) {
            throw new IOException(e.getMessage());
        }
    }

    public static native void localGC();

    public static native void globalGC();

    public static native void runFinalization();

    public static void disableFinalization(Class aClass) {
        if (VM.callerClassLoader() != null) {
            throw new SecurityException();
        }
        VM.disableFinalizationImpl(aClass);
    }

    private static final native void disableFinalizationImpl(Class var0);

    public static final boolean useNatives() {
        return VM.useNativesImpl();
    }

    private static final native boolean useNativesImpl();

    public static int availableProcessors() {
        return VM.processorsImpl();
    }

    private static native int processorsImpl();

    public static native boolean enableJIT();

    public static void enableFinalization(Class aClass) {
    }

    public static String[] getHttpProxyParms() {
        return VM.getHttpProxyImpl();
    }

    private static native String[] getHttpProxyImpl();
}

