/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.io.Reader;

public class BufferedReader
extends Reader {
    private Reader in;
    private char[] buf;
    private int marklimit = -1;
    private int count;
    private int markpos = -1;
    private int pos;

    public BufferedReader(Reader in) {
        super(in);
        this.in = in;
        this.buf = new char[8192];
    }

    public BufferedReader(Reader in, int size) {
        super(in);
        if (size <= 0) {
            throw new IllegalArgumentException(Msg.getString("K0058"));
        }
        this.in = in;
        this.buf = new char[size];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                this.in.close();
                this.buf = null;
            }
        }
    }

    private int fillbuf() throws IOException {
        if (this.markpos == -1 || this.pos - this.markpos >= this.marklimit) {
            int result = this.in.read(this.buf, 0, this.buf.length);
            if (result > 0) {
                this.markpos = -1;
                this.pos = 0;
                this.count = result == -1 ? 0 : result;
            }
            return result;
        }
        if (this.markpos == 0 && this.marklimit > this.buf.length) {
            int newLength = this.buf.length * 2;
            if (newLength > this.marklimit) {
                newLength = this.marklimit;
            }
            char[] newbuf = new char[newLength];
            System.arraycopy((Object)this.buf, 0, (Object)newbuf, 0, this.buf.length);
            this.buf = newbuf;
        } else if (this.markpos > 0) {
            System.arraycopy((Object)this.buf, this.markpos, (Object)this.buf, 0, this.buf.length - this.markpos);
        }
        this.pos -= this.markpos;
        this.markpos = 0;
        this.count = 0;
        int charsread = this.in.read(this.buf, this.pos, this.buf.length - this.pos);
        this.count = charsread == -1 ? this.pos : this.pos + charsread;
        return charsread;
    }

    private boolean isOpen() {
        return this.buf != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int readlimit) throws IOException {
        if (readlimit >= 0) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.isOpen()) {
                    throw new IOException(Msg.getString("K005b"));
                }
                this.marklimit = readlimit;
                this.markpos = this.pos;
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            block5: {
                if (!this.isOpen()) break block5;
                if (this.pos < this.count || this.fillbuf() != -1) {
                    return this.buf[this.pos++];
                }
                return -1;
            }
            throw new IOException(Msg.getString("K005b"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(char[] buffer, int offset, int length) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int required;
            int bufLen;
            block16: {
                if (!this.isOpen()) throw new IOException(Msg.getString("K005b"));
                bufLen = buffer.length;
                if (length != 0) break block16;
                return 0;
            }
            if (offset < 0) throw new ArrayIndexOutOfBoundsException();
            if (offset > bufLen) throw new ArrayIndexOutOfBoundsException();
            if (length <= 0) throw new ArrayIndexOutOfBoundsException();
            if (length > bufLen - offset) throw new ArrayIndexOutOfBoundsException();
            if (this.pos < this.count) {
                int copylength = this.count - this.pos >= length ? length : this.count - this.pos;
                System.arraycopy((Object)this.buf, this.pos, (Object)buffer, offset, copylength);
                this.pos += copylength;
                if (copylength == length) return copylength;
                if (!this.in.ready()) {
                    return copylength;
                }
                offset += copylength;
                required = length - copylength;
            } else {
                required = length;
            }
            while (true) {
                int read;
                if (this.markpos == -1 && required >= this.buf.length) {
                    read = this.in.read(buffer, offset, required);
                    if (read == -1) {
                        if (required == length) {
                            return -1;
                        }
                        int n = length - required;
                        return n;
                    }
                } else {
                    if (this.fillbuf() == -1) {
                        if (required == length) {
                            return -1;
                        }
                        int n = length - required;
                        return n;
                    }
                    read = this.count - this.pos >= required ? required : this.count - this.pos;
                    System.arraycopy((Object)this.buf, this.pos, (Object)buffer, offset, read);
                    this.pos += read;
                }
                if ((required -= read) == 0) {
                    return length;
                }
                if (!this.in.ready()) {
                    return length - required;
                }
                offset += read;
            }
        }
    }

    public String readLine() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                int eol = 0;
                StringBuffer result = new StringBuffer(80);
                while (true) {
                    if (this.pos >= this.count) {
                        if (eol == 10) {
                            return result.toString();
                        }
                        if (this.fillbuf() == -1) {
                            return result.length() > 0 || eol != 0 ? result.toString() : null;
                        }
                    }
                    int charPos = this.pos;
                    while (charPos < this.count) {
                        if (eol == 0 && (this.buf[charPos] == '\n' || this.buf[charPos] == '\r')) {
                            eol = this.buf[charPos];
                        } else {
                            if (eol == 13 && this.buf[charPos] == '\n') {
                                if (charPos > this.pos) {
                                    result.append(this.buf, this.pos, charPos - this.pos - 1);
                                }
                                this.pos = charPos + 1;
                                return result.toString();
                            }
                            if (eol != 0) {
                                if (charPos > this.pos) {
                                    result.append(this.buf, this.pos, charPos - this.pos - 1);
                                }
                                this.pos = charPos;
                                return result.toString();
                            }
                        }
                        ++charPos;
                    }
                    if (eol != 0) {
                        result.append(this.buf, this.pos, this.count - this.pos - 1);
                    } else {
                        result.append(this.buf, this.pos, this.count - this.pos);
                    }
                    this.pos = this.count;
                }
            }
            throw new IOException(Msg.getString("K005b"));
        }
    }

    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                return this.count - this.pos > 0 || this.in.ready();
            }
            throw new IOException(Msg.getString("K005b"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                if (this.markpos == -1) {
                    throw new IOException(Msg.getString("K005c"));
                }
            } else {
                throw new IOException(Msg.getString("K005b"));
            }
            this.pos = this.markpos;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long skip(long amount) throws IOException {
        if (amount < 0L) throw new IllegalArgumentException();
        Object object = this.lock;
        synchronized (object) {
            block8: {
                if (!this.isOpen()) throw new IOException(Msg.getString("K005b"));
                if (amount >= 1L) break block8;
                return 0L;
            }
            if ((long)(this.count - this.pos) >= amount) {
                this.pos = (int)((long)this.pos + amount);
                return amount;
            }
            long read = this.count - this.pos;
            this.pos = this.count;
            while (read < amount) {
                if (this.fillbuf() == -1) {
                    return read;
                }
                if ((long)(this.count - this.pos) >= amount - read) {
                    this.pos = (int)((long)this.pos + (amount - read));
                    return amount;
                }
                read += (long)(this.count - this.pos);
                this.pos = this.count;
            }
            return amount;
        }
    }
}

