/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.PriviAction;
import java.io.IOException;
import java.io.Writer;
import java.security.AccessController;

public class BufferedWriter
extends Writer {
    private Writer out;
    private char[] buf;
    private int pos;
    private final String lineSeparator = (String)AccessController.doPrivileged(new PriviAction("line.separator"));

    public BufferedWriter(Writer out) {
        super(out);
        this.out = out;
        this.buf = new char[8192];
    }

    public BufferedWriter(Writer out, int size) {
        super(out);
        if (size <= 0) {
            throw new IllegalArgumentException(Msg.getString("K0058"));
        }
        this.out = out;
        this.buf = new char[size];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                this.flush();
                this.out.close();
                this.buf = null;
                this.out = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                if (this.pos > 0) {
                    this.out.write(this.buf, 0, this.pos);
                }
            } else {
                throw new IOException(Msg.getString("K005d"));
            }
            this.pos = 0;
            this.out.flush();
        }
    }

    private boolean isOpen() {
        return this.out != null;
    }

    public void newLine() throws IOException {
        this.write(this.lineSeparator, 0, this.lineSeparator.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] buf, int offset, int count) throws IOException {
        if (offset >= 0 && offset <= buf.length && count >= 0 && count <= buf.length - offset) {
            Object object = this.lock;
            synchronized (object) {
                if (this.isOpen()) {
                    if (this.pos == 0 && count >= this.buf.length) {
                        this.out.write(buf, offset, count);
                        return;
                    }
                    int available = this.buf.length - this.pos;
                    if (count < available) {
                        available = count;
                    }
                    if (available > 0) {
                        System.arraycopy((Object)buf, offset, (Object)this.buf, this.pos, available);
                        this.pos += available;
                    }
                    if (this.pos == this.buf.length) {
                        this.out.write(this.buf, 0, this.buf.length);
                        this.pos = 0;
                        if (count > available) {
                            offset += available;
                            if ((available = count - available) >= this.buf.length) {
                                this.out.write(buf, offset, available);
                                return;
                            }
                            System.arraycopy((Object)buf, offset, (Object)this.buf, this.pos, available);
                            this.pos += available;
                        }
                    }
                } else {
                    throw new IOException(Msg.getString("K005d"));
                }
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int oneChar) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                if (this.pos >= this.buf.length) {
                    this.out.write(this.buf, 0, this.buf.length);
                    this.pos = 0;
                }
            } else {
                throw new IOException(Msg.getString("K005d"));
            }
            this.buf[this.pos++] = (char)oneChar;
        }
    }

    public void write(String str) throws IOException {
        this.write(str, 0, str.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String str, int offset, int count) throws IOException {
        if (offset >= 0 && offset <= str.length() && count >= 0 && count <= str.length() - offset) {
            Object object = this.lock;
            synchronized (object) {
                while (count > 0) {
                    if (this.isOpen()) {
                        int available = this.buf.length - this.pos;
                        if (count <= available) {
                            str.getChars(offset, offset + count, this.buf, this.pos);
                            this.pos += count;
                            break;
                        }
                        str.getChars(offset, offset + available, this.buf, this.pos);
                        count -= available;
                        offset += available;
                        this.out.write(this.buf, 0, this.buf.length);
                        this.pos = 0;
                        continue;
                    }
                    throw new IOException(Msg.getString("K005d"));
                }
            }
        } else {
            throw new StringIndexOutOfBoundsException();
        }
    }
}

