/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.ibm.oti.util.Msg;
import java.io.File;
import java.io.FilePermissionCollection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;

public final class FilePermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = 7930732926638008763L;
    private transient String canonPath;
    private static final String[] actionList = new String[]{"read", "write", "execute", "delete"};
    private String actions;
    transient int mask = -1;
    private transient boolean includeAll = false;
    private transient boolean allDir = false;
    private transient boolean allSubdir = false;

    public FilePermission(String path, String actions) {
        super(path);
        this.init(path, actions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init(final String path, String actions) {
        if (actions == null || actions == "") throw new IllegalArgumentException(Msg.getString("K006d"));
        if (path == null) throw new NullPointerException(Msg.getString("K006e"));
        if (path.equals("<<ALL FILES>>")) {
            this.includeAll = true;
        } else {
            this.canonPath = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return new File(path).getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        return path;
                    }
                }
            });
            if (path.equals("*") || path.endsWith(String.valueOf(File.separator) + "*")) {
                this.allDir = true;
            }
            if (path.equals("-") || path.endsWith(String.valueOf(File.separator) + "-")) {
                this.allSubdir = true;
            }
        }
        this.actions = this.toCanonicalActionString(actions);
    }

    private String toCanonicalActionString(String action) {
        this.actions = action.trim().toLowerCase();
        this.mask = this.getMask(this.actions);
        int len = actionList.length;
        int highestBitMask = 1 << len - 1;
        StringBuffer result = new StringBuffer();
        boolean addedItem = false;
        int i = 0;
        while (i < len) {
            if ((highestBitMask & this.mask) != 0) {
                if (addedItem) {
                    result.append(",");
                }
                result.append(actionList[i]);
                addedItem = true;
            }
            highestBitMask >>= 1;
            ++i;
        }
        return result.toString();
    }

    private int getMask(String actions) {
        int actionInt = 0;
        int head = 0;
        int tail = 0;
        do {
            String action;
            String string = action = (tail = actions.indexOf(",", head)) > 0 ? actions.substring(head, tail).trim() : actions.substring(head).trim();
            if (action.equals("read")) {
                actionInt |= 8;
            } else if (action.equals("write")) {
                actionInt |= 4;
            } else if (action.equals("execute")) {
                actionInt |= 2;
            } else if (action.equals("delete")) {
                actionInt |= 1;
            } else {
                throw new IllegalArgumentException(Msg.getString("K006f", action));
            }
            head = tail + 1;
        } while (tail > 0);
        return actionInt;
    }

    public String getActions() {
        return this.actions;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FilePermission) {
            FilePermission fp = (FilePermission)obj;
            if (!(fp.actions == this.actions || fp.actions != null && fp.actions.equals(this.actions))) {
                return false;
            }
            if (fp.includeAll || this.includeAll) {
                return fp.includeAll == this.includeAll;
            }
            return fp.canonPath.equals(this.canonPath);
        }
        return false;
    }

    public boolean implies(Permission p) {
        int match = this.impliesMask(p);
        return match != 0 && match == ((FilePermission)p).mask;
    }

    int impliesMask(Permission p) {
        if (!(p instanceof FilePermission)) {
            return 0;
        }
        FilePermission fp = (FilePermission)p;
        int matchedMask = this.mask & fp.mask;
        if (matchedMask == 0) {
            return 0;
        }
        if (this.includeAll) {
            return matchedMask;
        }
        if (fp.includeAll) {
            return 0;
        }
        int thisLength = this.canonPath.length();
        if (this.allSubdir && thisLength == 2 && !fp.canonPath.equals(File.separator)) {
            return matchedMask;
        }
        if (fp.allSubdir && !this.allSubdir) {
            return 0;
        }
        if (fp.allDir && !this.allSubdir && !this.allDir) {
            return 0;
        }
        boolean includeDir = false;
        int pLength = fp.canonPath.length();
        if (this.allDir || this.allSubdir) {
            --thisLength;
        }
        if (fp.allDir || fp.allSubdir) {
            --pLength;
        }
        int i = 0;
        while (i < pLength) {
            char pChar = fp.canonPath.charAt(i);
            if (i >= thisLength) {
                if (i == thisLength) {
                    if (this.allSubdir) {
                        return matchedMask;
                    }
                    if (this.allDir) {
                        includeDir = true;
                    }
                }
                if (!includeDir) {
                    return 0;
                }
                if (pChar == File.separatorChar) {
                    return 0;
                }
            } else if (this.canonPath.charAt(i) != pChar) {
                return 0;
            }
            ++i;
        }
        if (pLength == thisLength) {
            if (this.allSubdir) {
                return fp.allSubdir || fp.allDir ? matchedMask : 0;
            }
            return this.allDir == fp.allDir ? matchedMask : 0;
        }
        return includeDir ? matchedMask : 0;
    }

    public PermissionCollection newPermissionCollection() {
        return new FilePermissionCollection();
    }

    public int hashCode() {
        return (this.canonPath == null ? this.getName().hashCode() : this.canonPath.hashCode()) + this.mask;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.init(this.getName(), this.actions);
    }
}

