/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.ibm.oti.io.CharBuffer;
import com.ibm.oti.io.CharacterConverter;
import com.ibm.oti.io.NativeCharacterConverter;
import com.ibm.oti.util.Msg;
import com.ibm.oti.util.PriviAction;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;

public class InputStreamReader
extends Reader {
    private InputStream in;
    CharacterConverter converter;
    private byte[] bytes = new byte[8192];
    private int pos;
    private int count;

    public InputStreamReader(InputStream in) {
        super(in);
        this.in = in;
        String encoding = (String)AccessController.doPrivileged(new PriviAction("file.encoding", "ISO8859_1"));
        this.converter = CharacterConverter.getDefaultConverter(encoding);
    }

    public InputStreamReader(InputStream in, String enc) throws UnsupportedEncodingException {
        super(in);
        this.in = in;
        this.converter = CharacterConverter.getConverter(enc);
        if (this.converter == null) {
            throw new UnsupportedEncodingException(enc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.bytes != null) {
                this.in.close();
                this.converter = null;
                this.in = null;
                this.bytes = null;
            }
        }
    }

    private int fillbuf() throws IOException {
        int result;
        if (this.count > 0 && this.pos > 0) {
            this.count -= this.pos;
            if (this.count > 0) {
                System.arraycopy((Object)this.bytes, this.pos, (Object)this.bytes, 0, this.count);
            }
            this.pos = 0;
        }
        if ((result = this.in.read(this.bytes, this.count, this.bytes.length - this.count)) >= 0) {
            this.count += result;
        } else if (this.count > 0) {
            throw new CharConversionException(Msg.getString("K01a0"));
        }
        return result;
    }

    private int convert(char[] buffer, int offset, int length) throws IOException {
        int result;
        CharBuffer charBuf = new CharBuffer(buffer, offset, length);
        this.pos = result = this.converter.convert(this.bytes, this.pos, this.count - this.pos, charBuf);
        if (result != -1) {
            return charBuf.getPos() - offset;
        }
        throw new CharConversionException();
    }

    public String getEncoding() {
        if (this.converter == null) {
            return null;
        }
        if (this.converter instanceof NativeCharacterConverter) {
            return ((NativeCharacterConverter)this.converter).getJavaEncoding();
        }
        String name = this.converter.getClass().getName();
        int index = name.indexOf(95);
        if (index < 0) {
            return "ISO8859_1";
        }
        return name.substring(index + 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.bytes == null) {
                throw new IOException(Msg.getString("K0070"));
            }
            char[] buf = new char[1];
            int converted = 0;
            if (this.pos < this.count) {
                converted = this.convert(buf, 0, 1);
            }
            while (true) {
                if (converted != 0) {
                    return buf[0];
                }
                int read = this.fillbuf();
                if (read == -1) {
                    return -1;
                }
                converted = this.convert(buf, 0, 1);
            }
        }
    }

    public int read(char[] buf, int offset, int length) throws IOException {
        if (offset >= 0 && offset <= buf.length && length >= 0 && length <= buf.length - offset) {
            int copylength = 0;
            int newoffset = offset;
            Object object = this.lock;
            synchronized (object) {
                if (this.bytes != null) {
                    int converted = 0;
                    if (this.pos < this.count) {
                        converted = this.convert(buf, offset, length);
                        copylength += converted;
                    }
                    int available = 1;
                    while (copylength < length) {
                        newoffset += converted;
                        if (copylength > 0 && available <= 0 && (available = this.in.available()) <= 0) break;
                        int read = this.fillbuf();
                        if (read == -1) {
                            return copylength == 0 ? -1 : copylength;
                        }
                        available -= read;
                        converted = this.convert(buf, newoffset, length - copylength);
                        copylength += converted;
                    }
                    return copylength;
                }
                throw new IOException(Msg.getString("K0070"));
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.bytes != null) {
                return this.pos < this.count || this.in.available() > 0;
            }
            throw new IOException(Msg.getString("K0070"));
        }
    }
}

