/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.PriviAction;
import com.ibm.oti.util.Sorter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Vector;
import java.util.WeakHashMap;

public class ObjectStreamClass
implements Serializable {
    static final long serialVersionUID = -6120832682080437368L;
    private static final String UID_FIELD_NAME = "serialVersionUID";
    private static final int CLASS_MODIFIERS_MASK;
    private static final Class[] READ_PARAM_TYPES;
    private static final Class[] WRITE_PARAM_TYPES;
    static final Class[] EMPTY_CONSTRUCTOR_PARAM_TYPES;
    private static final Class VOID_CLASS;
    static final Class[] UNSHARED_PARAM_TYPES;
    public static final ObjectStreamField[] NO_FIELDS;
    static final Class ARRAY_OF_FIELDS;
    private static final String CLINIT_NAME = "<clinit>";
    private static final int CLINIT_MODIFIERS = 8;
    private static final String CLINIT_SIGNATURE = "()V";
    private static final Class SERIALIZABLE;
    private static final Class EXTERNALIZABLE;
    static final Class STRINGCLASS;
    static final Class CLASSCLASS;
    static final Class OBJECTSTREAMCLASSCLASS;
    private static final WeakHashMap classesAndDescriptors;
    private String className;
    private WeakReference resolvedClass;
    private long svUID;
    private byte flags;
    private ObjectStreamClass superclass;
    private ObjectStreamField[] fields;
    private ObjectStreamField[] loadFields;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    static {
        ObjectStreamClass.oneTimeInitialization();
        CLASS_MODIFIERS_MASK = 1553;
        READ_PARAM_TYPES = new Class[1];
        WRITE_PARAM_TYPES = new Class[1];
        Class clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.io.ObjectInputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ObjectStreamClass.READ_PARAM_TYPES[0] = clazz;
        Class clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.io.ObjectOutputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ObjectStreamClass.WRITE_PARAM_TYPES[0] = clazz2;
        EMPTY_CONSTRUCTOR_PARAM_TYPES = new Class[0];
        VOID_CLASS = Void.TYPE;
        UNSHARED_PARAM_TYPES = new Class[1];
        Class clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ObjectStreamClass.UNSHARED_PARAM_TYPES[0] = clazz3;
        NO_FIELDS = new ObjectStreamField[0];
        try {
            ARRAY_OF_FIELDS = Class.forName("[Ljava.io.ObjectStreamField;");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException();
        }
        Class clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.io.Serializable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SERIALIZABLE = clazz4;
        Class clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("java.io.Externalizable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        EXTERNALIZABLE = clazz5;
        Class clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        STRINGCLASS = clazz6;
        Class clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("java.lang.Class");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CLASSCLASS = clazz7;
        Class clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("java.io.ObjectStreamClass");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        OBJECTSTREAMCLASSCLASS = clazz8;
        classesAndDescriptors = new WeakHashMap();
    }

    private static native void oneTimeInitialization();

    ObjectStreamClass() {
    }

    private static ObjectStreamClass addToCache(Class cl, boolean computeSUID) {
        boolean serializable;
        ObjectStreamClass result = new ObjectStreamClass();
        classesAndDescriptors.put(cl, result);
        result.setName(cl.getName());
        result.setClass(cl);
        Class superclass = cl.getSuperclass();
        if (superclass != null) {
            result.setSuperclass(ObjectStreamClass.lookup(superclass));
        }
        Field[] declaredFields = null;
        if (computeSUID) {
            declaredFields = cl.getDeclaredFields();
            result.setSerialVersionUID(ObjectStreamClass.computeSerialVersionUID(cl, declaredFields));
        }
        if ((serializable = ObjectStreamClass.isSerializable(cl)) && !cl.isArray()) {
            if (declaredFields == null) {
                declaredFields = cl.getDeclaredFields();
            }
            result.buildFieldDescriptors(declaredFields);
        } else {
            result.setFields(new ObjectStreamField[0]);
        }
        byte flags = 0;
        boolean externalizable = ObjectStreamClass.isExternalizable(cl);
        if (externalizable) {
            flags = (byte)(flags | 4);
        } else if (serializable) {
            flags = (byte)(flags | 2);
        }
        if (ObjectStreamClass.getPrivateWriteObjectMethod(cl) != null) {
            flags = (byte)(flags | 1);
        }
        result.setFlags(flags);
        return result;
    }

    void buildFieldDescriptors(Field[] declaredFields) {
        boolean useReflectFields;
        Field f = ObjectStreamClass.fieldSerialPersistentFields(this.forClass());
        boolean bl = useReflectFields = f == null;
        if (!useReflectFields) {
            AccessController.doPrivileged(new PriviAction(f));
            try {
                this.fields = (ObjectStreamField[])f.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException();
            }
        } else {
            Vector serializableFields = new Vector(declaredFields.length);
            int i = 0;
            while (i < declaredFields.length) {
                boolean shouldBeSerialized;
                Field declaredField = declaredFields[i];
                int modifiers = declaredField.getModifiers();
                boolean bl2 = shouldBeSerialized = !Modifier.isStatic(modifiers) && !Modifier.isTransient(modifiers);
                if (shouldBeSerialized) {
                    ObjectStreamField field = new ObjectStreamField(declaredField.getName(), declaredField.getType());
                    serializableFields.addElement(field);
                }
                ++i;
            }
            if (serializableFields.size() == 0) {
                this.fields = NO_FIELDS;
            } else {
                this.fields = new ObjectStreamField[serializableFields.size()];
                serializableFields.copyInto(this.fields);
            }
        }
        ObjectStreamField.sortFields(this.fields);
        int primOffset = 0;
        int objectOffset = 0;
        int i = 0;
        while (i < this.fields.length) {
            Class type = this.fields[i].getType();
            if (type.isPrimitive()) {
                this.fields[i].offset = primOffset;
                primOffset += this.primitiveSize(type);
            } else {
                this.fields[i].offset = objectOffset++;
            }
            ++i;
        }
    }

    private static long computeSerialVersionUID(Class cl, Field[] fields) {
        MessageDigest digest;
        int i = 0;
        while (i < fields.length) {
            int modifiers;
            Field field = fields[i];
            if (Long.TYPE == field.getType() && Modifier.isStatic(modifiers = field.getModifiers()) && Modifier.isFinal(modifiers) && UID_FIELD_NAME.equals(field.getName())) {
                AccessController.doPrivileged(new PriviAction(field));
                try {
                    return field.getLong(null);
                }
                catch (IllegalAccessException iae) {
                    throw new RuntimeException(Msg.getString("K0071", iae.toString()));
                }
            }
            ++i;
        }
        try {
            digest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e.toString());
        }
        ByteArrayOutputStream sha = new ByteArrayOutputStream();
        try {
            Object[] constructors;
            DataOutputStream output = new DataOutputStream(sha);
            output.writeUTF(cl.getName());
            int classModifiers = CLASS_MODIFIERS_MASK & cl.getModifiers();
            boolean isArray = cl.isArray();
            if (isArray) {
                classModifiers |= 0x400;
            }
            if (cl.isInterface() && !Modifier.isPublic(classModifiers)) {
                classModifiers &= 0xFFFFFBFF;
            }
            output.writeInt(classModifiers);
            if (!isArray) {
                Object[] interfaces = cl.getInterfaces();
                if (interfaces.length > 1) {
                    Sorter.Comparator interfaceComparator = new Sorter.Comparator(){

                        public int compare(Object interface1, Object interface2) {
                            return ((Class)interface1).getName().compareTo(((Class)interface2).getName());
                        }
                    };
                    Sorter.sort(interfaces, interfaceComparator);
                }
                int i2 = 0;
                while (i2 < interfaces.length) {
                    output.writeUTF(((Class)interfaces[i2]).getName());
                    ++i2;
                }
            }
            if (fields.length > 1) {
                Sorter.Comparator fieldComparator = new Sorter.Comparator(){

                    public int compare(Object field1, Object field2) {
                        return ((Field)field1).getName().compareTo(((Field)field2).getName());
                    }
                };
                Sorter.sort(fields, fieldComparator);
            }
            int i3 = 0;
            while (i3 < fields.length) {
                boolean skip;
                Field field = fields[i3];
                int modifiers = field.getModifiers();
                boolean bl = skip = Modifier.isPrivate(modifiers) && (Modifier.isTransient(modifiers) || Modifier.isStatic(modifiers));
                if (!skip) {
                    output.writeUTF(field.getName());
                    output.writeInt(modifiers);
                    output.writeUTF(ObjectStreamClass.descriptorForFieldSignature(ObjectStreamClass.getFieldSignature(field)));
                }
                ++i3;
            }
            if (ObjectStreamClass.hasClinit(cl)) {
                output.writeUTF(CLINIT_NAME);
                output.writeInt(8);
                output.writeUTF(CLINIT_SIGNATURE);
            }
            if ((constructors = cl.getDeclaredConstructors()).length > 1) {
                Sorter.Comparator constructorComparator = new Sorter.Comparator(){

                    public int compare(Object constructor1, Object constructor2) {
                        return ObjectStreamClass.getConstructorSignature((Constructor)constructor1).compareTo(ObjectStreamClass.getConstructorSignature((Constructor)constructor2));
                    }
                };
                Sorter.sort(constructors, constructorComparator);
            }
            int i4 = 0;
            while (i4 < constructors.length) {
                Object constructor = constructors[i4];
                int modifiers = ((Constructor)constructor).getModifiers();
                boolean isPrivate = Modifier.isPrivate(modifiers);
                if (!isPrivate) {
                    output.writeUTF("<init>");
                    output.writeInt(modifiers);
                    output.writeUTF(ObjectStreamClass.descriptorForSignature(ObjectStreamClass.getConstructorSignature((Constructor)constructor)));
                }
                ++i4;
            }
            Object[] methods = cl.getDeclaredMethods();
            if (methods.length > 1) {
                Sorter.Comparator methodComparator = new Sorter.Comparator(){

                    public int compare(Object method1, Object method2) {
                        int result = ((Method)method1).getName().compareTo(((Method)method2).getName());
                        if (result == 0) {
                            return ObjectStreamClass.getMethodSignature((Method)method1).compareTo(ObjectStreamClass.getMethodSignature((Method)method2));
                        }
                        return result;
                    }
                };
                Sorter.sort(methods, methodComparator);
            }
            int i5 = 0;
            while (i5 < methods.length) {
                Object method = methods[i5];
                int modifiers = ((Method)method).getModifiers();
                boolean isPrivate = Modifier.isPrivate(modifiers);
                if (!isPrivate) {
                    output.writeUTF(((Method)method).getName());
                    output.writeInt(modifiers);
                    output.writeUTF(ObjectStreamClass.descriptorForSignature(ObjectStreamClass.getMethodSignature((Method)method)));
                }
                ++i5;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(Msg.getString("K0072", e.toString()));
        }
        byte[] hash = digest.digest(sha.toByteArray());
        return ObjectStreamClass.littleEndianLongAt(hash, 0);
    }

    private static String descriptorForFieldSignature(String signature) {
        return signature.replace('.', '/');
    }

    private static String descriptorForSignature(String signature) {
        return signature.substring(signature.indexOf("("));
    }

    static Field fieldSerialPersistentFields(Class cl) {
        try {
            Field f = cl.getDeclaredField("serialPersistentFields");
            int modifiers = f.getModifiers();
            if (Modifier.isStatic(modifiers) && Modifier.isPrivate(modifiers) && Modifier.isFinal(modifiers) && f.getType() == ARRAY_OF_FIELDS) {
                return f;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {}
        return null;
    }

    public Class forClass() {
        if (this.resolvedClass != null) {
            return (Class)this.resolvedClass.get();
        }
        return null;
    }

    static native String getConstructorSignature(Constructor var0);

    public ObjectStreamField getField(String name) {
        ObjectStreamField[] allFields = this.fields();
        int i = 0;
        while (i < allFields.length) {
            ObjectStreamField f = allFields[i];
            if (f.getName().equals(name)) {
                return f;
            }
            ++i;
        }
        return null;
    }

    ObjectStreamField[] fields() {
        if (this.fields == null) {
            Class forCl = this.forClass();
            if (forCl != null && ObjectStreamClass.isSerializable(forCl) && !forCl.isArray()) {
                this.buildFieldDescriptors(forCl.getDeclaredFields());
            } else {
                this.setFields(new ObjectStreamField[0]);
            }
        }
        return this.fields;
    }

    public ObjectStreamField[] getFields() {
        return (ObjectStreamField[])this.fields().clone();
    }

    ObjectStreamField[] getLoadFields() {
        return this.loadFields;
    }

    private static native String getFieldSignature(Field var0);

    byte getFlags() {
        return this.flags;
    }

    static native String getMethodSignature(Method var0);

    public String getName() {
        return this.className;
    }

    public long getSerialVersionUID() {
        return this.svUID;
    }

    ObjectStreamClass getSuperclass() {
        return this.superclass;
    }

    private static native boolean hasClinit(Class var0);

    static Method getPrivateReadObjectMethod(Class cl) {
        try {
            Method method = cl.getDeclaredMethod("readObject", READ_PARAM_TYPES);
            if (Modifier.isPrivate(method.getModifiers()) && method.getReturnType() == VOID_CLASS) {
                return method;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return null;
    }

    static Method getPrivateReadObjectNoDataMethod(Class cl) {
        try {
            Method method = cl.getDeclaredMethod("readObjectNoData", EMPTY_CONSTRUCTOR_PARAM_TYPES);
            if (Modifier.isPrivate(method.getModifiers()) && method.getReturnType() == VOID_CLASS) {
                return method;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return null;
    }

    static Method getPrivateWriteObjectMethod(Class cl) {
        try {
            Method method = cl.getDeclaredMethod("writeObject", WRITE_PARAM_TYPES);
            if (Modifier.isPrivate(method.getModifiers()) && method.getReturnType() == VOID_CLASS) {
                return method;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return null;
    }

    static boolean isExternalizable(Class cl) {
        return EXTERNALIZABLE.isAssignableFrom(cl);
    }

    static boolean isPrimitiveType(char typecode) {
        return typecode != '[' && typecode != 'L';
    }

    static boolean isSerializable(Class cl) {
        return SERIALIZABLE.isAssignableFrom(cl);
    }

    private static long littleEndianLongAt(byte[] buffer, int position) {
        long result = 0L;
        int i = position + 7;
        while (i >= position) {
            result = (result << 8) + (long)(buffer[i] & 0xFF);
            --i;
        }
        return result;
    }

    public static ObjectStreamClass lookup(Class cl) {
        boolean serializable = ObjectStreamClass.isSerializable(cl);
        boolean externalizable = ObjectStreamClass.isExternalizable(cl);
        if (!serializable && !externalizable) {
            return null;
        }
        return ObjectStreamClass.lookupStreamClass(cl, true);
    }

    static ObjectStreamClass lookupStreamClass(Class cl) {
        return ObjectStreamClass.lookupStreamClass(cl, ObjectStreamClass.isSerializable(cl) || ObjectStreamClass.isExternalizable(cl));
    }

    private static synchronized ObjectStreamClass lookupStreamClass(Class cl, boolean computeSUID) {
        ObjectStreamClass cachedValue = (ObjectStreamClass)classesAndDescriptors.get(cl);
        if (cachedValue != null) {
            return cachedValue;
        }
        return ObjectStreamClass.addToCache(cl, computeSUID);
    }

    static Method methodReadResolve(Class cl) {
        Class search = cl;
        while (search != null) {
            try {
                Method method = search.getDeclaredMethod("readResolve", null);
                if (search == cl || (method.getModifiers() & 2) == 0) {
                    return method;
                }
                return null;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                search = search.getSuperclass();
            }
        }
        return null;
    }

    static Method methodWriteReplace(Class cl) {
        Class search = cl;
        while (search != null) {
            try {
                Method method = search.getDeclaredMethod("writeReplace", null);
                if (search == cl || (method.getModifiers() & 2) == 0) {
                    return method;
                }
                return null;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                search = search.getSuperclass();
            }
        }
        return null;
    }

    void setClass(Class c) {
        this.resolvedClass = new WeakReference(c);
    }

    void setFields(ObjectStreamField[] f) {
        this.fields = f;
    }

    void setLoadFields(ObjectStreamField[] f) {
        this.loadFields = f;
    }

    void setFlags(byte b) {
        this.flags = b;
    }

    void setName(String newName) {
        this.className = newName;
    }

    void setSerialVersionUID(long l) {
        this.svUID = l;
    }

    void setSuperclass(ObjectStreamClass c) {
        this.superclass = c;
    }

    private int primitiveSize(Class type) {
        if (type == Byte.TYPE || type == Boolean.TYPE) {
            return 1;
        }
        if (type == Short.TYPE || type == Character.TYPE) {
            return 2;
        }
        if (type == Integer.TYPE || type == Float.TYPE) {
            return 4;
        }
        if (type == Long.TYPE || type == Double.TYPE) {
            return 8;
        }
        return 0;
    }

    public String toString() {
        return String.valueOf(this.getName()) + ": static final long serialVersionUID =" + this.getSerialVersionUID() + "L;";
    }
}

