/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;

public final class Field
extends AccessibleObject
implements Member {
    private Class declaringClass;
    private Class type;
    private String name;
    private long vm1;

    private Field() {
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Field)) {
            return false;
        }
        Field field = (Field)object;
        if (!this.getName().equals(field.getName())) {
            return false;
        }
        if (this.getDeclaringClass() != field.getDeclaringClass()) {
            return false;
        }
        return this.getType() == field.getType();
    }

    public Object get(Object object) throws IllegalAccessException, IllegalArgumentException {
        if (this.requiresProtectedCheck()) {
            this.doProtectedCheck(Field.getStackClass(-1), object);
        }
        return this.getImpl(object);
    }

    private boolean requiresProtectedCheck() {
        return !this.isAccessible() && (this.getModifiers() & 0xC) == 4;
    }

    private native Object getImpl(Object var1) throws IllegalAccessException, IllegalArgumentException;

    private boolean samePackage(Class accessorClass) {
        if (this.declaringClass.equals(accessorClass)) {
            return true;
        }
        String fieldDeclaringClassPkg = Field.getPackageName(this.declaringClass.getName());
        String callerClassPkg = Field.getPackageName(accessorClass.getName());
        return fieldDeclaringClassPkg.equals(callerClassPkg);
    }

    private void doProtectedCheck(Class accessorClass, Object object) throws IllegalAccessException {
        if (!this.samePackage(accessorClass) && !accessorClass.isInstance(object)) {
            if (!this.declaringClass.isInstance(object)) {
                throw new IllegalArgumentException();
            }
            throw new IllegalAccessException();
        }
    }

    private static String getPackageName(String name) {
        int index = name.lastIndexOf(46);
        if (index >= 0) {
            return name.substring(0, index);
        }
        return "";
    }

    public boolean getBoolean(Object object) throws IllegalAccessException, IllegalArgumentException {
        if (this.requiresProtectedCheck()) {
            this.doProtectedCheck(Field.getStackClass(-1), object);
        }
        return this.getBooleanImpl(object);
    }

    private native boolean getBooleanImpl(Object var1) throws IllegalAccessException, IllegalArgumentException;

    public byte getByte(Object object) throws IllegalAccessException, IllegalArgumentException {
        if (this.requiresProtectedCheck()) {
            this.doProtectedCheck(Field.getStackClass(-1), object);
        }
        return this.getByteImpl(object);
    }

    private native byte getByteImpl(Object var1) throws IllegalAccessException, IllegalArgumentException;

    public char getChar(Object object) throws IllegalAccessException, IllegalArgumentException {
        if (this.requiresProtectedCheck()) {
            this.doProtectedCheck(Field.getStackClass(-1), object);
        }
        return this.getCharImpl(object);
    }

    private native char getCharImpl(Object var1) throws IllegalAccessException, IllegalArgumentException;

    public Class getDeclaringClass() {
        return this.declaringClass;
    }

    public double getDouble(Object object) throws IllegalAccessException, IllegalArgumentException {
        if (this.requiresProtectedCheck()) {
            this.doProtectedCheck(Field.getStackClass(-1), object);
        }
        return this.getDoubleImpl(object);
    }

    private native double getDoubleImpl(Object var1) throws IllegalAccessException, IllegalArgumentException;

    public float getFloat(Object object) throws IllegalAccessException, IllegalArgumentException {
        if (this.requiresProtectedCheck()) {
            this.doProtectedCheck(Field.getStackClass(-1), object);
        }
        return this.getFloatImpl(object);
    }

    private native float getFloatImpl(Object var1) throws IllegalAccessException, IllegalArgumentException;

    public int getInt(Object object) throws IllegalAccessException, IllegalArgumentException {
        if (this.requiresProtectedCheck()) {
            this.doProtectedCheck(Field.getStackClass(-1), object);
        }
        return this.getIntImpl(object);
    }

    private native int getIntImpl(Object var1) throws IllegalAccessException, IllegalArgumentException;

    public long getLong(Object object) throws IllegalAccessException, IllegalArgumentException {
        if (this.requiresProtectedCheck()) {
            this.doProtectedCheck(Field.getStackClass(-1), object);
        }
        return this.getLongImpl(object);
    }

    private native long getLongImpl(Object var1) throws IllegalAccessException, IllegalArgumentException;

    public native int getModifiers();

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.getNameImpl();
    }

    private native String getNameImpl();

    public short getShort(Object object) throws IllegalAccessException, IllegalArgumentException {
        if (this.requiresProtectedCheck()) {
            this.doProtectedCheck(Field.getStackClass(-1), object);
        }
        return this.getShortImpl(object);
    }

    private native short getShortImpl(Object var1) throws IllegalAccessException, IllegalArgumentException;

    native String getSignature();

    public Class getType() {
        if (this.type != null) {
            return this.type;
        }
        return this.getTypeImpl();
    }

    private native Class getTypeImpl();

    public int hashCode() {
        return this.getName().hashCode();
    }

    public void set(Object object, Object value) throws IllegalAccessException, IllegalArgumentException {
        if (this.requiresProtectedCheck()) {
            this.doProtectedCheck(Field.getStackClass(-1), object);
        }
        this.setImpl(object, value);
    }

    private native void setImpl(Object var1, Object var2) throws IllegalAccessException, IllegalArgumentException;

    public void setBoolean(Object object, boolean value) throws IllegalAccessException, IllegalArgumentException {
        if (this.requiresProtectedCheck()) {
            this.doProtectedCheck(Field.getStackClass(-1), object);
        }
        this.setBooleanImpl(object, value);
    }

    private native void setBooleanImpl(Object var1, boolean var2) throws IllegalAccessException, IllegalArgumentException;

    public void setByte(Object object, byte value) throws IllegalAccessException, IllegalArgumentException {
        if (this.requiresProtectedCheck()) {
            this.doProtectedCheck(Field.getStackClass(-1), object);
        }
        this.setByteImpl(object, value);
    }

    private native void setByteImpl(Object var1, byte var2) throws IllegalAccessException, IllegalArgumentException;

    public void setChar(Object object, char value) throws IllegalAccessException, IllegalArgumentException {
        if (this.requiresProtectedCheck()) {
            this.doProtectedCheck(Field.getStackClass(-1), object);
        }
        this.setCharImpl(object, value);
    }

    private native void setCharImpl(Object var1, char var2) throws IllegalAccessException, IllegalArgumentException;

    public void setDouble(Object object, double value) throws IllegalAccessException, IllegalArgumentException {
        if (this.requiresProtectedCheck()) {
            this.doProtectedCheck(Field.getStackClass(-1), object);
        }
        this.setDoubleImpl(object, value);
    }

    private native void setDoubleImpl(Object var1, double var2) throws IllegalAccessException, IllegalArgumentException;

    public void setFloat(Object object, float value) throws IllegalAccessException, IllegalArgumentException {
        if (this.requiresProtectedCheck()) {
            this.doProtectedCheck(Field.getStackClass(-1), object);
        }
        this.setFloatImpl(object, value);
    }

    private native void setFloatImpl(Object var1, float var2) throws IllegalAccessException, IllegalArgumentException;

    public void setInt(Object object, int value) throws IllegalAccessException, IllegalArgumentException {
        if (this.requiresProtectedCheck()) {
            this.doProtectedCheck(Field.getStackClass(-1), object);
        }
        this.setIntImpl(object, value);
    }

    private native void setIntImpl(Object var1, int var2) throws IllegalAccessException, IllegalArgumentException;

    public void setLong(Object object, long value) throws IllegalAccessException, IllegalArgumentException {
        if (this.requiresProtectedCheck()) {
            this.doProtectedCheck(Field.getStackClass(-1), object);
        }
        this.setLongImpl(object, value);
    }

    private native void setLongImpl(Object var1, long var2) throws IllegalAccessException, IllegalArgumentException;

    public void setShort(Object object, short value) throws IllegalAccessException, IllegalArgumentException {
        if (this.requiresProtectedCheck()) {
            this.doProtectedCheck(Field.getStackClass(-1), object);
        }
        this.setShortImpl(object, value);
    }

    private native void setShortImpl(Object var1, short var2) throws IllegalAccessException, IllegalArgumentException;

    public String toString() {
        int arity = 0;
        StringBuffer buf = new StringBuffer();
        String modifier = Modifier.toString(this.getModifiers());
        if (modifier.length() > 0) {
            buf.append(modifier);
            buf.append(" ");
        }
        Class current = this.getType();
        while (current.isArray()) {
            current = current.getComponentType();
            ++arity;
        }
        buf.append(current.getName());
        while (arity > 0) {
            buf.append("[]");
            --arity;
        }
        buf.append(" ");
        buf.append(this.getDeclaringClass().getName());
        buf.append(".");
        buf.append(this.getName());
        return buf.toString();
    }
}

