/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;

public final class Method
extends AccessibleObject
implements Member {
    private Class declaringClass;
    private Class[] parameterTypes;
    private Class[] exceptionTypes;
    private Class returnType;
    private String name;
    private long vm1;

    private Method() {
    }

    public boolean equals(Object object) {
        Class[] array2;
        if (this == object) {
            return true;
        }
        if (!(object instanceof Method)) {
            return false;
        }
        Method method = (Method)object;
        if (!this.getName().equals(method.getName())) {
            return false;
        }
        if (this.getDeclaringClass() != method.getDeclaringClass()) {
            return false;
        }
        Class[] array1 = this.getParameterTypes();
        if (array1.length != (array2 = method.getParameterTypes()).length) {
            return false;
        }
        int i = 0;
        while (i < array1.length) {
            if (array1[i] != array2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Class getDeclaringClass() {
        return this.declaringClass;
    }

    public Class[] getExceptionTypes() {
        if (this.exceptionTypes == null) {
            this.getExceptionTypesImpl();
        }
        return (Class[])this.exceptionTypes.clone();
    }

    public int getModifiers() {
        return super.getModifiers();
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.getNameImpl();
    }

    private native String getNameImpl();

    public Class[] getParameterTypes() {
        if (this.parameterTypes == null) {
            this.getParameterTypesImpl();
        }
        return (Class[])this.parameterTypes.clone();
    }

    public Class getReturnType() {
        if (this.returnType != null) {
            return this.returnType;
        }
        return this.getReturnTypeImpl();
    }

    private native Class getReturnTypeImpl();

    public int hashCode() {
        return this.getName().hashCode() ^ this.getDeclaringClass().getName().hashCode();
    }

    public Object invoke(Object receiver, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class callerClass;
        Class declaringClass = this.getDeclaringClass();
        if ((this.getModifiers() & 8) == 0) {
            if (receiver == null) {
                throw new NullPointerException();
            }
            if (!declaringClass.isInstance(receiver)) {
                throw new IllegalArgumentException("invalid receiver");
            }
        } else {
            receiver = null;
        }
        if (args == null) {
            args = emptyArgs;
        }
        if (!this.isAccessible() && !this.checkAccessibility(callerClass = Method.getStackClass(-1), receiver)) {
            throw new IllegalAccessException();
        }
        if (this.parameterTypes == null) {
            this.getParameterTypesImpl();
        }
        args = Method.marshallArguments(this.parameterTypes, args);
        if (receiver == null) {
            try {
                Method.initializeClass(declaringClass);
            }
            catch (Throwable e) {
                throw new InvocationTargetException(e);
            }
        }
        if (this.returnType == null) {
            this.getReturnTypeImpl();
        }
        if (this.returnType == Void.TYPE) {
            this.invokeV(receiver, args);
            return null;
        }
        if (this.returnType == Boolean.TYPE) {
            return new Boolean(this.invokeI(receiver, args) != 0);
        }
        if (this.returnType == Character.TYPE) {
            return new Character((char)this.invokeI(receiver, args));
        }
        if (this.returnType == Byte.TYPE) {
            return new Byte((byte)this.invokeI(receiver, args));
        }
        if (this.returnType == Short.TYPE) {
            return new Short((short)this.invokeI(receiver, args));
        }
        if (this.returnType == Integer.TYPE) {
            return new Integer(this.invokeI(receiver, args));
        }
        if (this.returnType == Long.TYPE) {
            return new Long(this.invokeJ(receiver, args));
        }
        if (this.returnType == Float.TYPE) {
            return new Float(this.invokeF(receiver, args));
        }
        if (this.returnType == Double.TYPE) {
            return new Double(this.invokeD(receiver, args));
        }
        return this.invokeL(receiver, args);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String mods = Modifier.toString(this.getModifiers());
        if (mods.length() != 0) {
            buf.append(mods);
            buf.append(" ");
        }
        Class current = this.getReturnType();
        int arity = 0;
        while (current.isArray()) {
            current = current.getComponentType();
            ++arity;
        }
        buf.append(current.getName());
        while (arity > 0) {
            buf.append("[]");
            --arity;
        }
        buf.append(" ");
        buf.append(this.getDeclaringClass().getName());
        buf.append(".");
        buf.append(this.getName());
        buf.append("(");
        Class[] types = this.getParameterTypes();
        int i = 0;
        while (i < types.length) {
            current = types[i];
            arity = 0;
            while (current.isArray()) {
                current = current.getComponentType();
                ++arity;
            }
            buf.append(current.getName());
            while (arity > 0) {
                buf.append("[]");
                --arity;
            }
            if (i != types.length - 1) {
                buf.append(",");
            }
            ++i;
        }
        buf.append(")");
        types = this.getExceptionTypes();
        if (types.length > 0) {
            buf.append(" throws ");
            i = 0;
            while (i < types.length) {
                current = types[i];
                buf.append(current.getName());
                if (i != types.length - 1) {
                    buf.append(",");
                }
                ++i;
            }
        }
        return buf.toString();
    }
}

