/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.net.NetPermission;
import java.net.PasswordAuthentication;

public abstract class Authenticator {
    private static Authenticator thisAuthenticator;
    private static final NetPermission requestPasswordAuthenticationPermission;
    private static final NetPermission setDefaultAuthenticatorPermission;
    private String host;
    private InetAddress addr;
    private int port;
    private String protocol;
    private String prompt;
    private String scheme;

    static {
        requestPasswordAuthenticationPermission = new NetPermission("requestPasswordAuthentication");
        setDefaultAuthenticatorPermission = new NetPermission("setDefaultAuthenticator");
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        return null;
    }

    protected final int getRequestingPort() {
        return this.port;
    }

    protected final InetAddress getRequestingSite() {
        return this.addr;
    }

    protected final String getRequestingPrompt() {
        return this.prompt;
    }

    protected final String getRequestingProtocol() {
        return this.protocol;
    }

    protected final String getRequestingScheme() {
        return this.scheme;
    }

    public static synchronized PasswordAuthentication requestPasswordAuthentication(InetAddress rAddr, int rPort, String rProtocol, String rPrompt, String rScheme) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(requestPasswordAuthenticationPermission);
        }
        if (thisAuthenticator == null) {
            return null;
        }
        Authenticator.thisAuthenticator.addr = rAddr;
        Authenticator.thisAuthenticator.port = rPort;
        Authenticator.thisAuthenticator.protocol = rProtocol;
        Authenticator.thisAuthenticator.prompt = rPrompt;
        Authenticator.thisAuthenticator.scheme = rScheme;
        return thisAuthenticator.getPasswordAuthentication();
    }

    public static void setDefault(Authenticator a) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setDefaultAuthenticatorPermission);
        }
        thisAuthenticator = a;
    }

    public static synchronized PasswordAuthentication requestPasswordAuthentication(String rHost, InetAddress rAddr, int rPort, String rProtocol, String rPrompt, String rScheme) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(requestPasswordAuthenticationPermission);
        }
        if (thisAuthenticator == null) {
            return null;
        }
        Authenticator.thisAuthenticator.host = rHost;
        Authenticator.thisAuthenticator.addr = rAddr;
        Authenticator.thisAuthenticator.port = rPort;
        Authenticator.thisAuthenticator.protocol = rProtocol;
        Authenticator.thisAuthenticator.prompt = rPrompt;
        Authenticator.thisAuthenticator.scheme = rScheme;
        return thisAuthenticator.getPasswordAuthentication();
    }

    protected final String getRequestingHost() {
        return this.host;
    }
}

