/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.PriviAction;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.DatagramSocketImplFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.security.AccessController;

public class DatagramSocket {
    DatagramSocketImpl impl;
    InetAddress address;
    int port = -1;
    static DatagramSocketImplFactory factory;
    boolean isBound = false;
    private boolean isConnected = false;
    private boolean isClosed = false;
    Object lock = new Object();

    public DatagramSocket() throws SocketException {
        this(0);
    }

    public DatagramSocket(int aPort) throws SocketException {
        this.checkListen(aPort);
        this.createSocket(aPort, InetAddress.ANY);
    }

    public DatagramSocket(int aPort, InetAddress addr) throws SocketException {
        this.checkListen(aPort);
        this.createSocket(aPort, addr == null ? InetAddress.ANY : addr);
    }

    void checkListen(int aPort) {
        if (aPort < 0 || aPort > 65535) {
            throw new IllegalArgumentException(Msg.getString("K0325", aPort));
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkListen(aPort);
        }
    }

    public void close() {
        this.isClosed = true;
        this.impl.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(InetAddress anAddress, int aPort) {
        if (anAddress == null || aPort < 0 || aPort > 65535) {
            throw new IllegalArgumentException(Msg.getString("K0032"));
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            try {
                this.checkClosedAndBind(true);
            }
            catch (SocketException socketException) {}
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                if (anAddress.isMulticastAddress()) {
                    security.checkMulticast(anAddress);
                } else {
                    security.checkConnect(anAddress.getHostAddress(), aPort);
                }
            }
            try {
                this.impl.connect(anAddress, aPort);
            }
            catch (SocketException socketException) {}
            this.address = anAddress;
            this.port = aPort;
            this.isConnected = true;
        }
    }

    public void disconnect() {
        if (this.isClosed() || !this.isConnected()) {
            return;
        }
        this.impl.disconnect();
        this.address = null;
        this.port = -1;
        this.isConnected = false;
    }

    synchronized void createSocket(int aPort, InetAddress addr) throws SocketException {
        this.impl = factory != null ? factory.createDatagramSocketImpl() : this.createSocketImpl();
        this.impl.create();
        try {
            this.impl.bind(aPort, addr);
            this.isBound = true;
        }
        catch (SocketException e) {
            this.close();
            throw e;
        }
    }

    DatagramSocketImpl createSocketImpl() throws SocketException {
        Object impl = null;
        String prefix = (String)AccessController.doPrivileged(new PriviAction("impl.prefix", "Plain"));
        try {
            Class aClass = Class.forName("java.net." + prefix + "DatagramSocketImpl");
            impl = aClass.newInstance();
        }
        catch (Exception exception) {
            throw new SocketException(Msg.getString("K0033"));
        }
        return (DatagramSocketImpl)impl;
    }

    public InetAddress getInetAddress() {
        return this.address;
    }

    public InetAddress getLocalAddress() {
        if (this.isClosed()) {
            return null;
        }
        if (!this.isBound()) {
            return InetAddress.ANY;
        }
        InetAddress anAddr = this.impl.getLocalAddress();
        try {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkConnect(anAddr.getHostAddress(), -1);
            }
        }
        catch (SecurityException securityException) {
            return InetAddress.ANY;
        }
        return anAddr;
    }

    public int getLocalPort() {
        if (this.isClosed()) {
            return -1;
        }
        if (!this.isBound()) {
            return 0;
        }
        return this.impl.getLocalPort();
    }

    public int getPort() {
        return this.port;
    }

    boolean isMulticastSocket() {
        return false;
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        this.checkClosedAndBind(false);
        return (Integer)this.impl.getOption(4098);
    }

    public synchronized int getSendBufferSize() throws SocketException {
        this.checkClosedAndBind(false);
        return (Integer)this.impl.getOption(4097);
    }

    public synchronized int getSoTimeout() throws SocketException {
        this.checkClosedAndBind(false);
        return (Integer)this.impl.getOption(4102);
    }

    public synchronized void receive(DatagramPacket pack) throws IOException {
        this.checkClosedAndBind(true);
        boolean secure = true;
        InetAddress senderAddr = null;
        int senderPort = 0;
        DatagramPacket tempPack = new DatagramPacket(new byte[1], 1);
        boolean copy = false;
        SecurityManager security = System.getSecurityManager();
        if (this.address != null || security != null) {
            if (pack == null) {
                throw new NullPointerException();
            }
            secure = false;
            while (!secure) {
                copy = false;
                try {
                    senderPort = this.impl.peekData(tempPack);
                    senderAddr = tempPack.getAddress();
                }
                catch (SocketException e) {
                    if (e.getMessage().equals("The socket does not support the operation")) {
                        tempPack = new DatagramPacket(new byte[pack.length], pack.getLength());
                        this.impl.receive(tempPack);
                        senderAddr = tempPack.getAddress();
                        senderPort = tempPack.getPort();
                        copy = true;
                    }
                    throw e;
                }
                if (this.address == null) {
                    try {
                        security.checkAccept(senderAddr.getHostAddress(), senderPort);
                        if (copy) break;
                        secure = true;
                        break;
                    }
                    catch (SecurityException securityException) {
                        if (copy) continue;
                        if (tempPack == null) {
                            tempPack = new DatagramPacket(new byte[pack.length], pack.length);
                        }
                        this.impl.receive(tempPack);
                        continue;
                    }
                }
                if (this.port == senderPort && this.address.equals(senderAddr)) {
                    if (copy) break;
                    secure = true;
                    break;
                }
                if (copy) continue;
                if (tempPack == null) {
                    tempPack = new DatagramPacket(new byte[pack.length], pack.length);
                }
                this.impl.receive(tempPack);
            }
        }
        if (copy) {
            System.arraycopy((Object)tempPack.getData(), 0, (Object)pack.getData(), pack.getOffset(), tempPack.getLength());
            pack.setLength(tempPack.getLength());
            pack.setAddress(tempPack.getAddress());
            pack.setPort(tempPack.getPort());
        }
        if (secure) {
            this.impl.receive(pack);
        }
    }

    public void send(DatagramPacket pack) throws IOException {
        this.checkClosedAndBind(true);
        InetAddress packAddr = pack.getAddress();
        if (this.address != null) {
            if (packAddr != null) {
                if (!this.address.equals(packAddr) || this.port != pack.getPort()) {
                    throw new IllegalArgumentException(Msg.getString("K0034"));
                }
            } else {
                pack.setAddress(this.address);
                pack.setPort(this.port);
            }
        } else {
            if (packAddr == null) {
                throw new NullPointerException(Msg.getString("K0331"));
            }
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                if (packAddr.isMulticastAddress()) {
                    security.checkMulticast(packAddr);
                } else {
                    security.checkConnect(packAddr.getHostAddress(), pack.getPort());
                }
            }
        }
        this.impl.send(pack);
    }

    public synchronized void setSendBufferSize(int size) throws SocketException {
        if (size < 1) {
            throw new IllegalArgumentException(Msg.getString("K0035"));
        }
        this.checkClosedAndBind(false);
        this.impl.setOption(4097, new Integer(size));
    }

    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        if (size < 1) {
            throw new IllegalArgumentException(Msg.getString("K0035"));
        }
        this.checkClosedAndBind(false);
        this.impl.setOption(4098, new Integer(size));
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        if (timeout < 0) {
            throw new IllegalArgumentException(Msg.getString("K0036"));
        }
        this.checkClosedAndBind(false);
        this.impl.setOption(4102, new Integer(timeout));
    }

    public static synchronized void setDatagramSocketImplFactory(DatagramSocketImplFactory fac) throws IOException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSetFactory();
        }
        if (factory != null) {
            throw new SocketException(Msg.getString("K0044"));
        }
        factory = fac;
    }

    protected DatagramSocket(DatagramSocketImpl socketImpl) {
        this.impl = socketImpl;
    }

    public DatagramSocket(SocketAddress localAddr) throws SocketException {
        if (localAddr != null) {
            if (!(localAddr instanceof InetSocketAddress)) {
                throw new IllegalArgumentException(Msg.getString("K0316", localAddr.getClass()));
            }
            this.checkListen(((InetSocketAddress)localAddr).getPort());
        }
        this.impl = factory != null ? factory.createDatagramSocketImpl() : this.createSocketImpl();
        this.impl.create();
        if (localAddr != null) {
            try {
                this.bind(localAddr);
            }
            catch (SocketException e) {
                this.close();
                throw e;
            }
        }
    }

    void checkClosedAndBind(boolean bind) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException(Msg.getString("K003d"));
        }
        if (bind && !this.isBound()) {
            this.checkListen(0);
            this.impl.bind(0, InetAddress.ANY);
            this.isBound = true;
        }
    }

    public void bind(SocketAddress localAddr) throws SocketException {
        this.checkClosedAndBind(false);
        int port = 0;
        InetAddress addr = InetAddress.ANY;
        if (localAddr != null) {
            if (!(localAddr instanceof InetSocketAddress)) {
                throw new IllegalArgumentException(Msg.getString("K0316", localAddr.getClass()));
            }
            InetSocketAddress inetAddr = (InetSocketAddress)localAddr;
            addr = inetAddr.getAddress();
            if (addr == null) {
                throw new SocketException(Msg.getString("K0317", inetAddr.getHostName()));
            }
            port = inetAddr.getPort();
            this.checkListen(port);
        }
        this.impl.bind(port, addr);
        this.isBound = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(SocketAddress remoteAddr) throws SocketException {
        if (remoteAddr == null) {
            throw new IllegalArgumentException(Msg.getString("K0318"));
        }
        if (!(remoteAddr instanceof InetSocketAddress)) {
            throw new IllegalArgumentException(Msg.getString("K0316", remoteAddr.getClass()));
        }
        InetSocketAddress inetAddr = (InetSocketAddress)remoteAddr;
        if (inetAddr.getAddress() == null) {
            throw new SocketException(Msg.getString("K0317", inetAddr.getHostName()));
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkClosedAndBind(true);
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                if (inetAddr.getAddress().isMulticastAddress()) {
                    security.checkMulticast(inetAddr.getAddress());
                } else {
                    security.checkConnect(inetAddr.getAddress().getHostAddress(), inetAddr.getPort());
                }
            }
            try {
                this.impl.connect(inetAddr.getAddress(), inetAddr.getPort());
            }
            catch (Exception exception) {}
            this.address = inetAddr.getAddress();
            this.port = inetAddr.getPort();
            this.isConnected = true;
        }
    }

    public boolean isBound() {
        return this.isBound;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public SocketAddress getRemoteSocketAddress() {
        if (!this.isConnected()) {
            return null;
        }
        return new InetSocketAddress(this.getInetAddress(), this.getPort());
    }

    public SocketAddress getLocalSocketAddress() {
        if (!this.isBound()) {
            return null;
        }
        return new InetSocketAddress(this.getLocalAddress(), this.getLocalPort());
    }

    public void setReuseAddress(boolean reuse) throws SocketException {
        this.checkClosedAndBind(false);
        this.impl.setOption(4, reuse ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getReuseAddress() throws SocketException {
        this.checkClosedAndBind(false);
        return (Boolean)this.impl.getOption(4);
    }

    public void setBroadcast(boolean broadcast) throws SocketException {
        this.checkClosedAndBind(false);
        this.impl.setOption(32, broadcast ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getBroadcast() throws SocketException {
        this.checkClosedAndBind(false);
        return (Boolean)this.impl.getOption(32);
    }

    public void setTrafficClass(int value) throws SocketException {
        this.checkClosedAndBind(false);
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException();
        }
        this.impl.setOption(3, new Integer(value));
    }

    public int getTrafficClass() throws SocketException {
        this.checkClosedAndBind(false);
        return ((Number)this.impl.getOption(3)).intValue();
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

