/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.PriviAction;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.DatagramSocketImpl;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.security.AccessController;
import java.util.Enumeration;

public class MulticastSocket
extends DatagramSocket {
    static final int SO_REUSEPORT = 512;
    private InetAddress interfaceSet = null;

    public MulticastSocket() throws IOException {
    }

    public MulticastSocket(int aPort) throws IOException {
        super(aPort);
    }

    public InetAddress getInterface() throws SocketException {
        this.checkClosedAndBind(false);
        if (this.interfaceSet == null) {
            Enumeration addresses;
            NetworkInterface theInterface;
            InetAddress ipvXaddress = (InetAddress)this.impl.getOption(16);
            if (ipvXaddress.isAnyLocalAddress() && (theInterface = this.getNetworkInterface()) != null && (addresses = theInterface.getInetAddresses()) != null) {
                while (addresses.hasMoreElements()) {
                    InetAddress nextAddress = (InetAddress)addresses.nextElement();
                    if (!(nextAddress instanceof Inet6Address)) continue;
                    return nextAddress;
                }
            }
            return ipvXaddress;
        }
        return this.interfaceSet;
    }

    public NetworkInterface getNetworkInterface() throws SocketException {
        InetAddress theAddress;
        this.checkClosedAndBind(false);
        Integer theIndex = new Integer(0);
        try {
            theIndex = (Integer)this.impl.getOption(31);
        }
        catch (SocketException socketException) {}
        if (theIndex != 0) {
            Enumeration theInterfaces = NetworkInterface.getNetworkInterfaces();
            while (theInterfaces.hasMoreElements()) {
                NetworkInterface nextInterface = (NetworkInterface)theInterfaces.nextElement();
                if (nextInterface.getIndex() != theIndex.intValue()) continue;
                return nextInterface;
            }
        }
        if ((theAddress = (InetAddress)this.impl.getOption(16)) != null) {
            if (!theAddress.isAnyLocalAddress()) {
                return NetworkInterface.getByInetAddress(theAddress);
            }
            InetAddress[] theAddresses = new InetAddress[]{!Socket.preferIPv4Stack() && InetAddress.preferIPv6Addresses() ? Inet6Address.ANY : Inet4Address.ANY};
            return new NetworkInterface(null, null, theAddresses, -1);
        }
        return null;
    }

    public int getTimeToLive() throws IOException {
        this.checkClosedAndBind(false);
        return this.impl.getTimeToLive();
    }

    boolean isMulticastSocket() {
        return true;
    }

    public void joinGroup(InetAddress groupAddr) throws IOException {
        this.checkClosedAndBind(false);
        if (!groupAddr.isMulticastAddress()) {
            throw new IOException(Msg.getString("K0039"));
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkMulticast(groupAddr);
        }
        this.impl.join(groupAddr);
    }

    public void joinGroup(SocketAddress groupAddress, NetworkInterface netInterface) throws IOException {
        this.checkClosedAndBind(false);
        if (groupAddress == null) {
            throw new IllegalArgumentException(Msg.getString("K0331"));
        }
        if (netInterface != null && netInterface.getFirstAddress() == null) {
            throw new SocketException(Msg.getString("K0335"));
        }
        if (groupAddress instanceof InetSocketAddress) {
            InetAddress groupAddr = ((InetSocketAddress)groupAddress).getAddress();
            if (groupAddr == null) {
                throw new SocketException(Msg.getString("K0317", groupAddr.getHostName()));
            }
            if (!groupAddr.isMulticastAddress()) {
                throw new IOException(Msg.getString("K0039"));
            }
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkMulticast(groupAddr);
            }
        } else {
            throw new IllegalArgumentException(Msg.getString("K0316", groupAddress.getClass()));
        }
        this.impl.joinGroup(groupAddress, netInterface);
    }

    public void leaveGroup(InetAddress groupAddr) throws IOException {
        this.checkClosedAndBind(false);
        if (!groupAddr.isMulticastAddress()) {
            throw new IOException(Msg.getString("K003a"));
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkMulticast(groupAddr);
        }
        this.impl.leave(groupAddr);
    }

    public void leaveGroup(SocketAddress groupAddress, NetworkInterface netInterface) throws IOException {
        this.checkClosedAndBind(false);
        if (groupAddress == null) {
            throw new IllegalArgumentException(Msg.getString("K0331"));
        }
        if (netInterface != null && netInterface.getFirstAddress() == null) {
            throw new SocketException(Msg.getString("K0335"));
        }
        if (groupAddress instanceof InetSocketAddress) {
            InetAddress groupAddr = ((InetSocketAddress)groupAddress).getAddress();
            if (groupAddr == null) {
                throw new SocketException(Msg.getString("K0317", groupAddr.getHostName()));
            }
            if (!groupAddr.isMulticastAddress()) {
                throw new IOException(Msg.getString("K003a"));
            }
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkMulticast(groupAddr);
            }
        } else {
            throw new IllegalArgumentException(Msg.getString("K0316", groupAddress.getClass()));
        }
        this.impl.leaveGroup(groupAddress, netInterface);
    }

    public void send(DatagramPacket pack, byte ttl) throws IOException {
        this.checkClosedAndBind(false);
        InetAddress packAddr = pack.getAddress();
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            if (packAddr.isMulticastAddress()) {
                security.checkMulticast(packAddr, ttl);
            } else {
                security.checkConnect(packAddr.getHostAddress(), pack.getPort());
            }
        }
        int currTTL = this.getTimeToLive();
        if (packAddr.isMulticastAddress() && (byte)currTTL != ttl) {
            try {
                this.setTimeToLive(ttl & 0xFF);
                this.impl.send(pack);
            }
            finally {
                this.setTimeToLive(currTTL);
            }
        } else {
            this.impl.send(pack);
        }
    }

    public void setInterface(InetAddress addr) throws SocketException {
        this.checkClosedAndBind(false);
        if (addr == null) {
            throw new NullPointerException();
        }
        if (addr.isAnyLocalAddress()) {
            this.impl.setOption(16, Inet4Address.ANY);
        } else if (addr instanceof Inet4Address) {
            this.impl.setOption(16, addr);
            this.interfaceSet = addr;
        }
        NetworkInterface theInterface = NetworkInterface.getByInetAddress(addr);
        if (theInterface != null && theInterface.getIndex() != 0) {
            try {
                this.impl.setOption(31, new Integer(theInterface.getIndex()));
            }
            catch (SocketException socketException) {}
        } else if (addr.isAnyLocalAddress()) {
            try {
                this.impl.setOption(31, new Integer(0));
            }
            catch (SocketException socketException) {}
        } else if (addr instanceof Inet6Address) {
            throw new SocketException(Msg.getString("K0338"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setNetworkInterface(NetworkInterface netInterface) throws SocketException {
        this.checkClosedAndBind(false);
        if (netInterface == null) throw new SocketException(Msg.getString("K0334"));
        InetAddress firstAddress = netInterface.getFirstAddress();
        if (firstAddress == null) throw new SocketException(Msg.getString("K0335"));
        if (netInterface.getIndex() == -1) {
            this.impl.setOption(16, InetAddress.ANY);
            try {
                this.impl.setOption(31, new Integer(0));
            }
            catch (SocketException socketException) {}
        }
        Enumeration theAddresses = netInterface.getInetAddresses();
        boolean found = false;
        firstAddress = null;
        while (theAddresses.hasMoreElements() && !found) {
            InetAddress theAddress = (InetAddress)theAddresses.nextElement();
            if (!(theAddress instanceof Inet4Address)) continue;
            firstAddress = theAddress;
            found = true;
        }
        if (netInterface.getIndex() == 0) {
            if (firstAddress == null) throw new SocketException(Msg.getString("K0335"));
            this.impl.setOption(16, firstAddress);
        } else {
            if (firstAddress != null) {
                this.impl.setOption(16, firstAddress);
            }
            try {
                this.impl.setOption(31, new Integer(netInterface.getIndex()));
            }
            catch (SocketException socketException) {}
        }
        this.interfaceSet = null;
    }

    public void setTimeToLive(int ttl) throws IOException {
        this.checkClosedAndBind(false);
        if (ttl < 0 || ttl > 255) {
            throw new IllegalArgumentException(Msg.getString("K003c"));
        }
        this.impl.setTimeToLive(ttl);
    }

    synchronized void createSocket(int aPort, InetAddress addr) throws SocketException {
        this.impl = factory != null ? factory.createDatagramSocketImpl() : this.createSocketImpl();
        this.impl.create();
        try {
            this.impl.bind(aPort, addr);
            this.isBound = true;
        }
        catch (SocketException e) {
            this.close();
            throw e;
        }
    }

    public MulticastSocket(SocketAddress localAddr) throws IOException {
        super(localAddr);
    }

    public boolean getLoopbackMode() throws SocketException {
        this.checkClosedAndBind(false);
        return (Boolean)this.impl.getOption(18) == false;
    }

    public void setLoopbackMode(boolean loop) throws SocketException {
        this.checkClosedAndBind(false);
        this.impl.setOption(18, loop ? Boolean.FALSE : Boolean.TRUE);
    }

    DatagramSocketImpl createSocketImpl() throws SocketException {
        Object impl = null;
        String prefix = (String)AccessController.doPrivileged(new PriviAction("impl.prefix", "Plain"));
        try {
            Class aClass = Class.forName("java.net." + prefix + "MulticastSocketImpl");
            impl = aClass.newInstance();
        }
        catch (Exception exception) {
            throw new SocketException(Msg.getString("K0033"));
        }
        return (DatagramSocketImpl)impl;
    }
}

