/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketImpl;

class SocketInputStream
extends InputStream {
    SocketImpl socket;

    public SocketInputStream(SocketImpl socket) {
        this.socket = socket;
    }

    public int available() throws IOException {
        return this.socket.available();
    }

    public void close() throws IOException {
        this.socket.close();
        super.close();
    }

    public int read() throws IOException {
        byte[] buffer = new byte[1];
        int result = this.socket.read(buffer, 0, 1);
        return -1 == result ? result : buffer[0] & 0xFF;
    }

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int offset, int count) throws IOException {
        if (buffer == null) {
            throw new IOException(Msg.getString("K0047"));
        }
        if (count == 0) {
            return 0;
        }
        if (offset < 0 || offset >= buffer.length) {
            throw new ArrayIndexOutOfBoundsException(Msg.getString("K002e"));
        }
        if (count < 0 || offset + count > buffer.length) {
            throw new ArrayIndexOutOfBoundsException(Msg.getString("K002f"));
        }
        return this.socket.read(buffer, offset, count);
    }

    public long skip(long n) throws IOException {
        return 0L == n ? 0L : super.skip(n);
    }
}

