/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.ibm.oti.util.Msg;
import java.io.UnsupportedEncodingException;

class Socks4Message {
    protected byte[] buffer = new byte[256];
    private static final int SOCKS_VERSION = 4;
    public static final int COMMAND_CONNECT = 1;
    public static final int COMMAND_BIND = 2;
    public static final int RETURN_SUCCESS = 90;
    public static final int RETURN_FAILURE = 91;
    public static final int RETURN_CANNOT_CONNECT_TO_IDENTD = 92;
    public static final int RETURN_DIFFERENT_USER_IDS = 93;
    protected static final int INDEX_VERSION = 0;
    private static final int INDEX_COMMAND = 1;
    private static final int INDEX_PORT = 2;
    private static final int INDEX_IP = 4;
    private static final int INDEX_USER_ID = 8;
    private static final int BUFFER_LENGTH = 256;
    public static final int REPLY_LENGTH = 8;
    private static final int MAX_USER_ID_LENGTH = 248;

    public Socks4Message() {
        this.setVersionNumber(4);
    }

    public int getCommandOrResult() {
        return this.buffer[1];
    }

    public void setCommandOrResult(int command) {
        this.buffer[1] = (byte)command;
    }

    public int getPort() {
        return this.getInt16(2);
    }

    public void setPort(int port) {
        this.setInt16(2, port);
    }

    public int getIP() {
        return this.getInt32(4);
    }

    public void setIP(byte[] ip) {
        this.buffer[4] = ip[0];
        this.buffer[5] = ip[1];
        this.buffer[6] = ip[2];
        this.buffer[7] = ip[3];
    }

    public String getUserId() {
        return this.getString(8, 248);
    }

    public void setUserId(String id) {
        this.setString(8, 248, id);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("");
        buf.append("Version: ");
        buf.append(Integer.toHexString(this.getVersionNumber()));
        buf.append(" Command: ");
        buf.append(Integer.toHexString(this.getCommandOrResult()));
        buf.append(" Port: ");
        buf.append(this.getPort());
        buf.append(" IP: ");
        buf.append(Integer.toHexString(this.getIP()));
        buf.append(" User ID: ");
        buf.append(this.getUserId());
        return buf.toString();
    }

    public int getLength() {
        int index = 0;
        index = 8;
        while (this.buffer[index] != 0) {
            ++index;
        }
        return ++index;
    }

    public String getErrorString(int error) {
        switch (error) {
            case 91: {
                return Msg.getString("K00cd");
            }
            case 92: {
                return Msg.getString("K00ce");
            }
            case 93: {
                return Msg.getString("K00cf");
            }
        }
        return Msg.getString("K00d0");
    }

    public byte[] getBytes() {
        return this.buffer;
    }

    private int getInt16(int offset) {
        return ((this.buffer[offset] & 0xFF) << 8) + (this.buffer[offset + 1] & 0xFF);
    }

    private int getInt32(int offset) {
        return (this.buffer[offset + 3] & 0xFF) + ((this.buffer[offset + 2] & 0xFF) << 8) + ((this.buffer[offset + 1] & 0xFF) << 16) + ((this.buffer[offset + 0] & 0xFF) << 24);
    }

    private String getString(int offset, int maxLength) {
        String result;
        int index = offset;
        int lastIndex = index + maxLength;
        while (index < lastIndex && this.buffer[index] != 0) {
            ++index;
        }
        try {
            result = new String(this.buffer, offset, index - offset, "ISO8859_1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.toString());
        }
        return result;
    }

    private int getVersionNumber() {
        return this.buffer[0];
    }

    private void setInt16(int offset, int value) {
        this.buffer[offset] = (byte)(value >>> 8 & 0xFF);
        this.buffer[offset + 1] = (byte)(value & 0xFF);
    }

    private void setString(int offset, int maxLength, String theString) {
        byte[] stringBytes;
        try {
            stringBytes = theString.getBytes("ISO8859_1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.toString());
        }
        int length = Math.min(stringBytes.length, maxLength);
        System.arraycopy((Object)stringBytes, 0, (Object)this.buffer, offset, length);
        this.buffer[offset + length] = 0;
    }

    private void setVersionNumber(int number) {
        this.buffer[0] = (byte)number;
    }
}

