/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.BasicPermissionCollection;
import java.security.Permission;
import java.security.PermissionCollection;

public abstract class BasicPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = 6279438298436773498L;
    private transient String wildcard;

    public BasicPermission(String name) {
        super(name);
        int length = name.length();
        if (length > 1) {
            if (name.charAt(length - 1) == '*' && name.charAt(length - 2) == '.') {
                this.wildcard = name.substring(0, length - 1);
            }
        } else if (length == 1 && name.charAt(0) == '*') {
            this.wildcard = "";
        } else if (length == 0) {
            throw new IllegalArgumentException();
        }
    }

    public BasicPermission(String name, String actions) {
        this(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            return this.getName().equals(((BasicPermission)o).getName());
        }
        return false;
    }

    public String getActions() {
        return "";
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean implies(Permission p) {
        if (this == p) {
            return true;
        }
        if (p != null && this.getClass() == p.getClass()) {
            if (this.wildcard != null) {
                return p.getName().startsWith(this.wildcard);
            }
            return p.getName().equals(this.getName());
        }
        return false;
    }

    public PermissionCollection newPermissionCollection() {
        return new BasicPermissionCollection();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        String name = this.getName();
        int length = name.length();
        if (length > 1) {
            if (name.charAt(length - 1) == '*' && name.charAt(length - 2) == '.') {
                this.wildcard = name.substring(0, length - 1);
            }
        } else if (length == 1 && name.charAt(0) == '*') {
            this.wildcard = "";
        }
    }
}

