/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;

public class DigestInputStream
extends FilterInputStream {
    protected MessageDigest digest;
    private boolean on;

    public DigestInputStream(InputStream in, MessageDigest digest) {
        super(in);
        this.setMessageDigest(digest);
        this.on(true);
    }

    public MessageDigest getMessageDigest() {
        return this.digest;
    }

    public void on(boolean on) {
        this.on = on;
    }

    public int read() throws IOException {
        int result = super.read();
        if (this.on && result >= 0) {
            this.digest.engineUpdate((byte)result);
        }
        return result;
    }

    public int read(byte[] buffer, int offset, int count) throws IOException {
        int read = super.read(buffer, offset, count);
        if (this.on && read > 0) {
            this.digest.engineUpdate(buffer, offset, read);
        }
        return read;
    }

    public void setMessageDigest(MessageDigest digest) {
        this.digest = digest;
    }

    public String toString() {
        StringBuffer answer = new StringBuffer("[Digest Input Stream]");
        if (this.digest != null) {
            answer.append(" ");
            answer.append(this.digest.toString());
        }
        if (this.on) {
            answer.append(", <on>");
        } else {
            answer.append(", <off>");
        }
        return answer.toString();
    }
}

