/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.ibm.oti.util.Msg;
import java.security.DigestException;

public abstract class MessageDigestSpi {
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected abstract byte[] engineDigest();

    protected int engineDigest(byte[] buffer, int offset, int length) throws DigestException {
        if (buffer == null) {
            throw new IllegalArgumentException(Msg.getString("K0047"));
        }
        if (buffer.length < offset + length) {
            throw new IllegalArgumentException(Msg.getString("K03a2"));
        }
        byte[] digest = this.engineDigest();
        if (digest.length > buffer.length - offset) {
            throw new DigestException(Msg.getString("K03a2"));
        }
        if (length < digest.length) {
            throw new DigestException("Digest length exceeds passed value");
        }
        int toCopy = length;
        if (digest.length < toCopy) {
            toCopy = digest.length;
        }
        System.arraycopy((Object)digest, 0, (Object)buffer, offset, toCopy);
        this.engineReset();
        return toCopy;
    }

    protected int engineGetDigestLength() {
        return 0;
    }

    protected abstract void engineReset();

    protected abstract void engineUpdate(byte[] var1, int var2, int var3);

    protected abstract void engineUpdate(byte var1);
}

