/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.ByteArrayInputStream;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Iterator;
import java.util.List;

public abstract class CertPath
implements Serializable {
    private String type;

    protected CertPath(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public abstract Iterator getEncodings();

    public boolean equals(Object other) {
        if (!(other instanceof CertPath)) {
            return false;
        }
        CertPath comparePath = (CertPath)other;
        if (comparePath.type != this.type) {
            return false;
        }
        return comparePath.getCertificates() == this.getCertificates();
    }

    public abstract List getCertificates();

    public int hashCode() {
        return 31 * this.getType().hashCode() + this.getCertificates().hashCode();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Iterator iter = this.getCertificates().iterator();
        while (iter.hasNext()) {
            Certificate element = (Certificate)iter.next();
            buffer.append(element.toString());
        }
        return buffer.toString();
    }

    public abstract byte[] getEncoded() throws CertificateEncodingException;

    public abstract byte[] getEncoded(String var1) throws CertificateEncodingException;

    protected Object writeReplace() throws ObjectStreamException {
        byte[] data;
        try {
            data = this.getEncoded(this.type);
        }
        catch (CertificateEncodingException e) {
            throw new NotSerializableException(e.getMessage());
        }
        return new CertPathRep(this.type, data);
    }

    protected static class CertPathRep
    implements Serializable {
        private String type;
        private byte[] data;

        protected CertPathRep(String type, byte[] data) {
            this.type = type;
            this.data = data;
        }

        protected Object readResolve() throws ObjectStreamException {
            CertPath path;
            try {
                CertificateFactory cf = CertificateFactory.getInstance(this.type);
                ByteArrayInputStream baos = new ByteArrayInputStream(this.data);
                path = cf.generateCertPath(baos);
            }
            catch (CertificateException e) {
                throw new InvalidObjectException(e.getMessage());
            }
            return path;
        }
    }
}

