/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.ChoiceFormat;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;

public class MessageFormat
extends Format {
    private static final long serialVersionUID = 6479157306784022952L;
    private Locale locale = Locale.getDefault();
    private transient String[] strings;
    private int[] argumentNumbers;
    private Format[] formats;
    private int maxOffset;
    private transient int maxArgumentIndex;
    private static final ObjectStreamField[] serialPersistentFields;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[6];
        Class clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectStreamFieldArray[0] = new ObjectStreamField("argumentNumbers", clazz);
        Class clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[Ljava.text.Format;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectStreamFieldArray[1] = new ObjectStreamField("formats", clazz2);
        Class clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.util.Locale");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectStreamFieldArray[2] = new ObjectStreamField("locale", clazz3);
        objectStreamFieldArray[3] = new ObjectStreamField("maxOffset", Integer.TYPE);
        Class clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectStreamFieldArray[4] = new ObjectStreamField("offsets", clazz4);
        Class clazz5 = class$3;
        if (clazz5 == null) {
            try {
                clazz5 = class$3 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectStreamFieldArray[5] = new ObjectStreamField("pattern", clazz5);
        serialPersistentFields = objectStreamFieldArray;
    }

    public MessageFormat(String template, Locale locale) {
        this.locale = locale;
        this.applyPattern(template);
    }

    public MessageFormat(String template) {
        this.applyPattern(template);
    }

    public void applyPattern(String template) {
        int length = template.length();
        StringBuffer buffer = new StringBuffer();
        ParsePosition position = new ParsePosition(0);
        Vector strings = new Vector();
        int argCount = 0;
        int[] args = new int[10];
        int maxArg = -1;
        Vector formats = new Vector();
        while (position.getIndex() < length) {
            if (Format.upTo(template, position, buffer, '{')) {
                byte arg;
                int offset = position.getIndex();
                if (offset >= length || (arg = (byte)Character.digit(template.charAt(offset++), 10)) == -1) {
                    throw new IllegalArgumentException(Msg.getString("K001d"));
                }
                position.setIndex(offset);
                formats.addElement(this.parseVariable(template, position));
                if (argCount >= args.length) {
                    int[] newArgs = new int[args.length * 2];
                    System.arraycopy((Object)args, 0, (Object)newArgs, 0, args.length);
                    args = newArgs;
                }
                args[argCount++] = arg;
                if (arg > maxArg) {
                    maxArg = arg;
                }
            }
            strings.addElement(buffer.toString());
            buffer.setLength(0);
        }
        this.strings = new String[strings.size()];
        int i = 0;
        while (i < strings.size()) {
            this.strings[i] = (String)strings.elementAt(i);
            ++i;
        }
        this.argumentNumbers = args;
        this.formats = new Format[argCount];
        i = 0;
        while (i < argCount) {
            this.formats[i] = (Format)formats.elementAt(i);
            ++i;
        }
        this.maxOffset = argCount - 1;
        this.maxArgumentIndex = maxArg;
    }

    public Object clone() {
        MessageFormat clone = (MessageFormat)super.clone();
        Format[] array = new Format[this.formats.length];
        int i = this.formats.length;
        while (--i >= 0) {
            if (this.formats[i] == null) continue;
            array[i] = (Format)this.formats[i].clone();
        }
        clone.formats = array;
        return clone;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MessageFormat)) {
            return false;
        }
        MessageFormat format = (MessageFormat)object;
        if (this.maxOffset != format.maxOffset) {
            return false;
        }
        int i = 0;
        while (i <= this.maxOffset) {
            if (this.argumentNumbers[i] != format.argumentNumbers[i]) {
                return false;
            }
            ++i;
        }
        return this.locale.equals(format.locale) && Arrays.equals(this.strings, format.strings) && Arrays.equals(this.formats, format.formats);
    }

    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        StringBuffer buffer = new StringBuffer();
        Vector fields = new Vector();
        this.formatImpl((Object[])object, buffer, new FieldPosition(0), fields);
        AttributedString as = new AttributedString(buffer.toString());
        int i = 0;
        while (i < fields.size()) {
            FieldContainer fc = (FieldContainer)fields.elementAt(i);
            as.addAttribute(fc.attribute, fc.value, fc.start, fc.end);
            ++i;
        }
        return as.getIterator();
    }

    public final StringBuffer format(Object[] objects, StringBuffer buffer, FieldPosition field) {
        return this.formatImpl(objects, buffer, field, null);
    }

    /*
     * Unable to fully structure code
     */
    private StringBuffer formatImpl(Object[] objects, StringBuffer buffer, FieldPosition position, Vector fields) {
        passedField = new FieldPosition(0);
        i = 0;
        while (i <= this.maxOffset) {
            block7: {
                block8: {
                    block6: {
                        buffer.append(this.strings[i]);
                        begin = buffer.length();
                        if (objects != null && this.argumentNumbers[i] < objects.length) break block6;
                        buffer.append('{');
                        buffer.append(this.argumentNumbers[i]);
                        buffer.append('}');
                        this.handleArgumentField(begin, buffer.length(), this.argumentNumbers[i], position, fields);
                        break block7;
                    }
                    arg = objects[this.argumentNumbers[i]];
                    format = this.formats[i];
                    if (format != null && arg != null) ** GOTO lbl30
                    if (!(arg instanceof Number)) break block8;
                    format = NumberFormat.getInstance();
                    ** GOTO lbl30
                }
                if (!(arg instanceof Date)) {
                    buffer.append(arg);
                    this.handleArgumentField(begin, buffer.length(), this.argumentNumbers[i], position, fields);
                } else {
                    format = DateFormat.getInstance();
lbl30:
                    // 3 sources

                    if (format instanceof ChoiceFormat) {
                        result = format.format(arg);
                        mf = new MessageFormat(result);
                        mf.setLocale(this.locale);
                        mf.format(objects, buffer, passedField);
                        this.handleArgumentField(begin, buffer.length(), this.argumentNumbers[i], position, fields);
                        this.handleformat(format, arg, begin, fields);
                    } else {
                        format.format(arg, buffer, passedField);
                        this.handleArgumentField(begin, buffer.length(), this.argumentNumbers[i], position, fields);
                        this.handleformat(format, arg, begin, fields);
                    }
                }
            }
            ++i;
        }
        if (this.maxOffset + 1 < this.strings.length) {
            buffer.append(this.strings[this.maxOffset + 1]);
        }
        return buffer;
    }

    private void handleArgumentField(int begin, int end, int argnumber, FieldPosition position, Vector fields) {
        if (fields != null) {
            fields.add(new FieldContainer(begin, end, Field.ARGUMENT, new Integer(argnumber)));
        } else if (position != null && position.getFieldAttribute() == Field.ARGUMENT && position.getEndIndex() == 0) {
            position.setBeginIndex(begin);
            position.setEndIndex(end);
        }
    }

    private void handleformat(Format format, Object arg, int begin, Vector fields) {
        if (fields != null) {
            AttributedCharacterIterator iterator = format.formatToCharacterIterator(arg);
            while (iterator.getIndex() != iterator.getEndIndex()) {
                int start = iterator.getRunStart();
                int end = iterator.getRunLimit();
                Iterator it = iterator.getAttributes().keySet().iterator();
                while (it.hasNext()) {
                    AttributedCharacterIterator.Attribute attribute = (AttributedCharacterIterator.Attribute)it.next();
                    Object value = iterator.getAttribute(attribute);
                    fields.add(new FieldContainer(begin + start, begin + end, attribute, value));
                }
                iterator.setIndex(end);
            }
        }
    }

    public final StringBuffer format(Object object, StringBuffer buffer, FieldPosition field) {
        return this.format((Object[])object, buffer, field);
    }

    public static String format(String template, Object[] objects) {
        return new MessageFormat(template).format(objects);
    }

    public Format[] getFormats() {
        return (Format[])this.formats.clone();
    }

    public Format[] getFormatsByArgumentIndex() {
        Format[] answer = new Format[this.maxArgumentIndex + 1];
        int i = 0;
        while (i < this.maxOffset + 1) {
            answer[this.argumentNumbers[i]] = this.formats[i];
            ++i;
        }
        return answer;
    }

    public void setFormatByArgumentIndex(int argIndex, Format format) {
        int i = 0;
        while (i < this.maxOffset + 1) {
            if (this.argumentNumbers[i] == argIndex) {
                this.formats[i] = format;
            }
            ++i;
        }
    }

    public void setFormatsByArgumentIndex(Format[] formats) {
        int j = 0;
        while (j < formats.length) {
            int i = 0;
            while (i < this.maxOffset + 1) {
                if (this.argumentNumbers[i] == j) {
                    this.formats[i] = formats[j];
                }
                ++i;
            }
            ++j;
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int hashCode() {
        int hashCode = 0;
        int i = 0;
        while (i <= this.maxOffset) {
            hashCode += this.argumentNumbers[i] + this.strings[i].hashCode();
            if (this.formats[i] != null) {
                hashCode += this.formats[i].hashCode();
            }
            ++i;
        }
        if (this.maxOffset + 1 < this.strings.length) {
            hashCode += this.strings[this.maxOffset + 1].hashCode();
        }
        return hashCode + this.locale.hashCode();
    }

    public Object[] parse(String string) throws ParseException {
        ParsePosition position = new ParsePosition(0);
        Object[] result = this.parse(string, position);
        if (position.getErrorIndex() != -1 || position.getIndex() == 0) {
            throw new ParseException(null, position.getErrorIndex());
        }
        return result;
    }

    public Object[] parse(String string, ParsePosition position) {
        if (string == null) {
            return new Object[0];
        }
        ParsePosition internalPos = new ParsePosition(0);
        int offset = position.getIndex();
        Object[] result = new Object[this.maxArgumentIndex + 1];
        int i = 0;
        while (i <= this.maxOffset) {
            Object parse;
            String sub = this.strings[i];
            if (!string.startsWith(sub, offset)) {
                position.setErrorIndex(offset);
                return null;
            }
            offset += sub.length();
            Format format = this.formats[i];
            if (format == null) {
                if (i + 1 < this.strings.length) {
                    int next = string.indexOf(this.strings[i + 1], offset);
                    if (next == -1) {
                        position.setErrorIndex(offset);
                        return null;
                    }
                    parse = string.substring(offset, next);
                    offset = next;
                } else {
                    parse = string.substring(offset);
                    offset = string.length();
                }
            } else {
                internalPos.setIndex(offset);
                parse = format.parseObject(string, internalPos);
                if (internalPos.getErrorIndex() != -1) {
                    position.setErrorIndex(offset);
                    return null;
                }
                offset = internalPos.getIndex();
            }
            result[this.argumentNumbers[i]] = parse;
            ++i;
        }
        if (this.maxOffset + 1 < this.strings.length) {
            String sub = this.strings[this.maxOffset + 1];
            if (!string.startsWith(sub, offset)) {
                position.setErrorIndex(offset);
                return null;
            }
            offset += sub.length();
        }
        position.setIndex(offset);
        return result;
    }

    public Object parseObject(String string, ParsePosition position) {
        return this.parse(string, position);
    }

    private int match(String string, ParsePosition position, boolean last, String[] tokens) {
        char ch;
        int length = string.length();
        int offset = position.getIndex();
        int token = -1;
        while (offset < length && Character.isWhitespace(string.charAt(offset))) {
            ++offset;
        }
        int i = tokens.length;
        while (--i >= 0) {
            if (!string.regionMatches(true, offset, tokens[i], 0, tokens[i].length())) continue;
            token = i;
            break;
        }
        if (token == -1) {
            return -1;
        }
        offset += tokens[token].length();
        while (offset < length && Character.isWhitespace(string.charAt(offset))) {
            ++offset;
        }
        if (offset < length && ((ch = string.charAt(offset)) == '}' || !last && ch == ',')) {
            position.setIndex(offset + 1);
            return token;
        }
        return -1;
    }

    private Format parseVariable(String string, ParsePosition position) {
        char ch;
        int length = string.length();
        int offset = position.getIndex();
        if (offset >= length || (ch = string.charAt(offset++)) != '}' && ch != ',') {
            throw new IllegalArgumentException(Msg.getString("K001e"));
        }
        position.setIndex(offset);
        if (ch == '}') {
            return null;
        }
        int type = this.match(string, position, false, new String[]{"time", "date", "number", "choice"});
        if (type == -1) {
            throw new IllegalArgumentException(Msg.getString("K001f"));
        }
        StringBuffer buffer = new StringBuffer();
        ch = string.charAt(position.getIndex() - 1);
        switch (type) {
            case 0: 
            case 1: {
                if (ch == '}') {
                    return type == 1 ? DateFormat.getDateInstance(2, this.locale) : DateFormat.getTimeInstance(2, this.locale);
                }
                int dateStyle = this.match(string, position, true, new String[]{"full", "long", "medium", "short"});
                if (dateStyle == -1) {
                    Format.upToWithQuotes(string, position, buffer, '}', '{');
                    return new SimpleDateFormat(buffer.toString(), this.locale);
                }
                switch (dateStyle) {
                    case 0: {
                        dateStyle = 0;
                        break;
                    }
                    case 1: {
                        dateStyle = 1;
                        break;
                    }
                    case 2: {
                        dateStyle = 2;
                        break;
                    }
                    case 3: {
                        dateStyle = 3;
                    }
                }
                return type == 1 ? DateFormat.getDateInstance(dateStyle, this.locale) : DateFormat.getTimeInstance(dateStyle, this.locale);
            }
            case 2: {
                if (ch == '}') {
                    return NumberFormat.getInstance();
                }
                int numberStyle = this.match(string, position, true, new String[]{"currency", "percent", "integer"});
                if (numberStyle == -1) {
                    Format.upToWithQuotes(string, position, buffer, '}', '{');
                    return new DecimalFormat(buffer.toString(), new DecimalFormatSymbols(this.locale));
                }
                switch (numberStyle) {
                    case 0: {
                        return NumberFormat.getCurrencyInstance(this.locale);
                    }
                    case 1: {
                        return NumberFormat.getPercentInstance(this.locale);
                    }
                }
                return NumberFormat.getIntegerInstance(this.locale);
            }
        }
        try {
            Format.upToWithQuotes(string, position, buffer, '}', '{');
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return new ChoiceFormat(buffer.toString());
    }

    public void setFormat(int offset, Format format) {
        this.formats[offset] = format;
    }

    public void setFormats(Format[] formats) {
        int min = this.formats.length;
        if (formats.length < min) {
            min = formats.length;
        }
        int i = 0;
        while (i < min) {
            this.formats[i] = formats[i];
            ++i;
        }
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        int i = 0;
        while (i <= this.maxOffset) {
            Format format = this.formats[i];
            if (format instanceof DecimalFormat) {
                this.formats[i] = new DecimalFormat(((DecimalFormat)format).toPattern(), new DecimalFormatSymbols(locale));
            } else if (format instanceof SimpleDateFormat) {
                this.formats[i] = new SimpleDateFormat(((SimpleDateFormat)format).toPattern(), locale);
            }
            ++i;
        }
    }

    private String decodeDecimalFormat(StringBuffer buffer, Format format) {
        buffer.append(",number");
        if (!format.equals(NumberFormat.getNumberInstance(this.locale))) {
            if (format.equals(NumberFormat.getIntegerInstance(this.locale))) {
                buffer.append(",integer");
            } else if (format.equals(NumberFormat.getCurrencyInstance(this.locale))) {
                buffer.append(",currency");
            } else if (format.equals(NumberFormat.getPercentInstance(this.locale))) {
                buffer.append(",percent");
            } else {
                buffer.append(',');
                return ((DecimalFormat)format).toPattern();
            }
        }
        return null;
    }

    private String decodeSimpleDateFormat(StringBuffer buffer, Format format) {
        if (format.equals(DateFormat.getTimeInstance(2, this.locale))) {
            buffer.append(",time");
        } else if (format.equals(DateFormat.getDateInstance(2, this.locale))) {
            buffer.append(",date");
        } else if (format.equals(DateFormat.getTimeInstance(3, this.locale))) {
            buffer.append(",time,short");
        } else if (format.equals(DateFormat.getDateInstance(3, this.locale))) {
            buffer.append(",date,short");
        } else if (format.equals(DateFormat.getTimeInstance(1, this.locale))) {
            buffer.append(",time,long");
        } else if (format.equals(DateFormat.getDateInstance(1, this.locale))) {
            buffer.append(",date,long");
        } else if (format.equals(DateFormat.getTimeInstance(0, this.locale))) {
            buffer.append(",time,full");
        } else if (format.equals(DateFormat.getDateInstance(0, this.locale))) {
            buffer.append(",date,full");
        } else {
            buffer.append(",date,");
            return ((SimpleDateFormat)format).toPattern();
        }
        return null;
    }

    public String toPattern() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i <= this.maxOffset) {
            this.appendQuoted(buffer, this.strings[i]);
            buffer.append('{');
            buffer.append(this.argumentNumbers[i]);
            Format format = this.formats[i];
            String pattern = null;
            if (format instanceof ChoiceFormat) {
                buffer.append(",choice,");
                pattern = ((ChoiceFormat)format).toPattern();
            } else if (format instanceof DecimalFormat) {
                pattern = this.decodeDecimalFormat(buffer, format);
            } else if (format instanceof SimpleDateFormat) {
                pattern = this.decodeSimpleDateFormat(buffer, format);
            } else if (format != null) {
                throw new IllegalArgumentException(Msg.getString("K0020"));
            }
            if (pattern != null) {
                boolean quote = false;
                int index = 0;
                int length = pattern.length();
                int count = 0;
                while (index < length) {
                    int ch;
                    if ((ch = pattern.charAt(index++)) == 39) {
                        boolean bl = quote = !quote;
                    }
                    if (!quote) {
                        if (ch == 123) {
                            ++count;
                        }
                        if (ch == 125) {
                            if (count > 0) {
                                --count;
                            } else {
                                buffer.append("'}");
                                ch = 39;
                            }
                        }
                    }
                    buffer.append((char)ch);
                }
            }
            buffer.append('}');
            ++i;
        }
        if (this.maxOffset + 1 < this.strings.length) {
            this.appendQuoted(buffer, this.strings[this.maxOffset + 1]);
        }
        return buffer.toString();
    }

    private void appendQuoted(StringBuffer buffer, String string) {
        int length = string.length();
        int i = 0;
        while (i < length) {
            char ch = string.charAt(i);
            if (ch == '{' || ch == '}') {
                buffer.append('\'');
                buffer.append(ch);
                buffer.append('\'');
            } else {
                buffer.append(ch);
            }
            ++i;
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        ObjectOutputStream.PutField fields = stream.putFields();
        fields.put("argumentNumbers", this.argumentNumbers);
        Format[] compatibleFormats = this.formats;
        fields.put("formats", compatibleFormats);
        fields.put("locale", this.locale);
        fields.put("maxOffset", this.maxOffset);
        int offset = 0;
        int offsetsLength = this.maxOffset + 1;
        int[] offsets = new int[offsetsLength];
        StringBuffer pattern = new StringBuffer();
        int i = 0;
        while (i <= this.maxOffset) {
            offsets[i] = offset += this.strings[i].length();
            pattern.append(this.strings[i]);
            ++i;
        }
        if (this.maxOffset + 1 < this.strings.length) {
            pattern.append(this.strings[this.maxOffset + 1]);
        }
        fields.put("offsets", offsets);
        fields.put("pattern", pattern.toString());
        stream.writeFields();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = stream.readFields();
        this.argumentNumbers = (int[])fields.get("argumentNumbers", null);
        this.formats = (Format[])fields.get("formats", null);
        this.locale = (Locale)fields.get("locale", null);
        this.maxOffset = fields.get("maxOffset", 0);
        int[] offsets = (int[])fields.get("offsets", null);
        String pattern = (String)fields.get("pattern", null);
        int length = this.maxOffset < 0 ? (pattern.length() > 0 ? 1 : 0) : this.maxOffset + (offsets[this.maxOffset] == pattern.length() ? 1 : 2);
        this.strings = new String[length];
        int last = 0;
        int i = 0;
        while (i <= this.maxOffset) {
            this.strings[i] = pattern.substring(last, offsets[i]);
            last = offsets[i];
            ++i;
        }
        if (this.maxOffset + 1 < this.strings.length) {
            this.strings[this.strings.length - 1] = pattern.substring(last, pattern.length());
        }
    }

    private static class FieldContainer {
        int start;
        int end;
        AttributedCharacterIterator.Attribute attribute;
        Object value;

        public FieldContainer(int start, int end, AttributedCharacterIterator.Attribute attribute, Object value) {
            this.start = start;
            this.end = end;
            this.attribute = attribute;
            this.value = value;
        }
    }

    public static class Field
    extends Format.Field {
        public static final Field ARGUMENT = new Field("message argument field");

        protected Field(String fieldName) {
            super(fieldName);
        }

        protected Object readResolve() throws InvalidObjectException {
            String name = this.getName();
            if (name == null) {
                throw new InvalidObjectException(Msg.getString("K0344", "MessageFormat.Field"));
            }
            if (name.equals(ARGUMENT.getName())) {
                return ARGUMENT;
            }
            throw new InvalidObjectException(Msg.getString("K0344", "MessageFormat.Field"));
        }
    }
}

