/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import com.ibm.oti.locale.Locale;
import com.ibm.oti.util.ExtendedResourceBundle;
import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.Vector;

public class SimpleDateFormat
extends DateFormat {
    private static final long serialVersionUID = 4774881970558875024L;
    private static final String patternChars = "GyMdkHmsSEDFwWahKzZ";
    private String pattern;
    private DateFormatSymbols formatData;
    private transient int creationYear;
    private Date defaultCenturyStart;
    private static final ObjectStreamField[] serialPersistentFields;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[4];
        Class clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectStreamFieldArray[0] = new ObjectStreamField("defaultCenturyStart", clazz);
        Class clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.text.DateFormatSymbols");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectStreamFieldArray[1] = new ObjectStreamField("formatData", clazz2);
        Class clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectStreamFieldArray[2] = new ObjectStreamField("pattern", clazz3);
        objectStreamFieldArray[3] = new ObjectStreamField("serialVersionOnStream", Integer.TYPE);
        serialPersistentFields = objectStreamFieldArray;
    }

    public SimpleDateFormat() {
        this(java.util.Locale.getDefault());
        this.pattern = SimpleDateFormat.defaultPattern();
        this.formatData = new DateFormatSymbols(java.util.Locale.getDefault());
    }

    public SimpleDateFormat(String pattern) {
        this(pattern, java.util.Locale.getDefault());
    }

    public SimpleDateFormat(String template, DateFormatSymbols value) {
        this(java.util.Locale.getDefault());
        this.validatePattern(template);
        this.pattern = template;
        this.formatData = (DateFormatSymbols)value.clone();
    }

    public SimpleDateFormat(String template, java.util.Locale locale) {
        this(locale);
        this.validatePattern(template);
        this.pattern = template;
        this.formatData = new DateFormatSymbols(locale);
    }

    private SimpleDateFormat(java.util.Locale locale) {
        this.numberFormat = NumberFormat.getInstance(locale);
        this.numberFormat.setParseIntegerOnly(true);
        this.numberFormat.setGroupingUsed(false);
        this.calendar = new GregorianCalendar(locale);
        this.calendar.add(1, -80);
        this.creationYear = this.calendar.get(1);
        this.defaultCenturyStart = this.calendar.getTime();
    }

    private void append(StringBuffer buffer, FieldPosition position, Vector fields, char format, int count) {
        int field = -1;
        int index = patternChars.indexOf(format);
        if (index == -1) {
            throw new IllegalArgumentException(Msg.getString("K002b", format));
        }
        int beginPosition = buffer.length();
        DateFormat.Field dateFormatField = null;
        switch (index) {
            case 0: {
                dateFormatField = DateFormat.Field.ERA;
                buffer.append(this.formatData.eras[this.calendar.get(0)]);
                break;
            }
            case 1: {
                dateFormatField = DateFormat.Field.YEAR;
                int year = this.calendar.get(1);
                if (count < 4) {
                    this.appendNumber(buffer, 2, year %= 100);
                    break;
                }
                this.appendNumber(buffer, 4, year);
                break;
            }
            case 2: {
                dateFormatField = DateFormat.Field.MONTH;
                int month = this.calendar.get(2);
                if (count <= 2) {
                    this.appendNumber(buffer, count, month + 1);
                    break;
                }
                if (count == 3) {
                    buffer.append(this.formatData.shortMonths[month]);
                    break;
                }
                buffer.append(this.formatData.months[month]);
                break;
            }
            case 3: {
                dateFormatField = DateFormat.Field.DAY_OF_MONTH;
                field = 5;
                break;
            }
            case 4: {
                dateFormatField = DateFormat.Field.HOUR_OF_DAY1;
                int hour = this.calendar.get(11);
                this.appendNumber(buffer, count, hour == 0 ? 24 : hour);
                break;
            }
            case 5: {
                dateFormatField = DateFormat.Field.HOUR_OF_DAY0;
                field = 11;
                break;
            }
            case 6: {
                dateFormatField = DateFormat.Field.MINUTE;
                field = 12;
                break;
            }
            case 7: {
                dateFormatField = DateFormat.Field.SECOND;
                field = 13;
                break;
            }
            case 8: {
                dateFormatField = DateFormat.Field.MILLISECOND;
                int value = this.calendar.get(14);
                this.appendNumber(buffer, count, value);
                break;
            }
            case 9: {
                dateFormatField = DateFormat.Field.DAY_OF_WEEK;
                int day = this.calendar.get(7);
                if (count < 4) {
                    buffer.append(this.formatData.shortWeekdays[day]);
                    break;
                }
                buffer.append(this.formatData.weekdays[day]);
                break;
            }
            case 10: {
                dateFormatField = DateFormat.Field.DAY_OF_YEAR;
                field = 6;
                break;
            }
            case 11: {
                dateFormatField = DateFormat.Field.DAY_OF_WEEK_IN_MONTH;
                field = 8;
                break;
            }
            case 12: {
                dateFormatField = DateFormat.Field.WEEK_OF_YEAR;
                field = 3;
                break;
            }
            case 13: {
                dateFormatField = DateFormat.Field.WEEK_OF_MONTH;
                field = 4;
                break;
            }
            case 14: {
                dateFormatField = DateFormat.Field.AM_PM;
                buffer.append(this.formatData.ampms[this.calendar.get(9)]);
                break;
            }
            case 15: {
                dateFormatField = DateFormat.Field.HOUR1;
                int hour = this.calendar.get(10);
                this.appendNumber(buffer, count, hour == 0 ? 12 : hour);
                break;
            }
            case 16: {
                dateFormatField = DateFormat.Field.HOUR0;
                field = 10;
                break;
            }
            case 17: {
                dateFormatField = DateFormat.Field.TIME_ZONE;
                this.appendTimeZone(buffer, count, true);
                break;
            }
            case 18: {
                dateFormatField = DateFormat.Field.TIME_ZONE;
                this.appendTimeZone(buffer, count, false);
            }
        }
        if (field != -1) {
            this.appendNumber(buffer, count, this.calendar.get(field));
        }
        if (fields != null) {
            position = new FieldPosition(dateFormatField);
            position.setBeginIndex(beginPosition);
            position.setEndIndex(buffer.length());
            fields.add(position);
        } else if ((position.getFieldAttribute() == dateFormatField || position.getFieldAttribute() == null && position.getField() == index) && position.getEndIndex() == 0) {
            position.setBeginIndex(beginPosition);
            position.setEndIndex(buffer.length());
        }
    }

    private void appendTimeZone(StringBuffer buffer, int count, boolean generalTimezone) {
        if (generalTimezone) {
            String id = this.calendar.getTimeZone().getID();
            String[][] zones = this.formatData.zoneStrings;
            String[] zone = null;
            int i = 0;
            while (i < zones.length) {
                if (id.equals(zones[i][0])) {
                    zone = zones[i];
                    break;
                }
                ++i;
            }
            if (zone == null) {
                int offset = this.calendar.get(15) + this.calendar.get(16);
                char sign = '+';
                if (offset < 0) {
                    sign = '-';
                    offset = -offset;
                }
                buffer.append("GMT");
                buffer.append(sign);
                this.appendNumber(buffer, 2, offset / 3600000);
                buffer.append(':');
                this.appendNumber(buffer, 2, offset % 3600000 / 60000);
            } else {
                int daylight;
                int n = daylight = this.calendar.get(16) == 0 ? 0 : 2;
                if (count < 4) {
                    buffer.append(zone[2 + daylight]);
                } else {
                    buffer.append(zone[1 + daylight]);
                }
            }
        } else {
            int offset = this.calendar.get(15) + this.calendar.get(16);
            char sign = '+';
            if (offset < 0) {
                sign = '-';
                offset = -offset;
            }
            buffer.append(sign);
            this.appendNumber(buffer, 2, offset / 3600000);
            this.appendNumber(buffer, 2, offset % 3600000 / 60000);
        }
    }

    private void appendNumber(StringBuffer buffer, int count, int value) {
        int org = this.numberFormat.getMinimumIntegerDigits();
        this.numberFormat.setMinimumIntegerDigits(count);
        this.numberFormat.format(new Integer(value), buffer, new FieldPosition(0));
        this.numberFormat.setMinimumIntegerDigits(org);
    }

    public void applyLocalizedPattern(String template) {
        this.pattern = this.convertPattern(template, this.formatData.getLocalPatternChars(), patternChars, true);
    }

    public void applyPattern(String template) {
        this.validatePattern(template);
        this.pattern = template;
    }

    public Object clone() {
        SimpleDateFormat clone = (SimpleDateFormat)super.clone();
        clone.formatData = (DateFormatSymbols)this.formatData.clone();
        clone.defaultCenturyStart = new Date(this.defaultCenturyStart.getTime());
        return clone;
    }

    private static String defaultPattern() {
        ExtendedResourceBundle bundle = (ExtendedResourceBundle)SimpleDateFormat.getBundle(java.util.Locale.getDefault());
        StringBuffer pattern = new StringBuffer();
        pattern.append((String)bundle.getObject(Locale.DATE_SHORT));
        pattern.append(" ");
        pattern.append((String)bundle.getObject(Locale.TIME_SHORT));
        return pattern.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SimpleDateFormat)) {
            return false;
        }
        SimpleDateFormat simple = (SimpleDateFormat)object;
        return super.equals(object) && this.pattern.equals(simple.pattern) && this.formatData.equals(simple.formatData);
    }

    private Date error(ParsePosition position, int offset, TimeZone zone) {
        position.setErrorIndex(offset);
        this.calendar.setTimeZone(zone);
        return null;
    }

    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        if (object instanceof Date) {
            return this.formatToCharacterIteratorImpl((Date)object);
        }
        if (object instanceof Number) {
            return this.formatToCharacterIteratorImpl(new Date(((Number)object).longValue()));
        }
        throw new IllegalArgumentException();
    }

    private AttributedCharacterIterator formatToCharacterIteratorImpl(Date date) {
        StringBuffer buffer = new StringBuffer();
        Vector fields = new Vector();
        this.formatImpl(date, buffer, null, fields);
        AttributedString as = new AttributedString(buffer.toString());
        int i = 0;
        while (i < fields.size()) {
            FieldPosition pos = (FieldPosition)fields.elementAt(i);
            Format.Field attribute = pos.getFieldAttribute();
            as.addAttribute(attribute, attribute, pos.getBeginIndex(), pos.getEndIndex());
            ++i;
        }
        return as.getIterator();
    }

    public StringBuffer format(Date date, StringBuffer buffer, FieldPosition field) {
        return this.formatImpl(date, buffer, field, null);
    }

    private void validateFormat(char format) {
        int index = patternChars.indexOf(format);
        if (index == -1) {
            throw new IllegalArgumentException(Msg.getString("K002b", format));
        }
    }

    private void validatePattern(String template) {
        boolean quote = false;
        int last = -1;
        int count = 0;
        int patternLength = template.length();
        int i = 0;
        while (i < patternLength) {
            int next = template.charAt(i);
            if (next == 39) {
                if (count > 0) {
                    this.validateFormat((char)last);
                    count = 0;
                }
                last = last == next ? -1 : next;
                quote = !quote;
            } else if (!quote && (last == next || next >= 97 && next <= 122 || next >= 65 && next <= 90)) {
                if (last == next) {
                    ++count;
                } else {
                    if (count > 0) {
                        this.validateFormat((char)last);
                    }
                    last = next;
                    count = 1;
                }
            } else {
                if (count > 0) {
                    this.validateFormat((char)last);
                    count = 0;
                }
                last = -1;
            }
            ++i;
        }
        if (count > 0) {
            this.validateFormat((char)last);
        }
        if (quote) {
            throw new IllegalArgumentException(Msg.getString("K0019"));
        }
    }

    private StringBuffer formatImpl(Date date, StringBuffer buffer, FieldPosition field, Vector fields) {
        boolean quote = false;
        int last = -1;
        int count = 0;
        this.calendar.setTime(date);
        if (field != null) {
            field.clear();
        }
        int patternLength = this.pattern.length();
        int i = 0;
        while (i < patternLength) {
            int next = this.pattern.charAt(i);
            if (next == 39) {
                if (count > 0) {
                    this.append(buffer, field, fields, (char)last, count);
                    count = 0;
                }
                if (last == next) {
                    buffer.append('\'');
                    last = -1;
                } else {
                    last = next;
                }
                quote = !quote;
            } else if (!quote && (last == next || next >= 97 && next <= 122 || next >= 65 && next <= 90)) {
                if (last == next) {
                    ++count;
                } else {
                    if (count > 0) {
                        this.append(buffer, field, fields, (char)last, count);
                    }
                    last = next;
                    count = 1;
                }
            } else {
                if (count > 0) {
                    this.append(buffer, field, fields, (char)last, count);
                    count = 0;
                }
                last = -1;
                buffer.append((char)next);
            }
            ++i;
        }
        if (count > 0) {
            this.append(buffer, field, fields, (char)last, count);
        }
        return buffer;
    }

    public Date get2DigitYearStart() {
        return this.defaultCenturyStart;
    }

    public DateFormatSymbols getDateFormatSymbols() {
        return (DateFormatSymbols)this.formatData.clone();
    }

    public int hashCode() {
        return super.hashCode() + this.pattern.hashCode() + this.formatData.hashCode() + this.creationYear;
    }

    private int parse(String string, int offset, char format, int count) {
        int index = patternChars.indexOf(format);
        if (index == -1) {
            throw new IllegalArgumentException(Msg.getString("K002b", format));
        }
        int field = -1;
        int absolute = 0;
        if (count < 0) {
            absolute = count = -count;
        }
        switch (index) {
            case 0: {
                return this.parseText(string, offset, this.formatData.eras, 0);
            }
            case 1: {
                if (count >= 3) {
                    field = 1;
                    break;
                }
                ParsePosition position = new ParsePosition(offset);
                Number result = this.parseNumber(absolute, string, position);
                if (result == null) {
                    return -position.getErrorIndex() - 1;
                }
                int year = result.intValue();
                if (position.getIndex() - offset == 2 && year >= 0 && (year += this.creationYear / 100 * 100) < this.creationYear) {
                    year += 100;
                }
                this.calendar.set(1, year);
                return position.getIndex();
            }
            case 2: {
                if (count <= 2) {
                    return this.parseNumber(absolute, string, offset, 2, -1);
                }
                index = this.parseText(string, offset, this.formatData.months, 2);
                if (index < 0) {
                    return this.parseText(string, offset, this.formatData.shortMonths, 2);
                }
                return index;
            }
            case 3: {
                field = 5;
                break;
            }
            case 4: {
                ParsePosition position = new ParsePosition(offset);
                Number result = this.parseNumber(absolute, string, position);
                if (result == null) {
                    return -position.getErrorIndex() - 1;
                }
                int hour = result.intValue();
                if (hour == 24) {
                    hour = 0;
                }
                this.calendar.set(11, hour);
                return position.getIndex();
            }
            case 5: {
                field = 11;
                break;
            }
            case 6: {
                field = 12;
                break;
            }
            case 7: {
                field = 13;
                break;
            }
            case 8: {
                field = 14;
                break;
            }
            case 9: {
                index = this.parseText(string, offset, this.formatData.weekdays, 7);
                if (index < 0) {
                    return this.parseText(string, offset, this.formatData.shortWeekdays, 7);
                }
                return index;
            }
            case 10: {
                field = 6;
                break;
            }
            case 11: {
                field = 8;
                break;
            }
            case 12: {
                field = 3;
                break;
            }
            case 13: {
                field = 4;
                break;
            }
            case 14: {
                return this.parseText(string, offset, this.formatData.ampms, 9);
            }
            case 15: {
                ParsePosition position = new ParsePosition(offset);
                Number result = this.parseNumber(absolute, string, position);
                if (result == null) {
                    return -position.getErrorIndex() - 1;
                }
                int hour = result.intValue();
                if (hour == 12) {
                    hour = 0;
                }
                this.calendar.set(10, hour);
                return position.getIndex();
            }
            case 16: {
                field = 10;
                break;
            }
            case 17: {
                return this.parseTimeZone(string, offset);
            }
            case 18: {
                return this.parseTimeZone(string, offset);
            }
        }
        if (field != -1) {
            return this.parseNumber(absolute, string, offset, field, 0);
        }
        return offset;
    }

    public Date parse(String string, ParsePosition position) {
        Date date;
        boolean quote = false;
        int last = -1;
        int count = 0;
        int offset = position.getIndex();
        int length = string.length();
        this.calendar.clear();
        TimeZone zone = this.calendar.getTimeZone();
        int patternLength = this.pattern.length();
        int i = 0;
        while (i < patternLength) {
            int next = this.pattern.charAt(i);
            if (next == 39) {
                if (count > 0) {
                    if ((offset = this.parse(string, offset, (char)last, count)) < 0) {
                        return this.error(position, -offset - 1, zone);
                    }
                    count = 0;
                }
                if (last == next) {
                    if (offset >= length || string.charAt(offset) != '\'') {
                        return this.error(position, offset, zone);
                    }
                    ++offset;
                    last = -1;
                } else {
                    last = next;
                }
                quote = !quote;
            } else if (!quote && (last == next || next >= 97 && next <= 122 || next >= 65 && next <= 90)) {
                if (last == next) {
                    ++count;
                } else {
                    if (count > 0 && (offset = this.parse(string, offset, (char)last, -count)) < 0) {
                        return this.error(position, -offset - 1, zone);
                    }
                    last = next;
                    count = 1;
                }
            } else {
                if (count > 0) {
                    if ((offset = this.parse(string, offset, (char)last, count)) < 0) {
                        return this.error(position, -offset - 1, zone);
                    }
                    count = 0;
                }
                last = -1;
                if (offset >= length || string.charAt(offset) != next) {
                    return this.error(position, offset, zone);
                }
                ++offset;
            }
            ++i;
        }
        if (count > 0 && (offset = this.parse(string, offset, (char)last, count)) < 0) {
            return this.error(position, -offset - 1, zone);
        }
        try {
            date = this.calendar.getTime();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this.error(position, offset, zone);
        }
        position.setIndex(offset);
        this.calendar.setTimeZone(zone);
        return date;
    }

    private Number parseNumber(int max, String string, ParsePosition position) {
        int digit;
        if (max == 0) {
            return this.numberFormat.parse(string, position);
        }
        int length = string.length();
        int result = 0;
        int index = position.getIndex();
        if (max > 0 && max < length - index) {
            length = index + max;
        }
        while (index < length && (digit = Character.digit(string.charAt(index), 10)) != -1) {
            ++index;
            result = result * 10 + digit;
        }
        if (index == position.getIndex()) {
            position.setErrorIndex(index);
            return null;
        }
        position.setIndex(index);
        return new Integer(result);
    }

    private int parseNumber(int max, String string, int offset, int field, int skew) {
        ParsePosition position = new ParsePosition(offset);
        Number result = this.parseNumber(max, string, position);
        if (result == null) {
            return -position.getErrorIndex() - 1;
        }
        this.calendar.set(field, result.intValue() + skew);
        return position.getIndex();
    }

    private int parseText(String string, int offset, String[] text, int field) {
        int found = -1;
        int i = 0;
        while (i < text.length) {
            if (text[i].length() != 0 && string.regionMatches(true, offset, text[i], 0, text[i].length()) && (found == -1 || text[i].length() > text[found].length())) {
                found = i;
            }
            ++i;
        }
        if (found != -1) {
            this.calendar.set(field, found);
            return offset + text[found].length();
        }
        return -offset - 1;
    }

    private int parseTimeZone(String string, int offset) {
        int matchLength;
        char sign;
        String[][] zones = this.formatData.zoneStrings;
        boolean foundGMT = string.regionMatches(offset, "GMT", 0, 3);
        if (foundGMT) {
            offset += 3;
        }
        if (offset < string.length() && ((sign = string.charAt(offset)) == '+' || sign == '-')) {
            ParsePosition position = new ParsePosition(offset + 1);
            Number result = this.numberFormat.parse(string, position);
            if (result == null) {
                return -position.getErrorIndex() - 1;
            }
            int hour = result.intValue();
            int raw = hour * 3600000;
            int index = position.getIndex();
            if (index < string.length() && string.charAt(index) == ':') {
                position.setIndex(index + 1);
                result = this.numberFormat.parse(string, position);
                if (result == null) {
                    return -position.getErrorIndex() - 1;
                }
                int minute = result.intValue();
                raw += minute * 60000;
            } else if (hour >= 24) {
                raw = hour / 100 * 3600000 + hour % 100 * 60000;
            }
            if (sign == '-') {
                raw = -raw;
            }
            this.calendar.setTimeZone(new SimpleTimeZone(raw, ""));
            return position.getIndex();
        }
        if (foundGMT) {
            this.calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
            return offset;
        }
        int index = -1;
        TimeZone tz = null;
        String id = this.calendar.getTimeZone().getID();
        int i = 0;
        while (i < zones.length) {
            if (id.equals(zones[i][0])) {
                tz = TimeZone.getTimeZone(zones[i][0]);
                if (!this.calendar.getTimeZone().hasSameRules(tz)) break;
                index = i;
                break;
            }
            ++i;
        }
        if (index >= 0 && (matchLength = this.matchTZ(string, offset, index, tz)) > 0) {
            return offset + matchLength;
        }
        i = 0;
        while (i < zones.length) {
            int matchLength2 = this.matchTZ(string, offset, i, null);
            if (matchLength2 > 0) {
                return offset + matchLength2;
            }
            ++i;
        }
        return -offset - 1;
    }

    private int matchTZ(String string, int offset, int index, TimeZone tz) {
        int i = 1;
        while (i < 5) {
            if (string.regionMatches(true, offset, this.formatData.zoneStrings[index][i], 0, this.formatData.zoneStrings[index][i].length())) {
                if (tz == null) {
                    tz = TimeZone.getTimeZone(this.formatData.zoneStrings[index][0]);
                }
                if (tz == null) {
                    return 0;
                }
                int raw = tz.getRawOffset();
                if (i >= 3 && tz.useDaylightTime()) {
                    raw += 3600000;
                }
                this.calendar.setTimeZone(new SimpleTimeZone(raw, ""));
                return this.formatData.zoneStrings[index][i].length();
            }
            ++i;
        }
        return 0;
    }

    public void set2DigitYearStart(Date date) {
        this.defaultCenturyStart = date;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        this.creationYear = cal.get(1);
    }

    public void setDateFormatSymbols(DateFormatSymbols value) {
        this.formatData = (DateFormatSymbols)value.clone();
    }

    public String toLocalizedPattern() {
        return this.convertPattern(this.pattern, patternChars, this.formatData.getLocalPatternChars(), false);
    }

    public String toPattern() {
        return this.pattern;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        ObjectOutputStream.PutField fields = stream.putFields();
        fields.put("defaultCenturyStart", this.defaultCenturyStart);
        fields.put("formatData", this.formatData);
        fields.put("pattern", this.pattern);
        fields.put("serialVersionOnStream", 1);
        stream.writeFields();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = stream.readFields();
        int version = fields.get("serialVersionOnStream", 0);
        Date date = version > 0 ? (Date)fields.get("defaultCenturyStart", new Date()) : new Date();
        this.set2DigitYearStart(date);
        this.formatData = (DateFormatSymbols)fields.get("formatData", null);
        this.pattern = (String)fields.get("pattern", "");
    }
}

