/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CharacterIterator;

public final class StringCharacterIterator
implements CharacterIterator {
    String string;
    int start;
    int end;
    int offset;

    public StringCharacterIterator(String value) {
        this.string = value;
        this.offset = 0;
        this.start = 0;
        this.end = this.string.length();
    }

    public StringCharacterIterator(String value, int location) {
        this.string = value;
        this.start = 0;
        this.end = this.string.length();
        if (location < 0 || location > this.end) {
            throw new IllegalArgumentException();
        }
        this.offset = location;
    }

    public StringCharacterIterator(String value, int start, int end, int location) {
        this.string = value;
        if (start < 0 || end > this.string.length() || start > end || location < start || location > end) {
            throw new IllegalArgumentException();
        }
        this.start = start;
        this.end = end;
        this.offset = location;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public char current() {
        if (this.offset == this.end) {
            return '\uffff';
        }
        return this.string.charAt(this.offset);
    }

    public boolean equals(Object object) {
        if (!(object instanceof StringCharacterIterator)) {
            return false;
        }
        StringCharacterIterator it = (StringCharacterIterator)object;
        return this.string.equals(it.string) && this.start == it.start && this.end == it.end && this.offset == it.offset;
    }

    public char first() {
        if (this.start == this.end) {
            return '\uffff';
        }
        this.offset = this.start;
        return this.string.charAt(this.offset);
    }

    public int getBeginIndex() {
        return this.start;
    }

    public int getEndIndex() {
        return this.end;
    }

    public int getIndex() {
        return this.offset;
    }

    public int hashCode() {
        return this.string.hashCode() + this.start + this.end + this.offset;
    }

    public char last() {
        if (this.start == this.end) {
            return '\uffff';
        }
        this.offset = this.end - 1;
        return this.string.charAt(this.offset);
    }

    public char next() {
        if (this.offset >= this.end - 1) {
            this.offset = this.end;
            return '\uffff';
        }
        return this.string.charAt(++this.offset);
    }

    public char previous() {
        if (this.offset == this.start) {
            return '\uffff';
        }
        return this.string.charAt(--this.offset);
    }

    public char setIndex(int location) {
        if (location < this.start || location > this.end) {
            throw new IllegalArgumentException();
        }
        this.offset = location;
        if (this.offset == this.end) {
            return '\uffff';
        }
        return this.string.charAt(this.offset);
    }

    public void setText(String value) {
        this.string = value;
        this.offset = 0;
        this.start = 0;
        this.end = value.length();
    }
}

