/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.ibm.oti.util.PriviAction;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.AccessController;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.MapEntry;

public class Properties
extends Hashtable {
    private static final long serialVersionUID = 4112578634029874840L;
    protected Properties defaults;
    private static final int NONE = 0;
    private static final int SLASH = 1;
    private static final int UNICODE = 2;
    private static final int CONTINUE = 3;
    private static final int KEY_DONE = 4;
    private static final int IGNORE = 5;
    private static String lineSeparator;

    public Properties() {
    }

    public Properties(Properties properties) {
        this.defaults = properties;
    }

    private void dumpString(StringBuffer buffer, String string, boolean key) {
        int i = 0;
        if (!key && i < string.length() && string.charAt(i) == ' ') {
            buffer.append("\\ ");
            ++i;
        }
        while (i < string.length()) {
            char ch = string.charAt(i);
            switch (ch) {
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                default: {
                    if ("\\#!=:".indexOf(ch) >= 0 || key && ch == ' ') {
                        buffer.append('\\');
                    }
                    if (ch >= ' ' && ch <= '~') {
                        buffer.append(ch);
                        break;
                    }
                    String hex = Integer.toHexString(ch);
                    buffer.append("\\u");
                    int j = 0;
                    while (j < 4 - hex.length()) {
                        buffer.append("0");
                        ++j;
                    }
                    buffer.append(hex);
                }
            }
            ++i;
        }
    }

    public String getProperty(String name) {
        String property;
        Object result = this.get(name);
        String string = property = result instanceof String ? (String)result : null;
        if (property == null && this.defaults != null) {
            property = this.defaults.getProperty(name);
        }
        return property;
    }

    public String getProperty(String name, String defaultValue) {
        String property;
        Object result = this.get(name);
        String string = property = result instanceof String ? (String)result : null;
        if (property == null && this.defaults != null) {
            property = this.defaults.getProperty(name);
        }
        if (property == null) {
            return defaultValue;
        }
        return property;
    }

    public void list(PrintStream out) {
        if (out == null) {
            throw new NullPointerException();
        }
        StringBuffer buffer = new StringBuffer(80);
        Enumeration keys = this.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            buffer.append(key);
            buffer.append('=');
            String property = (String)this.get(key);
            Properties def = this.defaults;
            while (property == null) {
                property = (String)def.get(key);
                def = def.defaults;
            }
            if (property.length() > 40) {
                buffer.append(property.substring(0, 37));
                buffer.append("...");
            } else {
                buffer.append(property);
            }
            out.println(buffer.toString());
            buffer.setLength(0);
        }
    }

    public void list(PrintWriter writer) {
        if (writer == null) {
            throw new NullPointerException();
        }
        StringBuffer buffer = new StringBuffer(80);
        Enumeration keys = this.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            buffer.append(key);
            buffer.append('=');
            String property = (String)this.get(key);
            Properties def = this.defaults;
            while (property == null) {
                property = (String)def.get(key);
                def = def.defaults;
            }
            if (property.length() > 40) {
                buffer.append(property.substring(0, 37));
                buffer.append("...");
            } else {
                buffer.append(property);
            }
            writer.println(buffer.toString());
            buffer.setLength(0);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized void load(InputStream in) throws IOException {
        int mode = 0;
        int unicode = 0;
        int count = 0;
        char[] buf = new char[40];
        int offset = 0;
        int keyLength = -1;
        boolean firstChar = true;
        byte[] inbuf = new byte[256];
        int inbufCount = 0;
        int inbufPos = 0;
        block17: while (true) {
            block34: {
                block36: {
                    block37: {
                        block35: {
                            if (inbufPos != inbufCount) break block34;
                            inbufCount = in.read(inbuf);
                            if (inbufCount != -1) break block35;
                            if (keyLength < 0) break block36;
                            break block37;
                        }
                        inbufPos = 0;
                        break block34;
                    }
                    String temp = new String(buf, 0, offset);
                    this.put(temp.substring(0, keyLength), temp.substring(keyLength));
                }
                return;
            }
            int nextChar = inbuf[inbufPos++] & 0xFF;
            if (offset == buf.length) {
                char[] newBuf = new char[buf.length * 2];
                System.arraycopy((Object)buf, 0, (Object)newBuf, 0, offset);
                buf = newBuf;
            }
            if (mode == 2) {
                int digit = Character.digit((char)nextChar, 16);
                if (digit >= 0) {
                    unicode = (unicode << 4) + digit;
                    if (++count < 4) continue;
                }
                mode = 0;
                buf[offset++] = (char)unicode;
                if (nextChar != 10) continue;
            }
            if (mode == 1) {
                mode = 0;
                switch (nextChar) {
                    case 13: {
                        mode = 3;
                        continue block17;
                    }
                    case 10: {
                        mode = 5;
                        continue block17;
                    }
                    case 98: {
                        nextChar = 8;
                        break;
                    }
                    case 102: {
                        nextChar = 12;
                        break;
                    }
                    case 110: {
                        nextChar = 10;
                        break;
                    }
                    case 114: {
                        nextChar = 13;
                        break;
                    }
                    case 116: {
                        nextChar = 9;
                        break;
                    }
                    case 117: {
                        mode = 2;
                        count = 0;
                        unicode = 0;
                        continue block17;
                    }
                }
            } else {
                switch (nextChar) {
                    case 33: 
                    case 35: {
                        if (!firstChar) break;
                        do {
                            if (inbufPos != inbufCount) continue;
                            inbufCount = in.read(inbuf);
                            if (inbufCount == -1) {
                                inbufPos = -1;
                                continue block17;
                            }
                            inbufPos = 0;
                        } while ((nextChar = (int)((char)inbuf[inbufPos++])) != 13 && nextChar != 10);
                        continue block17;
                    }
                    case 10: {
                        if (mode == 3) {
                            mode = 5;
                            continue block17;
                        }
                    }
                    case 13: {
                        mode = 0;
                        firstChar = true;
                        if (offset > 0) {
                            if (keyLength == -1) {
                                keyLength = offset;
                            }
                            String temp = new String(buf, 0, offset);
                            this.put(temp.substring(0, keyLength), temp.substring(keyLength));
                        }
                        keyLength = -1;
                        offset = 0;
                        continue block17;
                    }
                    case 92: {
                        if (mode == 4) {
                            keyLength = offset;
                        }
                        mode = 1;
                        continue block17;
                    }
                    case 58: 
                    case 61: {
                        if (keyLength != -1) break;
                        mode = 0;
                        keyLength = offset;
                        continue block17;
                    }
                }
                if (Character.isWhitespace((char)nextChar)) {
                    if (mode == 3) {
                        mode = 5;
                    }
                    if (offset == 0 || offset == keyLength || mode == 5) continue;
                    if (keyLength == -1) {
                        mode = 4;
                        continue;
                    }
                }
                if (mode == 5 || mode == 3) {
                    mode = 0;
                }
            }
            firstChar = false;
            if (mode == 4) {
                keyLength = offset;
                mode = 0;
            }
            buf[offset++] = nextChar;
        }
    }

    public Enumeration propertyNames() {
        if (this.defaults == null) {
            return this.keys();
        }
        Hashtable set = new Hashtable(this.defaults.size() + this.size());
        Enumeration keys = this.defaults.propertyNames();
        while (keys.hasMoreElements()) {
            set.put(keys.nextElement(), set);
        }
        keys = this.keys();
        while (keys.hasMoreElements()) {
            set.put(keys.nextElement(), set);
        }
        return set.keys();
    }

    public void save(OutputStream out, String comment) {
        try {
            this.store(out, comment);
        }
        catch (IOException iOException) {}
    }

    public synchronized Object setProperty(String name, String value) {
        return this.put(name, value);
    }

    public synchronized void store(OutputStream out, String comment) throws IOException {
        if (lineSeparator == null) {
            lineSeparator = (String)AccessController.doPrivileged(new PriviAction("line.separator"));
        }
        StringBuffer buffer = new StringBuffer(200);
        OutputStreamWriter writer = new OutputStreamWriter(out, "ISO8859_1");
        if (comment != null) {
            writer.write("#" + comment + lineSeparator);
        }
        writer.write("#" + new Date() + lineSeparator);
        Iterator entryItr = this.entrySet().iterator();
        while (entryItr.hasNext()) {
            MapEntry entry = (MapEntry)entryItr.next();
            String key = (String)entry.getKey();
            this.dumpString(buffer, key, true);
            buffer.append('=');
            this.dumpString(buffer, (String)entry.getValue(), false);
            buffer.append(lineSeparator);
            writer.write(buffer.toString());
            buffer.setLength(0);
        }
        writer.flush();
    }
}

