/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class SimpleTimeZone
extends TimeZone {
    private static final long serialVersionUID = -403250971215465050L;
    private int rawOffset;
    private int startYear;
    private int startMonth;
    private int startDay;
    private int startDayOfWeek;
    private int startTime;
    private int endMonth;
    private int endDay;
    private int endDayOfWeek;
    private int endTime;
    private int startMode;
    private int endMode;
    private int startTimeMode;
    private int endTimeMode;
    private static final int DOM_MODE = 1;
    private static final int DOW_IN_MONTH_MODE = 2;
    private static final int DOW_GE_DOM_MODE = 3;
    private static final int DOW_LE_DOM_MODE = 4;
    public static final int UTC_TIME = 2;
    public static final int STANDARD_TIME = 1;
    public static final int WALL_TIME = 0;
    private boolean useDaylight;
    private GregorianCalendar daylightSavings;
    private int dstSavings = 3600000;
    private static final ObjectStreamField[] serialPersistentFields;
    static /* synthetic */ Class class$0;

    static {
        ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[18];
        objectStreamFieldArray[0] = new ObjectStreamField("dstSavings", Integer.TYPE);
        objectStreamFieldArray[1] = new ObjectStreamField("endDay", Integer.TYPE);
        objectStreamFieldArray[2] = new ObjectStreamField("endDayOfWeek", Integer.TYPE);
        objectStreamFieldArray[3] = new ObjectStreamField("endMode", Integer.TYPE);
        objectStreamFieldArray[4] = new ObjectStreamField("endMonth", Integer.TYPE);
        objectStreamFieldArray[5] = new ObjectStreamField("endTime", Integer.TYPE);
        objectStreamFieldArray[6] = new ObjectStreamField("endTimeMode", Integer.TYPE);
        Class clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[B");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectStreamFieldArray[7] = new ObjectStreamField("monthLength", clazz);
        objectStreamFieldArray[8] = new ObjectStreamField("rawOffset", Integer.TYPE);
        objectStreamFieldArray[9] = new ObjectStreamField("serialVersionOnStream", Integer.TYPE);
        objectStreamFieldArray[10] = new ObjectStreamField("startDay", Integer.TYPE);
        objectStreamFieldArray[11] = new ObjectStreamField("startDayOfWeek", Integer.TYPE);
        objectStreamFieldArray[12] = new ObjectStreamField("startMode", Integer.TYPE);
        objectStreamFieldArray[13] = new ObjectStreamField("startMonth", Integer.TYPE);
        objectStreamFieldArray[14] = new ObjectStreamField("startTime", Integer.TYPE);
        objectStreamFieldArray[15] = new ObjectStreamField("startTimeMode", Integer.TYPE);
        objectStreamFieldArray[16] = new ObjectStreamField("startYear", Integer.TYPE);
        objectStreamFieldArray[17] = new ObjectStreamField("useDaylight", Boolean.TYPE);
        serialPersistentFields = objectStreamFieldArray;
    }

    public SimpleTimeZone(int offset, String name) {
        this.setID(name);
        this.rawOffset = offset;
    }

    public SimpleTimeZone(int offset, String name, int startMonth, int startDay, int startDayOfWeek, int startTime, int endMonth, int endDay, int endDayOfWeek, int endTime) {
        this(offset, name, startMonth, startDay, startDayOfWeek, startTime, endMonth, endDay, endDayOfWeek, endTime, 3600000);
    }

    public SimpleTimeZone(int offset, String name, int startMonth, int startDay, int startDayOfWeek, int startTime, int endMonth, int endDay, int endDayOfWeek, int endTime, int daylightSavings) {
        this(offset, name);
        if (daylightSavings <= 0) {
            throw new IllegalArgumentException(Msg.getString("K00e9", daylightSavings));
        }
        this.dstSavings = daylightSavings;
        this.setStartRule(startMonth, startDay, startDayOfWeek, startTime);
        this.setEndRule(endMonth, endDay, endDayOfWeek, endTime);
    }

    public SimpleTimeZone(int offset, String name, int startMonth, int startDay, int startDayOfWeek, int startTime, int startTimeMode, int endMonth, int endDay, int endDayOfWeek, int endTime, int endTimeMode, int daylightSavings) {
        this(offset, name);
        if (daylightSavings <= 0) {
            throw new IllegalArgumentException(Msg.getString("K00e9", daylightSavings));
        }
        this.dstSavings = daylightSavings;
        this.setStartRule(startMonth, startDay, startDayOfWeek, startTime);
        this.setEndRule(endMonth, endDay, endDayOfWeek, endTime);
        if (startTimeMode > 2 || startTimeMode < 0) {
            throw new IllegalArgumentException(Msg.getString("K03c5", startTimeMode));
        }
        this.startTimeMode = startTimeMode;
        if (endTimeMode > 2 || endTimeMode < 0) {
            throw new IllegalArgumentException(Msg.getString("K03c5", endTimeMode));
        }
        this.endTimeMode = endTimeMode;
    }

    public Object clone() {
        SimpleTimeZone zone = (SimpleTimeZone)super.clone();
        if (this.daylightSavings != null) {
            zone.daylightSavings = (GregorianCalendar)this.daylightSavings.clone();
        }
        return zone;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SimpleTimeZone)) {
            return false;
        }
        SimpleTimeZone tz = (SimpleTimeZone)object;
        return this.getID().equals(tz.getID()) && this.rawOffset == tz.rawOffset && this.useDaylight == tz.useDaylight && (!this.useDaylight || this.startYear == tz.startYear && this.startMonth == tz.startMonth && this.startDay == tz.startDay && this.startMode == tz.startMode && this.startDayOfWeek == tz.startDayOfWeek && this.startTime == tz.startTime && this.startTimeMode == tz.startTimeMode && this.endMonth == tz.endMonth && this.endDay == tz.endDay && this.endDayOfWeek == tz.endDayOfWeek && this.endTime == tz.endTime && this.endTimeMode == tz.endTimeMode && this.endMode == tz.endMode && this.dstSavings == tz.dstSavings);
    }

    public int getDSTSavings() {
        if (!this.useDaylight) {
            return 0;
        }
        return this.dstSavings;
    }

    public int getOffset(int era, int year, int month, int day, int dayOfWeek, int time) {
        int previousMonth;
        if (era != 0 && era != 1) {
            throw new IllegalArgumentException(Msg.getString("K00ea", era));
        }
        this.checkRange(month, dayOfWeek, time);
        if (month != 1 || day != 29 || !this.isLeapYear(year)) {
            this.checkDay(month, day);
        }
        if ((previousMonth = month - 1) < 0) {
            previousMonth = 11;
        }
        if (!this.useDaylightTime() || era != 1 || year < this.startYear) {
            return this.rawOffset;
        }
        boolean afterStart = false;
        boolean beforeEnd = false;
        int ruleDay = 0;
        int ruleTime = this.startTime;
        if (this.startTimeMode == 2) {
            ruleTime += this.rawOffset;
        }
        int startRuleMonth = this.startMonth;
        int prevStartMonth = this.startMonth - 1;
        if (prevStartMonth < 0) {
            prevStartMonth = 11;
        }
        if (month == this.startMonth || month == prevStartMonth || previousMonth == this.startMonth) {
            int daysInPrevStartMonth = GregorianCalendar.DaysInMonth[prevStartMonth];
            if (prevStartMonth == 1 && this.isLeapYear(year)) {
                ++daysInPrevStartMonth;
            }
            int daysInStartMonth = GregorianCalendar.DaysInMonth[this.startMonth];
            if (this.startMonth == 1 && this.isLeapYear(year)) {
                ++daysInStartMonth;
            }
            int firstDayOfMonth = this.mod7(dayOfWeek - day);
            if (month != this.startMonth) {
                firstDayOfMonth = month == prevStartMonth ? this.mod7(firstDayOfMonth + daysInPrevStartMonth) : this.mod7(firstDayOfMonth - daysInStartMonth);
            }
            switch (this.startMode) {
                case 1: {
                    ruleDay = this.startDay;
                    break;
                }
                case 2: {
                    if (this.startDay >= 0) {
                        ruleDay = this.mod7(this.startDayOfWeek - firstDayOfMonth) + 1 + (this.startDay - 1) * 7;
                        break;
                    }
                    ruleDay = daysInStartMonth + 1 + this.mod7(this.startDayOfWeek - (firstDayOfMonth + daysInStartMonth)) + this.startDay * 7;
                    break;
                }
                case 3: {
                    ruleDay = this.startDay + this.mod7(this.startDayOfWeek - (firstDayOfMonth + this.startDay - 1));
                    break;
                }
                case 4: {
                    ruleDay = this.startDay + this.mod7(this.startDayOfWeek - (firstDayOfMonth + this.startDay - 1));
                    if (ruleDay == this.startDay) break;
                    ruleDay -= 7;
                }
            }
            if (ruleTime < 0) {
                --ruleDay;
                ruleTime += 86400000;
            }
            if (ruleTime >= 86400000) {
                ++ruleDay;
                ruleTime -= 86400000;
            }
            if (ruleDay > daysInStartMonth) {
                if (++startRuleMonth > 11) {
                    startRuleMonth = 0;
                }
                ruleDay -= daysInStartMonth;
            }
            if (ruleDay < 1) {
                if (--startRuleMonth < 0) {
                    startRuleMonth = 11;
                }
                ruleDay += daysInPrevStartMonth;
            }
            if (month == startRuleMonth && (day > ruleDay || day == ruleDay && time >= ruleTime)) {
                afterStart = true;
            }
        }
        ruleTime = this.endTime;
        if (this.endTimeMode == 0) {
            ruleTime -= this.dstSavings;
        } else if (this.endTimeMode == 2) {
            ruleTime += this.rawOffset;
        }
        int endRuleMonth = this.endMonth;
        int prevEndMonth = this.endMonth - 1;
        if (prevEndMonth < 0) {
            prevEndMonth = 11;
        }
        if (month == this.endMonth || month == prevEndMonth || previousMonth == this.endMonth) {
            int daysInPrevEndMonth = GregorianCalendar.DaysInMonth[prevEndMonth];
            if (prevEndMonth == 1 && this.isLeapYear(year)) {
                ++daysInPrevEndMonth;
            }
            int daysInEndMonth = GregorianCalendar.DaysInMonth[this.endMonth];
            if (this.endMonth == 1 && this.isLeapYear(year)) {
                ++daysInEndMonth;
            }
            int firstDayOfMonth = this.mod7(dayOfWeek - day);
            if (month != this.endMonth) {
                firstDayOfMonth = month == prevEndMonth ? this.mod7(firstDayOfMonth + daysInPrevEndMonth) : this.mod7(firstDayOfMonth - daysInEndMonth);
            }
            switch (this.endMode) {
                case 1: {
                    ruleDay = this.endDay;
                    break;
                }
                case 2: {
                    if (this.endDay >= 0) {
                        ruleDay = this.mod7(this.endDayOfWeek - firstDayOfMonth) + 1 + (this.endDay - 1) * 7;
                        break;
                    }
                    ruleDay = daysInEndMonth + 1 + this.mod7(this.endDayOfWeek - (firstDayOfMonth + daysInEndMonth)) + this.endDay * 7;
                    break;
                }
                case 3: {
                    ruleDay = this.endDay + this.mod7(this.endDayOfWeek - (firstDayOfMonth + this.endDay - 1));
                    break;
                }
                case 4: {
                    ruleDay = this.endDay + this.mod7(this.endDayOfWeek - (firstDayOfMonth + this.endDay - 1));
                    if (ruleDay == this.endDay) break;
                    ruleDay -= 7;
                }
            }
            if (ruleTime < 0) {
                --ruleDay;
                ruleTime += 86400000;
            }
            if (ruleTime >= 86400000) {
                ++ruleDay;
                ruleTime -= 86400000;
            }
            if (ruleDay > daysInEndMonth) {
                if (++endRuleMonth > 11) {
                    endRuleMonth = 0;
                }
                ruleDay -= daysInEndMonth;
            }
            if (ruleDay < 1) {
                if (--endRuleMonth < 0) {
                    endRuleMonth = 11;
                }
                ruleDay += daysInPrevEndMonth;
            }
            if (month == endRuleMonth && (day < ruleDay || day == ruleDay && time < ruleTime)) {
                beforeEnd = true;
            }
        }
        if (endRuleMonth >= startRuleMonth ? !(!afterStart && month <= startRuleMonth || !beforeEnd && month >= endRuleMonth) : !(!afterStart && month <= startRuleMonth && month > endRuleMonth || !beforeEnd && month >= endRuleMonth && month < startRuleMonth)) {
            return this.rawOffset + this.dstSavings;
        }
        return this.rawOffset;
    }

    public int getOffset(long time) {
        if (!this.useDaylightTime()) {
            return this.rawOffset;
        }
        if (this.daylightSavings == null) {
            GregorianCalendar cal = new GregorianCalendar(false);
            cal.setTimeZone(this);
            this.daylightSavings = cal;
        }
        return this.daylightSavings.getOffset(time + (long)this.rawOffset);
    }

    public int getRawOffset() {
        return this.rawOffset;
    }

    public synchronized int hashCode() {
        int hashCode = this.getID().hashCode() + this.rawOffset;
        if (this.useDaylight) {
            hashCode += this.startYear + this.startMonth + this.startDay + this.startDayOfWeek + this.startTime + this.startTimeMode + this.startMode + this.endMonth + this.endDay + this.endDayOfWeek + this.endTime + this.endTimeMode + this.endMode + this.dstSavings;
        }
        return hashCode;
    }

    public boolean hasSameRules(TimeZone zone) {
        if (!(zone instanceof SimpleTimeZone)) {
            return false;
        }
        SimpleTimeZone tz = (SimpleTimeZone)zone;
        if (this.useDaylight != tz.useDaylight) {
            return false;
        }
        if (!this.useDaylight) {
            return this.rawOffset == tz.rawOffset;
        }
        return this.rawOffset == tz.rawOffset && this.dstSavings == tz.dstSavings && this.startYear == tz.startYear && this.startMonth == tz.startMonth && this.startDay == tz.startDay && this.startMode == tz.startMode && this.startDayOfWeek == tz.startDayOfWeek && this.startTime == tz.startTime && this.startTimeMode == tz.startTimeMode && this.endMonth == tz.endMonth && this.endDay == tz.endDay && this.endDayOfWeek == tz.endDayOfWeek && this.endTime == tz.endTime && this.endTimeMode == tz.endTimeMode && this.endMode == tz.endMode;
    }

    public boolean inDaylightTime(Date time) {
        long millis = time.getTime();
        if (!this.useDaylightTime()) {
            return false;
        }
        if (this.daylightSavings == null) {
            GregorianCalendar cal = new GregorianCalendar(false);
            cal.setTimeZone(this);
            this.daylightSavings = cal;
        }
        return this.daylightSavings.getOffset(millis + (long)this.rawOffset) != this.rawOffset;
    }

    private boolean isLeapYear(int year) {
        if (year > 1582) {
            return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
        }
        return year % 4 == 0;
    }

    private int mod7(int num1) {
        int rem = num1 % 7;
        return num1 < 0 && rem < 0 ? 7 + rem : rem;
    }

    public void setDSTSavings(int milliseconds) {
        if (milliseconds <= 0) {
            throw new IllegalArgumentException();
        }
        this.dstSavings = milliseconds;
    }

    private void checkRange(int month, int dayOfWeek, int time) {
        if (month < 0 || month > 11) {
            throw new IllegalArgumentException(Msg.getString("K00e5", month));
        }
        if (dayOfWeek < 1 || dayOfWeek > 7) {
            throw new IllegalArgumentException(Msg.getString("K00e7", dayOfWeek));
        }
        if (time < 0 || time >= 86400000) {
            throw new IllegalArgumentException(Msg.getString("K00e8", time));
        }
    }

    private void checkDay(int month, int day) {
        if (day <= 0 || day > GregorianCalendar.DaysInMonth[month]) {
            throw new IllegalArgumentException(Msg.getString("K00e6", day));
        }
    }

    private void setEndMode() {
        if (this.endDayOfWeek == 0) {
            this.endMode = 1;
        } else if (this.endDayOfWeek < 0) {
            this.endDayOfWeek = -this.endDayOfWeek;
            if (this.endDay < 0) {
                this.endDay = -this.endDay;
                this.endMode = 4;
            } else {
                this.endMode = 3;
            }
        } else {
            this.endMode = 2;
        }
        boolean bl = this.useDaylight = this.startDay != 0 && this.endDay != 0;
        if (this.endDay != 0) {
            this.checkRange(this.endMonth, this.endMode == 1 ? 1 : this.endDayOfWeek, this.endTime);
            if (this.endMode != 2) {
                this.checkDay(this.endMonth, this.endDay);
            } else if (this.endDay < -5 || this.endDay > 5) {
                throw new IllegalArgumentException(Msg.getString("K00f8", this.endDay));
            }
        }
        if (this.endMode != 1) {
            --this.endDayOfWeek;
        }
    }

    public void setEndRule(int month, int dayOfMonth, int time) {
        this.endMonth = month;
        this.endDay = dayOfMonth;
        this.endDayOfWeek = 0;
        this.endTime = time;
        this.endTimeMode = 0;
        this.setEndMode();
    }

    public void setEndRule(int month, int day, int dayOfWeek, int time) {
        this.endMonth = month;
        this.endDay = day;
        this.endDayOfWeek = dayOfWeek;
        this.endTime = time;
        this.endTimeMode = 0;
        this.setEndMode();
    }

    public void setEndRule(int month, int day, int dayOfWeek, int time, boolean after) {
        this.endMonth = month;
        this.endDay = after ? day : -day;
        this.endDayOfWeek = -dayOfWeek;
        this.endTime = time;
        this.endTimeMode = 0;
        this.setEndMode();
    }

    public void setRawOffset(int offset) {
        this.rawOffset = offset;
    }

    private void setStartMode() {
        if (this.startDayOfWeek == 0) {
            this.startMode = 1;
        } else if (this.startDayOfWeek < 0) {
            this.startDayOfWeek = -this.startDayOfWeek;
            if (this.startDay < 0) {
                this.startDay = -this.startDay;
                this.startMode = 4;
            } else {
                this.startMode = 3;
            }
        } else {
            this.startMode = 2;
        }
        boolean bl = this.useDaylight = this.startDay != 0 && this.endDay != 0;
        if (this.startDay != 0) {
            this.checkRange(this.startMonth, this.startMode == 1 ? 1 : this.startDayOfWeek, this.startTime);
            if (this.startMode != 2) {
                this.checkDay(this.startMonth, this.startDay);
            } else if (this.startDay < -5 || this.startDay > 5) {
                throw new IllegalArgumentException(Msg.getString("K00f8", this.startDay));
            }
        }
        if (this.startMode != 1) {
            --this.startDayOfWeek;
        }
    }

    public void setStartRule(int month, int dayOfMonth, int time) {
        this.startMonth = month;
        this.startDay = dayOfMonth;
        this.startDayOfWeek = 0;
        this.startTime = time;
        this.startTimeMode = 0;
        this.setStartMode();
    }

    public void setStartRule(int month, int day, int dayOfWeek, int time) {
        this.startMonth = month;
        this.startDay = day;
        this.startDayOfWeek = dayOfWeek;
        this.startTime = time;
        this.startTimeMode = 0;
        this.setStartMode();
    }

    public void setStartRule(int month, int day, int dayOfWeek, int time, boolean after) {
        this.startMonth = month;
        this.startDay = after ? day : -day;
        this.startDayOfWeek = -dayOfWeek;
        this.startTime = time;
        this.startTimeMode = 0;
        this.setStartMode();
    }

    public void setStartYear(int year) {
        this.startYear = year;
        this.useDaylight = true;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[id=" + this.getID() + ",offset=" + this.rawOffset + ",dstSavings=" + this.dstSavings + ",useDaylight=" + this.useDaylight + ",startYear=" + this.startYear + ",startMode=" + this.startMode + ",startMonth=" + this.startMonth + ",startDay=" + this.startDay + ",startDayOfWeek=" + (this.useDaylight && this.startMode != 1 ? this.startDayOfWeek + 1 : 0) + ",startTime=" + this.startTime + ",startTimeMode=" + this.startTimeMode + ",endMode=" + this.endMode + ",endMonth=" + this.endMonth + ",endDay=" + this.endDay + ",endDayOfWeek=" + (this.useDaylight && this.endMode != 1 ? this.endDayOfWeek + 1 : 0) + ",endTime=" + this.endTime + ",endTimeMode=" + this.endTimeMode + "]";
    }

    public boolean useDaylightTime() {
        return this.useDaylight;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        int sEndDay = this.endDay;
        int sEndDayOfWeek = this.endDayOfWeek + 1;
        int sStartDay = this.startDay;
        int sStartDayOfWeek = this.startDayOfWeek + 1;
        int sEndTime = this.endTime;
        int sStartTime = this.startTime;
        if (this.useDaylight) {
            if (this.endMode != 2) {
                sEndDay = this.endDay / 7 + 1;
                if (this.endMode == 1) {
                    sEndDayOfWeek = 1;
                }
            }
            if (this.startMode != 2) {
                sStartDay = this.startDay / 7 + 1;
                if (this.startMode == 1) {
                    sStartDayOfWeek = 1;
                }
            }
            if (this.endTimeMode == 1) {
                sEndTime += this.dstSavings;
            } else if (this.endTimeMode == 2) {
                sEndTime += this.rawOffset + this.dstSavings;
            }
            if (sEndTime < 0) {
                sEndTime += 86400000;
                --sEndDayOfWeek;
            } else if (sEndTime >= 86400000) {
                sEndTime -= 86400000;
                ++sEndDayOfWeek;
            }
            if (this.endTimeMode == 2) {
                sStartTime += this.rawOffset;
            }
            if (sStartTime < 0) {
                sStartTime += 86400000;
                --sStartDayOfWeek;
            } else if (sStartTime >= 86400000) {
                sStartTime -= 86400000;
                ++sStartDayOfWeek;
            }
        }
        ObjectOutputStream.PutField fields = stream.putFields();
        fields.put("dstSavings", this.dstSavings);
        fields.put("endDay", sEndDay);
        fields.put("endDayOfWeek", (sEndDayOfWeek + 6) % 7 + 1);
        fields.put("endMode", this.endMode);
        fields.put("endMonth", this.endMonth);
        fields.put("endTime", sEndTime);
        fields.put("endTimeMode", this.endTimeMode);
        fields.put("monthLength", GregorianCalendar.DaysInMonth);
        fields.put("rawOffset", this.rawOffset);
        fields.put("serialVersionOnStream", 2);
        fields.put("startDay", sStartDay);
        fields.put("startDayOfWeek", (sStartDayOfWeek + 6) % 7 + 1);
        fields.put("startMode", this.startMode);
        fields.put("startMonth", this.startMonth);
        fields.put("startTime", sStartTime);
        fields.put("startTimeMode", this.startTimeMode);
        fields.put("startYear", this.startYear);
        fields.put("useDaylight", this.useDaylight);
        stream.writeFields();
        stream.writeInt(6);
        byte[] values = new byte[]{(byte)this.startDay, (byte)(this.startMode == 1 ? 0 : this.startDayOfWeek + 1), (byte)this.endDay, (byte)(this.endMode == 1 ? 0 : this.endDayOfWeek + 1), (byte)this.startTimeMode, (byte)this.endTimeMode};
        stream.write(values);
        stream.writeObject(new int[]{this.startTime, this.endTime});
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = stream.readFields();
        int serialVersionOnStream = fields.get("serialVersionOnStream", 0);
        this.rawOffset = fields.get("rawOffset", 0);
        this.useDaylight = fields.get("useDaylight", false);
        if (this.useDaylight) {
            this.endMonth = fields.get("endMonth", 0);
            this.startMonth = fields.get("startMonth", 0);
            this.startYear = fields.get("startYear", 0);
            if (serialVersionOnStream < 2) {
                this.endTime = fields.get("endTime", 0);
                this.startTime = fields.get("startTime", 0);
            }
        }
        if (serialVersionOnStream == 0) {
            if (this.useDaylight) {
                this.endMode = 2;
                this.startMode = 2;
                this.endDay = fields.get("endDay", 0);
                this.endDayOfWeek = fields.get("endDayOfWeek", 0) - 1;
                this.startDay = fields.get("startDay", 0);
                this.startDayOfWeek = fields.get("startDayOfWeek", 0) - 1;
            }
        } else {
            this.dstSavings = fields.get("dstSavings", 0);
            if (this.useDaylight) {
                this.endMode = fields.get("endMode", 0);
                this.startMode = fields.get("startMode", 0);
                if (serialVersionOnStream > 1) {
                    this.startTimeMode = fields.get("startTimeMode", 0);
                    this.endTimeMode = fields.get("endTimeMode", 0);
                }
                int length = stream.readInt();
                byte[] values = new byte[length];
                stream.readFully(values);
                if (length >= 4) {
                    this.startDay = values[0];
                    this.startDayOfWeek = values[1];
                    if (this.startMode != 1) {
                        --this.startDayOfWeek;
                    }
                    this.endDay = values[2];
                    this.endDayOfWeek = values[3];
                    if (this.endMode != 1) {
                        --this.endDayOfWeek;
                    }
                }
                if (serialVersionOnStream > 1) {
                    int[] times = (int[])stream.readObject();
                    this.startTime = times[0];
                    this.endTime = times[1];
                }
            }
        }
    }
}

