/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import com.ibm.oti.util.Msg;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class GZIPInputStream
extends InflaterInputStream {
    protected CRC32 crc = new CRC32();
    protected boolean eos = false;
    public static final int GZIP_MAGIC = 35615;
    private static final int FHCRC = 2;
    private static final int FEXTRA = 4;
    private static final int FNAME = 8;
    private static final int FCOMMENT = 16;

    public GZIPInputStream(InputStream is) throws IOException {
        this(is, 512);
    }

    public GZIPInputStream(InputStream is, int size) throws IOException {
        super(is, new Inflater(true), size);
        boolean hcrc;
        byte[] header = new byte[10];
        this.readFully(header, 0, header.length);
        if (this.getShort(header, 0) != 35615) {
            throw new IOException(Msg.getString("K0412"));
        }
        byte flags = header[3];
        boolean bl = hcrc = (flags & 2) != 0;
        if (hcrc) {
            this.crc.update(header, 0, header.length);
        }
        if ((flags & 4) != 0) {
            this.readFully(header, 0, 2);
            if (hcrc) {
                this.crc.update(header, 0, 2);
            }
            int length = this.getShort(header, 0);
            while (length > 0) {
                int max = length > this.buf.length ? this.buf.length : length;
                int result = this.in.read(this.buf, 0, max);
                if (result == -1) {
                    throw new EOFException();
                }
                if (hcrc) {
                    this.crc.update(this.buf, 0, result);
                }
                length -= result;
            }
        }
        if ((flags & 8) != 0) {
            this.readZeroTerminated(hcrc);
        }
        if ((flags & 0x10) != 0) {
            this.readZeroTerminated(hcrc);
        }
        if (hcrc) {
            this.readFully(header, 0, 2);
            int crc16 = this.getShort(header, 0);
            if ((this.crc.getValue() & 0xFFFFL) != (long)crc16) {
                throw new IOException(Msg.getString("K0077"));
            }
            this.crc.reset();
        }
    }

    private long getLong(byte[] buf, int off) {
        long l = 0L;
        l |= (long)(buf[off] & 0xFF);
        l |= (long)((buf[off + 1] & 0xFF) << 8);
        l |= (long)((buf[off + 2] & 0xFF) << 16);
        return l |= (long)(buf[off + 3] & 0xFF) << 24;
    }

    private int getShort(byte[] buf, int off) {
        return buf[off] & 0xFF | (buf[off + 1] & 0xFF) << 8;
    }

    public int read(byte[] buffer, int off, int nbytes) throws IOException {
        if (off <= buffer.length && nbytes >= 0 && off >= 0 && buffer.length - off >= nbytes) {
            int val = super.read(buffer, off, nbytes);
            if (val != -1) {
                this.crc.update(buffer, off, val);
            } else if (!this.eos) {
                int diff;
                this.eos = true;
                int size = 0;
                byte[] b = new byte[8];
                int inB = this.inf.getTotalIn();
                if (inB > 0 && ((diff = inB % this.buf.length) != 0 || this.len != this.buf.length)) {
                    size = this.len - diff;
                    if (size > b.length) {
                        size = b.length;
                    }
                    System.arraycopy((Object)this.buf, diff, (Object)b, 0, size);
                }
                this.readFully(b, size, b.length - size);
                if (this.getLong(b, 0) != this.crc.getValue()) {
                    throw new IOException(Msg.getString("K0077"));
                }
                if ((int)this.getLong(b, 4) != this.inf.getTotalOut()) {
                    throw new IOException(Msg.getString("K00ae"));
                }
            }
            return val;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public void close() throws IOException {
        this.eos = true;
        super.close();
    }

    private void readFully(byte[] buf, int offset, int length) throws IOException {
        while (length > 0) {
            int result = this.in.read(buf, offset, length);
            if (result == -1) {
                throw new EOFException();
            }
            offset += result;
            length -= result;
        }
    }

    private void readZeroTerminated(boolean hcrc) throws IOException {
        int result;
        while ((result = this.in.read()) > 0) {
            if (!hcrc) continue;
            this.crc.update(result);
        }
        if (result == -1) {
            throw new EOFException();
        }
        if (hcrc) {
            this.crc.update(result);
        }
    }
}

