/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.Util;
import com.ibm.oti.vm.VM;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

public class ZipInputStream
extends InflaterInputStream
implements ZipConstants {
    static final int DEFLATED = 8;
    static final int STORED = 0;
    static final int ZIPDataDescriptorFlag = 8;
    static final int ZIPLocalHeaderVersionNeeded = 20;
    private static final boolean useNative = VM.useNatives();
    private boolean closed = false;
    private boolean entriesEnd = false;
    private boolean hasDD = false;
    private int entryIn = 0;
    private int inRead;
    private int lastRead = 0;
    ZipEntry currentEntry;
    private byte[] hdrBuf = new byte[26];
    private CRC32 crc = new CRC32();
    private byte[] nameBuf = new byte[256];
    private char[] charBuf;

    public ZipInputStream(InputStream stream) {
        super(new PushbackInputStream(stream, 512), new Inflater(true));
        char[] cArray = this.charBuf = useNative ? null : new char[256];
        if (stream == null) {
            throw new NullPointerException();
        }
    }

    public void close() throws IOException {
        try {
            this.closeEntry();
        }
        catch (ZipException zipException) {}
        this.closed = true;
        super.close();
    }

    public void closeEntry() throws IOException {
        int out;
        int inB;
        Attributes temp;
        if (this.closed) {
            throw new IOException(Msg.getString("K0059"));
        }
        if (this.currentEntry == null) {
            return;
        }
        if (this.currentEntry instanceof JarEntry && (temp = ((JarEntry)this.currentEntry).getAttributes()) != null && temp.containsKey("hidden")) {
            return;
        }
        this.skip(Long.MAX_VALUE);
        if (this.currentEntry.compressionMethod == 8) {
            inB = this.inf.getTotalIn();
            out = this.inf.getTotalOut();
        } else {
            inB = this.inRead;
            out = this.inRead;
        }
        int diff = 0;
        diff = this.entryIn - inB;
        if (diff != 0) {
            ((PushbackInputStream)this.in).unread(this.buf, this.len - diff, diff);
        }
        if (this.hasDD) {
            this.in.read(this.hdrBuf, 0, 16);
            if (this.getLong(this.hdrBuf, 0) != 134695760L) {
                throw new ZipException(Msg.getString("K0020"));
            }
            this.currentEntry.crc = this.getLong(this.hdrBuf, 4);
            this.currentEntry.compressedSize = this.getLong(this.hdrBuf, 8);
            this.currentEntry.size = this.getLong(this.hdrBuf, 12);
        }
        if (this.currentEntry.crc != this.crc.getValue()) {
            throw new ZipException(Msg.getString("K0077"));
        }
        if (this.currentEntry.compressedSize != (long)inB || this.currentEntry.size != (long)out) {
            throw new ZipException(Msg.getString("K00ae"));
        }
        this.inf.reset();
        this.len = 0;
        this.entryIn = 0;
        this.inRead = 0;
        this.lastRead = 0;
        this.crc.reset();
        this.currentEntry = null;
    }

    public ZipEntry getNextEntry() throws IOException {
        int flen;
        int count;
        if (this.currentEntry != null) {
            this.closeEntry();
        }
        if (this.entriesEnd) {
            return null;
        }
        int x = 0;
        for (count = 0; count != 4; count += x) {
            x = this.in.read(this.hdrBuf, count, 4 - count);
            if (x != -1) continue;
            return null;
        }
        long hdr = this.getLong(this.hdrBuf, 0);
        if (hdr == 33639248L) {
            this.entriesEnd = true;
            return null;
        }
        if (hdr != 67324752L) {
            return null;
        }
        for (count = 0; count != 26; count += x) {
            x = this.in.read(this.hdrBuf, count, 26 - count);
            if (x != -1) continue;
            throw new EOFException();
        }
        int version = this.getShort(this.hdrBuf, 0) & 0xFF;
        if (version > 20) {
            throw new ZipException(Msg.getString("K0008"));
        }
        int flags = this.getShort(this.hdrBuf, 2);
        this.hasDD = (flags & 8) == 8;
        int cetime = this.getShort(this.hdrBuf, 6);
        int cemodDate = this.getShort(this.hdrBuf, 8);
        int cecompressionMethod = this.getShort(this.hdrBuf, 4);
        long cecrc = 0L;
        long cecompressedSize = 0L;
        long cesize = -1L;
        if (!this.hasDD) {
            cecrc = this.getLong(this.hdrBuf, 10);
            cecompressedSize = this.getLong(this.hdrBuf, 14);
            cesize = this.getLong(this.hdrBuf, 18);
        }
        if ((flen = this.getShort(this.hdrBuf, 22)) == 0) {
            throw new ZipException(Msg.getString("K000a"));
        }
        int elen = this.getShort(this.hdrBuf, 24);
        count = 0;
        if (flen > this.nameBuf.length) {
            this.nameBuf = new byte[flen];
            if (!useNative) {
                this.charBuf = new char[flen];
            }
        }
        while (count != flen) {
            x = this.in.read(this.nameBuf, count, flen - count);
            count += x;
            if (x != -1) continue;
            throw new EOFException();
        }
        this.currentEntry = useNative ? this.createZipEntry(Util.convertFromUTF8(this.nameBuf, 0, flen)) : this.createZipEntry(Util.convertUTF8WithBuf(this.nameBuf, this.charBuf, 0, flen));
        this.currentEntry.time = cetime;
        this.currentEntry.modDate = cemodDate;
        this.currentEntry.setMethod(cecompressionMethod);
        if (cesize != -1L) {
            this.currentEntry.setCrc(cecrc);
            this.currentEntry.setSize(cesize);
            this.currentEntry.setCompressedSize(cecompressedSize);
        }
        if (elen > 0) {
            byte[] e = new byte[elen];
            for (count = 0; count != elen; count += x) {
                x = this.in.read(e, count, elen - count);
                if (x != -1) continue;
                throw new EOFException();
            }
            this.currentEntry.setExtra(e);
        }
        return this.currentEntry;
    }

    public int read(byte[] buffer, int start, int length) throws IOException {
        if (this.closed) {
            throw new IOException(Msg.getString("K0059"));
        }
        if (this.inf.finished() || this.currentEntry == null) {
            return -1;
        }
        if (start <= buffer.length && length >= 0 && start >= 0 && buffer.length - start >= length) {
            if (this.currentEntry.compressionMethod == 0) {
                int toRead;
                int csize = (int)this.currentEntry.size;
                if (this.inRead >= csize) {
                    return -1;
                }
                if (this.lastRead >= this.len) {
                    this.lastRead = 0;
                    this.len = this.in.read(this.buf);
                    if (this.len == -1) {
                        return -1;
                    }
                    this.entryIn += this.len;
                }
                int n = toRead = length > this.len ? this.len - this.lastRead : length;
                if (csize - this.inRead < toRead) {
                    toRead = csize - this.inRead;
                }
                System.arraycopy((Object)this.buf, this.lastRead, (Object)buffer, start, toRead);
                this.lastRead += toRead;
                this.inRead += toRead;
                this.crc.update(buffer, start, toRead);
                return toRead;
            }
            if (this.inf.needsInput()) {
                this.fill();
                if (this.len > 0) {
                    this.entryIn += this.len;
                }
            }
            int read = 0;
            try {
                read = this.inf.inflate(buffer, start, length);
            }
            catch (DataFormatException e) {
                throw new ZipException(e.getMessage());
            }
            if (read == 0 && this.inf.finished()) {
                return -1;
            }
            this.crc.update(buffer, start, read);
            return read;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public long skip(long value) throws IOException {
        if (value >= 0L) {
            long skipped = 0L;
            byte[] b = new byte[1024];
            while (skipped != value) {
                long rem = value - skipped;
                int x = this.read(b, 0, (int)((long)b.length > rem ? rem : (long)b.length));
                if (x == -1) {
                    return skipped;
                }
                skipped += (long)x;
            }
            return skipped;
        }
        throw new IllegalArgumentException();
    }

    public int available() throws IOException {
        if (this.closed) {
            throw new IOException(Msg.getString("K0059"));
        }
        if (this.currentEntry == null) {
            return 1;
        }
        if (this.currentEntry.compressionMethod == 0 ? (long)this.inRead >= this.currentEntry.size : this.inf.finished()) {
            return 0;
        }
        return 1;
    }

    protected ZipEntry createZipEntry(String name) {
        return new ZipEntry(name);
    }

    private int getShort(byte[] buf, int off) {
        return buf[off] & 0xFF | (buf[off + 1] & 0xFF) << 8;
    }

    private long getLong(byte[] buf, int off) {
        long l = 0L;
        l |= (long)(buf[off] & 0xFF);
        l |= (long)((buf[off + 1] & 0xFF) << 8);
        l |= (long)((buf[off + 2] & 0xFF) << 16);
        return l |= (long)(buf[off + 3] & 0xFF) << 24;
    }
}

