/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import com.ibm.oti.jce.support.CipherTransformation;
import com.ibm.oti.jce.support.JCEClassValidator;
import com.ibm.oti.jce.support.Msg;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.ExemptionMechanism;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public class Cipher {
    private CipherSpi implementation = null;
    private Provider provider = null;
    private CipherTransformation transformation = null;
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    public static final int WRAP_MODE = 3;
    public static final int UNWRAP_MODE = 4;
    public static final int PUBLIC_KEY = 1;
    public static final int PRIVATE_KEY = 2;
    public static final int SECRET_KEY = 3;
    private static final String CIPHER_SERVICE_ID = "Cipher.";
    private static final int USAGE_KEY_ENCIPHERMENT = 2;
    private static final int USAGE_DATA_ENCIPHERMENT = 3;
    private static final int USAGE_ENCIPHER_ONLY = 7;
    private static final int USAGE_DECIPHER_ONLY = 8;
    int cipherOpMode = 0;

    protected Cipher(CipherSpi cipher, Provider cipherProvider, String cipherTransformation) {
        if (cipher == null) {
            throw new NullPointerException();
        }
        this.implementation = cipher;
        this.provider = cipherProvider;
        this.transformation = new CipherTransformation(cipherTransformation);
    }

    public static final Cipher getInstance(String transformation, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        if (provider == null) {
            throw new IllegalArgumentException();
        }
        if (transformation == null) {
            throw new NoSuchAlgorithmException();
        }
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(Msg.getString("JCE003", provider));
        }
        return Cipher.getInstance(transformation, p);
    }

    public static final Cipher getInstance(String transformation, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (provider == null) {
            throw new IllegalArgumentException();
        }
        if (transformation == null) {
            throw new NoSuchAlgorithmException();
        }
        CipherTransformation ct = new CipherTransformation(transformation);
        String className = null;
        className = Cipher.getClassNameForImpl(provider, ct);
        if (className == null) {
            throw new NoSuchAlgorithmException();
        }
        Class cipherClass = null;
        try {
            cipherClass = Class.forName(className, true, provider.getClass().getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoSuchAlgorithmException();
        }
        JCEClassValidator validator = new JCEClassValidator(cipherClass);
        try {
            validator.validateJCEProviderClass();
        }
        catch (SecurityException e) {
            throw new NoSuchAlgorithmException(e.getLocalizedMessage());
        }
        CipherSpi cipherSpi = null;
        try {
            cipherSpi = (CipherSpi)cipherClass.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new NoSuchAlgorithmException();
        }
        catch (InstantiationException instantiationException) {
            throw new NoSuchAlgorithmException();
        }
        if (ct.mustSetMode()) {
            cipherSpi.engineSetMode(ct.getMode());
        }
        if (ct.mustSetPadding()) {
            cipherSpi.engineSetPadding(ct.getPaddingScheme());
        }
        Cipher cipherInstance = new Cipher(cipherSpi, provider, transformation);
        return cipherInstance;
    }

    private static String getClassNameForImpl(Provider provider, CipherTransformation ct) throws NoSuchAlgorithmException {
        String className = null;
        String searchTransformation = null;
        if (ct.specifiesAlgorithmOnly()) {
            searchTransformation = CIPHER_SERVICE_ID + ct.getAlgorithm();
            className = provider.getProperty(searchTransformation);
            if (className == null) {
                throw new NoSuchAlgorithmException(Msg.getString("JCE004"));
            }
            return className;
        }
        searchTransformation = CIPHER_SERVICE_ID + ct.getAlgorithm() + "/" + ct.getMode() + "/" + ct.getPaddingScheme();
        className = provider.getProperty(searchTransformation);
        if (className != null) {
            return className;
        }
        searchTransformation = CIPHER_SERVICE_ID + ct.getAlgorithm() + "/" + ct.getMode();
        className = provider.getProperty(searchTransformation);
        if (className != null) {
            ct.setMustSetPadding();
            return className;
        }
        searchTransformation = CIPHER_SERVICE_ID + ct.getAlgorithm() + "//" + ct.getPaddingScheme();
        className = provider.getProperty(searchTransformation);
        if (className != null) {
            ct.setMustSetMode();
            return className;
        }
        searchTransformation = CIPHER_SERVICE_ID + ct.getAlgorithm();
        className = provider.getProperty(searchTransformation);
        if (className != null) {
            ct.setMustSetPadding();
            ct.setMustSetMode();
            return className;
        }
        throw new NoSuchAlgorithmException();
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getAlgorithm() {
        return this.transformation.toString();
    }

    public final int getBlockSize() {
        return this.implementation.engineGetBlockSize();
    }

    public final int getOutputSize(int inputLen) throws IllegalStateException {
        return this.implementation.engineGetOutputSize(inputLen);
    }

    public final AlgorithmParameters getParameters() {
        return this.implementation.engineGetParameters();
    }

    public final void init(int opMode, Key key, SecureRandom random) throws InvalidKeyException {
        Cipher.validateOpMode(opMode);
        this.cipherOpMode = opMode;
        this.implementation.engineInit(opMode, key, random);
    }

    public final void init(int opMode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher.validateOpMode(opMode);
        this.cipherOpMode = opMode;
        this.implementation.engineInit(opMode, key, params, random);
    }

    public final void init(int opMode, Key key, AlgorithmParameters params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher.validateOpMode(opMode);
        this.cipherOpMode = opMode;
        this.implementation.engineInit(opMode, key, params, this.getSecureRandom());
    }

    public final void init(int opMode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher.validateOpMode(opMode);
        this.cipherOpMode = opMode;
        this.implementation.engineInit(opMode, key, params, random);
    }

    public final void init(int opMode, Certificate cert) throws InvalidKeyException {
        this.init(opMode, cert, this.getSecureRandom());
    }

    public final void init(int opMode, Certificate cert, SecureRandom random) throws InvalidKeyException {
        boolean[] usage;
        X509Certificate x509Cert;
        Set criticalExtensions;
        Cipher.validateOpMode(opMode);
        if (cert instanceof X509Certificate && (criticalExtensions = (x509Cert = (X509Certificate)cert).getCriticalExtensionOIDs()) != null && criticalExtensions.contains("2.5.29.15") && (usage = x509Cert.getKeyUsage()) != null) {
            this.validateKeyUsage(opMode, usage);
        }
        PublicKey publicKey = cert.getPublicKey();
        this.init(opMode, (Key)publicKey, random);
    }

    private final void validateKeyUsage(int opMode, boolean[] usage) throws InvalidKeyException {
        switch (opMode) {
            case 1: {
                if (usage[7] || usage[3]) break;
                throw new InvalidKeyException();
            }
            case 2: {
                if (usage[8] || usage[3]) break;
                throw new InvalidKeyException();
            }
            case 3: 
            case 4: {
                if (usage[2]) break;
                throw new InvalidKeyException();
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public final byte[] update(byte[] input) throws IllegalStateException {
        if (input == null) {
            throw new NullPointerException();
        }
        if (input.length == 0) {
            return null;
        }
        return this.implementation.engineUpdate(input, 0, input.length);
    }

    public final byte[] update(byte[] input, int start, int end) throws IllegalStateException {
        if (input == null) {
            throw new NullPointerException();
        }
        if (input.length == 0) {
            return null;
        }
        return this.implementation.engineUpdate(input, start, end);
    }

    public final int update(byte[] input, int start, int end, byte[] output) throws IllegalStateException, ShortBufferException {
        if (input == null || output == null) {
            throw new NullPointerException();
        }
        if (input.length == 0) {
            return 0;
        }
        return this.implementation.engineUpdate(input, start, end, output, 0);
    }

    public final byte[] doFinal() throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        return this.implementation.engineDoFinal(new byte[0], 0, 0);
    }

    public final int doFinal(byte[] output, int outputOffset) throws IllegalStateException, IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        if (output == null) {
            throw new NullPointerException();
        }
        return this.implementation.engineDoFinal(null, 0, 0, output, outputOffset);
    }

    public final byte[] doFinal(byte[] input) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        if (input == null) {
            throw new IllegalArgumentException();
        }
        return this.implementation.engineDoFinal(input, 0, input.length);
    }

    public final byte[] doFinal(byte[] input, int start, int end) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        if (input == null) {
            throw new NullPointerException();
        }
        return this.implementation.engineDoFinal(input, start, end);
    }

    public final int doFinal(byte[] input, int start, int end, byte[] output) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (input == null || output == null) {
            throw new NullPointerException();
        }
        return this.implementation.engineDoFinal(input, start, end, output, 0);
    }

    public final byte[] wrap(Key key) throws IllegalStateException, IllegalBlockSizeException, InvalidKeyException {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.implementation.engineWrap(key);
    }

    public final Key unwrap(byte[] input, String algorithm, int keyType) throws IllegalStateException, InvalidKeyException, NoSuchAlgorithmException {
        if (input == null) {
            throw new NullPointerException();
        }
        return this.implementation.engineUnwrap(input, algorithm, keyType);
    }

    public final ExemptionMechanism getExemptionMechanism() {
        return null;
    }

    public final int doFinal(byte[] input, int start, int end, byte[] output, int outputStart) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (input == null || output == null) {
            throw new NullPointerException();
        }
        return this.implementation.engineDoFinal(input, start, end, output, outputStart);
    }

    public static final Cipher getInstance(String transformation) throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (transformation == null) {
            throw new NoSuchAlgorithmException();
        }
        CipherTransformation ct = new CipherTransformation(transformation);
        Provider[] providers = Security.getProviders(CIPHER_SERVICE_ID + ct.getAlgorithm());
        if (providers == null) {
            throw new NoSuchAlgorithmException();
        }
        Provider cipherProvider = providers[0];
        return Cipher.getInstance(transformation, cipherProvider);
    }

    public final byte[] getIV() {
        return this.implementation.engineGetIV();
    }

    public final void init(int opMode, Key key) throws InvalidKeyException {
        Cipher.validateOpMode(opMode);
        this.implementation.engineInit(opMode, key, this.getSecureRandom());
    }

    public final void init(int opMode, Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher.validateOpMode(opMode);
        this.cipherOpMode = opMode;
        this.implementation.engineInit(opMode, key, params, this.getSecureRandom());
    }

    public final int update(byte[] input, int start, int end, byte[] output, int outputStart) throws IllegalStateException, ShortBufferException {
        if (input == null || output == null) {
            throw new NullPointerException();
        }
        if (input.length == 0) {
            return 0;
        }
        return this.implementation.engineUpdate(input, start, end, output, outputStart);
    }

    SecureRandom getSecureRandom() {
        return new SecureRandom();
    }

    private static void validateOpMode(int opMode) {
        if (opMode < 1 || opMode > 4) {
            throw new InvalidParameterException();
        }
    }
}

