/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.AlgorithmParameterSpec;

public class RC5ParameterSpec
implements AlgorithmParameterSpec {
    private final int version;
    private final int rounds;
    private final int wordSize;
    private final byte[] initializationVector;

    public RC5ParameterSpec(int version, int rounds, int wordSize) {
        this(version, rounds, wordSize, null, 0);
    }

    public RC5ParameterSpec(int version, int rounds, int wordSize, byte[] initializationVector) {
        this(version, rounds, wordSize, initializationVector, 0);
    }

    public RC5ParameterSpec(int version, int rounds, int wordSize, byte[] initializationVector, int offset) {
        this.version = version;
        this.rounds = rounds;
        this.wordSize = wordSize;
        if (initializationVector != null) {
            this.initializationVector = new byte[2 * (wordSize / 8)];
            System.arraycopy((Object)initializationVector, offset, (Object)this.initializationVector, 0, 2 * (wordSize / 8));
        } else {
            this.initializationVector = null;
        }
    }

    public int getVersion() {
        return this.version;
    }

    public int getRounds() {
        return this.rounds;
    }

    public int getWordSize() {
        return this.wordSize;
    }

    public byte[] getIV() {
        return this.initializationVector;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof RC5ParameterSpec)) {
            return false;
        }
        RC5ParameterSpec other = (RC5ParameterSpec)o;
        if (this.version != other.version) {
            return false;
        }
        if (this.rounds != other.rounds) {
            return false;
        }
        if (this.wordSize != other.wordSize) {
            return false;
        }
        if (this.initializationVector == null && other.initializationVector != null) {
            return false;
        }
        if (this.initializationVector == null && other.initializationVector == null) {
            return true;
        }
        if (this.initializationVector.length != other.initializationVector.length) {
            return false;
        }
        int i = 0;
        while (i < this.initializationVector.length) {
            if (this.initializationVector[i] != other.initializationVector[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode *= this.version;
        hashCode *= this.rounds;
        hashCode *= this.wordSize;
        if (this.initializationVector != null) {
            int i = 0;
            while (i < this.initializationVector.length) {
                hashCode *= this.initializationVector[i];
                ++i;
            }
        }
        return hashCode;
    }
}

