/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.x500;

import com.ibm.oti.util.ASN1Exception;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Principal;

public final class X500Principal
implements Principal,
Serializable {
    private static final long serialVersionUID = -500463348111345721L;
    public static final String RFC1779 = "RFC1779";
    public static final String RFC2253 = "RFC2253";
    public static final String CANONICAL = "CANONICAL";
    private transient com.ibm.oti.security.provider.X500Principal principal = null;

    public X500Principal(byte[] name) {
        try {
            this.principal = new com.ibm.oti.security.provider.X500Principal(name);
        }
        catch (ASN1Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public X500Principal(InputStream is) {
        if (is == null) {
            throw new NullPointerException();
        }
        try {
            this.principal = new com.ibm.oti.security.provider.X500Principal(is);
        }
        catch (ASN1Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public X500Principal(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.principal = new com.ibm.oti.security.provider.X500Principal(name);
    }

    public String getName() {
        return this.getName(RFC2253);
    }

    public String getName(String format) {
        return this.principal.getName(this.mapAPIConstantToInternal(format));
    }

    public byte[] getEncoded() {
        return this.principal.getEncoded();
    }

    public String toString() {
        return this.principal.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof X500Principal)) {
            return false;
        }
        return this.getName(CANONICAL).equals(((X500Principal)o).getName(CANONICAL));
    }

    public int hashCode() {
        return this.getName(CANONICAL).hashCode();
    }

    private int mapAPIConstantToInternal(String representation) {
        if (representation.equals(RFC1779)) {
            return 0;
        }
        if (representation.equals(RFC2253)) {
            return 1;
        }
        if (representation.equals(CANONICAL)) {
            return 2;
        }
        throw new IllegalArgumentException();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.getEncoded());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        byte[] encoded = (byte[])stream.readObject();
        this.principal = new com.ibm.oti.security.provider.X500Principal(encoded);
    }
}

