/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.common.pbootutil;

import enea.ose.io.SignalInputStream;
import enea.ose.io.SignalOutputStream;
import enea.ose.system.UnlinkedSignal;
import java.io.IOException;
import se.ericsson.cello.support.debug.MessageLog;

public class CsPbootGetParamReply
extends UnlinkedSignal {
    public static final long CELLO_NVPI_RET_OK = 0L;
    private static final int sigNo = 397585;
    private String name = "";
    private long size = 0L;
    private long resultCode = 0L;
    private String value = "";

    public CsPbootGetParamReply() {
        super(397585);
    }

    public CsPbootGetParamReply(String aName, String aValue, long aSize, long aResultCode) {
        super(397585);
        this.name = aName;
        this.value = aValue;
        this.size = aSize;
        this.resultCode = aResultCode;
    }

    public void initReceive() {
        try {
            SignalInputStream sis = this.getSignalInputStream();
            int[] paramName = sis.readU8Array(32);
            this.size = sis.readU32();
            this.resultCode = sis.readU32();
            StringBuffer sbName = new StringBuffer();
            int i = 0;
            while ((long)i < this.size && paramName[i] != 0) {
                sbName.append((char)paramName[i]);
                ++i;
            }
            this.name = sbName.toString();
            if (this.resultCode == 0L) {
                int paramValueChar;
                StringBuffer sbValue = new StringBuffer();
                for (int i2 = 0; i2 < 64 && (paramValueChar = sis.readU8Array(1)[0]) != 0; ++i2) {
                    sbValue.append((char)paramValueChar);
                }
                this.value = sbValue.toString();
            } else {
                this.value = "";
            }
        }
        catch (IOException e) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), (String)"Exection caught while receiving CsPbootGetParamReply", (Throwable)e);
        }
    }

    public void initSend() {
        try {
            SignalOutputStream sos = this.getSignalOutputStream();
            int[] paramName = new int[32];
            for (int i = 0; i < 32; ++i) {
                paramName[i] = i < this.name.length() ? (int)this.name.charAt(i) : 0;
            }
            sos.writeU8Array(paramName);
            sos.writeU32((long)this.name.length());
            sos.writeU32(this.resultCode);
            int[] paramValue = new int[this.value.length() + 1];
            paramValue[this.value.length()] = 0;
            for (int i = 0; i < this.value.length(); ++i) {
                paramValue[i] = this.value.charAt(i);
            }
            sos.flush();
        }
        catch (IOException e) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), (String)"EExection caught while sending CsPbootGetParamReply", (Throwable)e);
        }
    }

    public String getName() {
        return this.name;
    }

    public long getResultCode() {
        return this.resultCode;
    }

    public String getValue() {
        return this.value;
    }
}

