/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies;

import java.util.ArrayList;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.RbsErrorException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcGenericProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcMeasurementProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcEulGetAllAttUsersReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcEulGetAllAttUsersRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcEulGetAllRejUsersReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcEulGetAllRejUsersRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcEulGetCapNumUsersReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcEulGetCapNumUsersRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcEulGetCarrierParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcEulGetCarrierParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcEulGetCellParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcEulGetCellParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcEulGetEulUsersReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcEulGetEulUsersRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcEulGetPmNoiseFloorReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcEulGetPmNoiseFloorRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcEulSetCarrierParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcEulSetCellParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcEulSettableCarrierParamsT;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcEulSettableCellParamsT;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcHspaRhStartPmReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcHspaRhStopPmReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcSetFeatCpcReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcSetRbsFeatDlPcEulReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsEulEDchCreatedIndS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsEulEDchDeletedIndS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsEulGetEDchParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsEulGetEDchParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsEulGetPmEdchAccessReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsEulGetPmEdchAccessRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsEulGetPmUuReschedReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsEulGetPmUuReschedRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsEulGetRbsParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsEulGetRbsParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsEulSetRbsParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsEulStartPmReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsEulStopPmReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsEulSubscCmEDchReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsEulSubscCmEDchRspS;
import se.ericsson.wcdma.rbs.boam.fpx.common.PmCounterTableManager;
import se.ericsson.wcdma.rbs.boam.fpx.proxies.ScannedValue;
import se.ericsson.wcdma.rbs.boam.pms.iface.ProxyScanner;

public class ChcEulProxy
extends ChcGenericProxy
implements ProxyScanner {
    private static final Class THIS_CLASS = ChcEulProxy.class;
    private static final String SERVICE_NAME = "lrsEulResMgr";
    private static ChcEulProxy theOneAndOnly;

    private ChcEulProxy() {
        super(SERVICE_NAME);
        MessageLog.traceEnter(THIS_CLASS, "ChcEulProxy()");
        this.boamSignalPort.addSignalObserver(this, LrsEulEDchCreatedIndS.class);
        this.boamSignalPort.addSignalObserver(this, LrsEulEDchDeletedIndS.class);
    }

    public static synchronized ChcEulProxy instance() {
        if (theOneAndOnly == null) {
            theOneAndOnly = new ChcEulProxy();
        }
        return theOneAndOnly;
    }

    public LrsEulGetRbsParamRspS eulgetRbsParams(int clientId, int transactionId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(THIS_CLASS, "eulgetRbsParams()");
        LrsEulGetRbsParamReqS reqSig = new LrsEulGetRbsParamReqS(transactionId, clientId);
        return (LrsEulGetRbsParamRspS)this.sendAndRec(reqSig);
    }

    public void eulSetRbsParams(int clientId, int transactionId, int paramId, int value, int[] valuesArray) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(THIS_CLASS, "eulSetRbsParams()");
        LrsEulSetRbsParamReqS reqSig = new LrsEulSetRbsParamReqS(transactionId, clientId, paramId, value, valuesArray);
        this.sendAndRec(reqSig);
    }

    public void setRbsFeatureStateDlPower(int transactionId, int clientId, int rbsFeatureStateDlPower) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(THIS_CLASS, "setRbsFeatureStateDlPower()<---");
        ChcSetRbsFeatDlPcEulReqS reqSig = new ChcSetRbsFeatDlPcEulReqS(transactionId, clientId, rbsFeatureStateDlPower);
        this.sendAndRec(reqSig);
    }

    public void pmsStart(String name, int granularityPeriod, int froId, int bbPoolId, int[] additionalInfo) throws MoAccessException {
        if (additionalInfo != null) {
            if (this.useChcHspa(name)) {
                if (additionalInfo.length == 4 && 4096 == additionalInfo[1]) {
                    if (1 == additionalInfo[2]) {
                        return;
                    }
                    froId = additionalInfo[3];
                }
                ChcHspaRhStartPmReqS reqSig = new ChcHspaRhStartPmReqS(0L, froId, this.getMeasureType(name), granularityPeriod);
                this.sendAndRec(reqSig);
            } else if (this.useEulPm(name)) {
                this.startEulPm(0, froId, this.getMeasureType(name), granularityPeriod);
            } else if (this.useChcMeasurementProxy(name)) {
                if (name.equalsIgnoreCase(String.valueOf(186)) && additionalInfo.length == 4 && 4096 == additionalInfo[1]) {
                    if (1 == additionalInfo[2]) {
                        return;
                    }
                    froId = additionalInfo[3];
                }
                ChcMeasurementProxy.instance().pmsStart(name, granularityPeriod, froId, bbPoolId, additionalInfo);
            } else {
                String diagnosis = " Unknown PMS counter [group] name '" + name + "'" + " passed to pmsStart().";
                MessageLog.traceError(this.getClass(), diagnosis);
                throw new RbsErrorException(this.getClass().getName() + diagnosis);
            }
        }
    }

    public void pmsStop(String name, int froId, int bbPoolId, int[] additionalInfo) throws MoAccessException {
        if (additionalInfo != null) {
            if (this.useChcHspa(name)) {
                if (additionalInfo.length == 4 && 4096 == additionalInfo[1]) {
                    if (1 == additionalInfo[2]) {
                        return;
                    }
                    froId = additionalInfo[3];
                }
                ChcHspaRhStopPmReqS reqSig = new ChcHspaRhStopPmReqS(0L, froId, this.getMeasureType(name));
                this.sendAndRec(reqSig);
            } else if (this.useEulPm(name)) {
                this.stopEulPm(0, froId, this.getMeasureType(name));
            } else if (this.useChcMeasurementProxy(name)) {
                if (name.equalsIgnoreCase(String.valueOf(186)) && additionalInfo.length == 4 && 4096 == additionalInfo[1]) {
                    if (1 == additionalInfo[2]) {
                        return;
                    }
                    froId = additionalInfo[3];
                }
                ChcMeasurementProxy.instance().pmsStop(name, froId, bbPoolId, additionalInfo);
            } else {
                String diagnosis = " Unknown PMS counter [group] name '" + name + "'" + " passed to pmsStop().";
                MessageLog.traceError(this.getClass(), diagnosis);
                throw new RbsErrorException(this.getClass().getName() + ":" + diagnosis);
            }
        }
    }

    public ScannedValue[] getPmsAttribute(String name, int froId, int bbPoolId, int[] additionalInfo) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPmsAttribute()<---");
        if (this.useChcMeasurementProxy(name)) {
            if (name.equalsIgnoreCase(String.valueOf(186)) && additionalInfo.length == 4 && 4096 == additionalInfo[1]) {
                if (1 == additionalInfo[2]) {
                    return new ScannedValue[0];
                }
                froId = additionalInfo[3];
            }
            return ChcMeasurementProxy.instance().getPmsAttribute(name, froId, bbPoolId, additionalInfo);
        }
        if (this.useChcHspa(name) && additionalInfo.length == 4 && 4096 == additionalInfo[1]) {
            if (1 == additionalInfo[2]) {
                return new ScannedValue[0];
            }
            froId = additionalInfo[3];
        }
        ArrayList<ScannedValue> result2 = new ArrayList<ScannedValue>();
        ScannedValue aValue = null;
        if (additionalInfo != null) {
            if (name.equals("pmNoAllowedEul")) {
                LrsEulGetPmEdchAccessRspS rspSig = this.getPmNoAllowedEul(0, froId);
                aValue = new ScannedValue(name, new int[]{rspSig.pmNoAllowedEul});
                result2.add(aValue);
            } else if (name.equals("pmNoUlUuLoadLimitEul")) {
                LrsEulGetPmUuReschedRspS rspSig = this.getPmNoUlUuLoadLimitEul(0, froId);
                aValue = new ScannedValue(name, new int[]{rspSig.pmNoUlUuLoadLimitEul});
                result2.add(aValue);
            } else if (name.equals("pmsNoiseFloor")) {
                ChcEulGetPmNoiseFloorRspS rspSig = this.getPmNoiseFloor(0, froId);
                if (1 == rspSig.numOfCellPortions) {
                    aValue = new ScannedValue("pmNoiseFloor", rspSig.pmNoiseFloorContainer[0].pmNoiseFloor);
                    result2.add(aValue);
                    aValue = new ScannedValue("pmNoiseFloor1", rspSig.pmNoiseFloorContainer[1].pmNoiseFloor);
                    result2.add(aValue);
                    aValue = new ScannedValue("pmNoiseFloor2", rspSig.pmNoiseFloorContainer[1].pmNoiseFloor);
                    result2.add(aValue);
                    aValue = new ScannedValue("pmNoiseFloor3", rspSig.pmNoiseFloorContainer[2].pmNoiseFloor);
                    result2.add(aValue);
                    aValue = new ScannedValue("pmNoiseFloorHighRes", rspSig.pmNoiseFloorHighContainer.pmNoiseFloor);
                    result2.add(aValue);
                } else {
                    int[] minusOneNoiseFloor = new int[56];
                    for (int i = 0; i < minusOneNoiseFloor.length; ++i) {
                        minusOneNoiseFloor[i] = -1;
                    }
                    aValue = new ScannedValue("pmNoiseFloor", minusOneNoiseFloor);
                    result2.add(aValue);
                    aValue = new ScannedValue("pmNoiseFloor1", rspSig.pmNoiseFloorContainer[0].pmNoiseFloor);
                    result2.add(aValue);
                    aValue = new ScannedValue("pmNoiseFloor2", rspSig.pmNoiseFloorContainer[1].pmNoiseFloor);
                    result2.add(aValue);
                    aValue = new ScannedValue("pmNoiseFloor3", rspSig.pmNoiseFloorContainer[2].pmNoiseFloor);
                    result2.add(aValue);
                    aValue = new ScannedValue("pmNoiseFloorHighRes", rspSig.pmNoiseFloorHighContainer.pmNoiseFloor);
                    result2.add(aValue);
                }
            } else if (name.equals("pmCapacityServEDchUsers")) {
                ChcEulGetEulUsersRspS rspSig = (ChcEulGetEulUsersRspS)this.sendAndRec(new ChcEulGetEulUsersReqS(0L, froId));
                aValue = new ScannedValue(name, rspSig.eulUsers);
                result2.add(aValue);
            } else if (name.equals("pmCapacityAllocAttServEDchUsers")) {
                ChcEulGetAllAttUsersRspS rspSig = (ChcEulGetAllAttUsersRspS)this.sendAndRec(new ChcEulGetAllAttUsersReqS(0L, froId));
                int[] allAttUsers = new int[]{rspSig.allAttUsers};
                aValue = new ScannedValue(name, allAttUsers);
                result2.add(aValue);
            } else if (name.equals("pmCapacityAllocRejServEDchUsers")) {
                ChcEulGetAllRejUsersRspS rspSig = (ChcEulGetAllRejUsersRspS)this.sendAndRec(new ChcEulGetAllRejUsersReqS(0L, froId));
                int[] allRejUsers = new int[]{rspSig.allRejUsers};
                aValue = new ScannedValue(name, allRejUsers);
                result2.add(aValue);
            } else if (name.equals("capacityNumServEDchUsers")) {
                ChcEulGetCapNumUsersRspS rspSig = (ChcEulGetCapNumUsersRspS)this.sendAndRec(new ChcEulGetCapNumUsersReqS(0L, froId));
                int[] sumSampledUsers = new int[]{rspSig.sumSampledUsers};
                aValue = new ScannedValue("pmSumCapacityServEDchUsers", sumSampledUsers);
                result2.add(aValue);
                int[] sumSqrSampledCodes = new int[]{rspSig.sumSqrSampledUsers};
                aValue = new ScannedValue("pmSumSqrCapacityServEDchUsers", sumSqrSampledCodes);
                result2.add(aValue);
                int[] noOfSamples = new int[]{rspSig.noOfSamples};
                aValue = new ScannedValue("pmSamplesCapacityServEDchUsers", noOfSamples);
                result2.add(aValue);
            } else {
                MessageLog.traceError(this.getClass(), "No such a PM counter: " + name);
                throw new RbsErrorException("getPmsAttribute():No such PM counter: " + name);
            }
        }
        return result2.toArray(new ScannedValue[result2.size()]);
    }

    private LrsEulGetPmEdchAccessRspS getPmNoAllowedEul(int clientId, int froId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(THIS_CLASS, "getPmNoAllowedEul()<---");
        LrsEulGetPmEdchAccessReqS reqSig = new LrsEulGetPmEdchAccessReqS(clientId, froId);
        return (LrsEulGetPmEdchAccessRspS)this.sendAndRec(reqSig);
    }

    private LrsEulGetPmUuReschedRspS getPmNoUlUuLoadLimitEul(int clientId, int froId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(THIS_CLASS, "getPmNoUlUuLoadLimitEul()<---");
        LrsEulGetPmUuReschedReqS reqSig = new LrsEulGetPmUuReschedReqS(clientId, froId);
        return (LrsEulGetPmUuReschedRspS)this.sendAndRec(reqSig);
    }

    private ChcEulGetPmNoiseFloorRspS getPmNoiseFloor(int clientId, int froId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(THIS_CLASS, "getPmNoiseFloor()<---");
        ChcEulGetPmNoiseFloorReqS reqSig = new ChcEulGetPmNoiseFloorReqS(clientId, froId);
        return (ChcEulGetPmNoiseFloorRspS)this.sendAndRec(reqSig);
    }

    private int getMeasureType(String name) {
        if (name.equals("pmNoAllowedEul")) {
            return 185;
        }
        if (name.equals("pmNoUlUuLoadLimitEul")) {
            return 182;
        }
        if (name.equals("pmsNoiseFloor")) {
            return 2006;
        }
        if (name.equals("pmCapacityServEDchUsers")) {
            return 25;
        }
        if (name.equals("pmCapacityAllocAttServEDchUsers")) {
            return 26;
        }
        if (name.equals("pmCapacityAllocRejServEDchUsers")) {
            return 27;
        }
        if (name.equals("capacityNumServEDchUsers")) {
            return 28;
        }
        return -1;
    }

    private boolean useChcHspa(String counterName) {
        return counterName.equals("pmCapacityServEDchUsers") || counterName.equals("pmCapacityAllocAttServEDchUsers") || counterName.equals("pmCapacityAllocRejServEDchUsers") || counterName.equals("capacityNumServEDchUsers");
    }

    private boolean useEulPm(String counterName) {
        return counterName.equals("pmNoAllowedEul") || counterName.equals("pmNoUlUuLoadLimitEul") || counterName.equals("pmsNoiseFloor");
    }

    private boolean useChcMeasurementProxy(String counterName) {
        return PmCounterTableManager.isInPmCounterTable(counterName);
    }

    public void subscribeToFroNotification() {
        MessageLog.traceEnter(THIS_CLASS, "subscribeToFroNotification");
        int CLIENT_ID = 0;
        try {
            this.subscCmEDch(CLIENT_ID, 0);
        }
        catch (FroRequestFailedException e) {
            MessageLog.traceError(THIS_CLASS, "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
        catch (FroNotAccessibleException e) {
            MessageLog.traceError(THIS_CLASS, "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
    }

    private LrsEulSubscCmEDchRspS subscCmEDch(int clientId, int subscribeOperation) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(THIS_CLASS, "subscCmEDch()");
        LrsEulSubscCmEDchReqS reqSig = new LrsEulSubscCmEDchReqS(clientId, subscribeOperation, this.signalPort.getServiceName());
        return (LrsEulSubscCmEDchRspS)this.sendAndRec(reqSig);
    }

    public LrsEulGetEDchParamRspS getEulEDchParameter(int transactionId, int clientId, int cellCarrierFroId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(THIS_CLASS, "getEulEDchParameter()");
        LrsEulGetEDchParamReqS reqSig = new LrsEulGetEDchParamReqS(clientId, transactionId, cellCarrierFroId);
        return (LrsEulGetEDchParamRspS)this.sendAndRec(reqSig);
    }

    public void setEulCarrierParameters(int transactionId, int clientId, int cellCarrierFroId, int noOfValidParams, ChcEulSettableCarrierParamsT[] carrierParams) throws FroRequestFailedException, FroNotAccessibleException, RbsErrorException {
        int i;
        MessageLog.traceEnter(THIS_CLASS, "setEulCarrierParameters()");
        if (noOfValidParams > 16) {
            String err = "The noOfValidParams for EUL carrier parameters is out of range!";
            MessageLog.traceError(THIS_CLASS, err);
            throw new RbsErrorException(err);
        }
        ChcEulSettableCarrierParamsT[] params = new ChcEulSettableCarrierParamsT[16];
        for (i = 0; i < noOfValidParams; ++i) {
            params[i] = carrierParams[i];
        }
        for (i = noOfValidParams; i < 16; ++i) {
            params[i] = new ChcEulSettableCarrierParamsT(0, 0);
        }
        ChcEulSetCarrierParamReqS reqSig = new ChcEulSetCarrierParamReqS(transactionId, clientId, cellCarrierFroId, noOfValidParams, params);
        this.sendAndRec(reqSig);
    }

    public void setEulCellParameters(int transactionId, int clientId, int cellFroId, int noOfValidParams, ChcEulSettableCellParamsT[] cellParams) throws FroRequestFailedException, FroNotAccessibleException, RbsErrorException {
        int i;
        MessageLog.traceEnter(THIS_CLASS, "setEulCellParameters()");
        if (noOfValidParams > 16) {
            String err = "The noOfValidParams for EUL cell parameters is out of range!";
            MessageLog.traceError(THIS_CLASS, err);
            throw new RbsErrorException(err);
        }
        ChcEulSettableCellParamsT[] params = new ChcEulSettableCellParamsT[16];
        for (i = 0; i < noOfValidParams; ++i) {
            params[i] = cellParams[i];
        }
        for (i = noOfValidParams; i < 16; ++i) {
            params[i] = new ChcEulSettableCellParamsT(0, 0);
        }
        ChcEulSetCellParamReqS reqSig = new ChcEulSetCellParamReqS(transactionId, clientId, cellFroId, noOfValidParams, params);
        this.sendAndRec(reqSig);
    }

    public void setFeatureStateCpc(int transactionId, int clientId, int cellFroId, int featureStateCpc) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(THIS_CLASS, "setFeatureStateCpc()");
        ChcSetFeatCpcReqS reqSig = new ChcSetFeatCpcReqS(transactionId, clientId, cellFroId, featureStateCpc);
        this.sendAndRec(reqSig);
    }

    public ChcEulGetCellParamRspS getEulCellParameter(int transactionId, int clientId, int cellFroId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(THIS_CLASS, "getEulCellParameter()");
        ChcEulGetCellParamReqS reqSig = new ChcEulGetCellParamReqS(transactionId, clientId, cellFroId);
        return (ChcEulGetCellParamRspS)this.sendAndRec(reqSig);
    }

    public ChcEulGetCarrierParamRspS getEulCarrierParameter(int transactionId, int clientId, int cellCarrierFroId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(THIS_CLASS, "getEulCarrierParameter()");
        ChcEulGetCarrierParamReqS reqSig = new ChcEulGetCarrierParamReqS(transactionId, clientId, cellCarrierFroId);
        return (ChcEulGetCarrierParamRspS)this.sendAndRec(reqSig);
    }

    private void startEulPm(int clientId, int cellFroId, int measType, int granularity) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(THIS_CLASS, "startEulPm()<---");
        LrsEulStartPmReqS reqSig = new LrsEulStartPmReqS(clientId, cellFroId, measType, granularity, SERVICE_NAME);
        this.sendAndRec(reqSig);
    }

    private void stopEulPm(int clientId, int cellFroId, int measType) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(THIS_CLASS, "stopEulPm()<---");
        LrsEulStopPmReqS reqSig = new LrsEulStopPmReqS(clientId, cellFroId, measType);
        this.sendAndRec(reqSig);
    }
}

