/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies;

import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcGenericProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcCellCarrierStartPmReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcCellCarrierStopPmReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcCellFaultCeaseIndS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcCellFaultIndS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetCarrierPmDlCodeReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetCarrierPmDlCodeRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetCellFeatCapParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetCellFeatCapParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcServiceNameT;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcSetCellFeatureStateReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcSetEulMaxUsersReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcSetHsdpaMultiCarrierReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcSubscrCellFaultReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcSubscrCellFaultRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcSetHsdpaDynAdditionReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcSetHsdpaMaxCodesReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcSetHsdpaMaxUsersReqS;

public class ChcHsdpaCellServiceProxy
extends ChcGenericProxy {
    private static ChcHsdpaCellServiceProxy uniqueInstance;
    private static final String SERVICE_NAME = "EqcHsdpaCellServiceName";
    private int clientID = 0;

    private ChcHsdpaCellServiceProxy() {
        super(SERVICE_NAME);
        MessageLog.traceEnter(this.getClass(), "NcSystemConstantsProxy() <---");
        this.boamSignalPort.addSignalObserver(this, ChcCellFaultIndS.class);
        this.boamSignalPort.addSignalObserver(this, ChcCellFaultCeaseIndS.class);
    }

    public static synchronized ChcHsdpaCellServiceProxy instance() {
        if (uniqueInstance == null) {
            uniqueInstance = new ChcHsdpaCellServiceProxy();
        }
        return uniqueInstance;
    }

    public void setHsdpaCellParamMaxCode(int transactionId, int clientId, int cellFroId, int value) throws FroRequestFailedException, FroNotAccessibleException {
        EqcSetHsdpaMaxCodesReqS reqSig = new EqcSetHsdpaMaxCodesReqS(transactionId, clientId, cellFroId, value);
        this.sendAndRec(reqSig);
    }

    public void setHsdpaCellParamMaxUsers(int transactionId, int clientId, int cellFroId, int value) throws FroRequestFailedException, FroNotAccessibleException {
        EqcSetHsdpaMaxUsersReqS reqSig = new EqcSetHsdpaMaxUsersReqS(transactionId, clientId, cellFroId, value);
        this.sendAndRec(reqSig);
    }

    public void setDynamicHsPdschCodeAdditionOn(int transactionId, int clientId, int cellFroId, int value) throws FroRequestFailedException, FroNotAccessibleException {
        EqcSetHsdpaDynAdditionReqS reqSig = new EqcSetHsdpaDynAdditionReqS(transactionId, clientId, cellFroId, value);
        this.sendAndRec(reqSig);
    }

    public void setEulMaxUsers(int transactionId, int clientId, int cellFroId, int maxNumEul) throws FroRequestFailedException, FroNotAccessibleException {
        ChcSetEulMaxUsersReqS reqSig = new ChcSetEulMaxUsersReqS(transactionId, clientId, cellFroId, maxNumEul);
        this.sendAndRec(reqSig);
    }

    public void setHsdpaMultiCarrier(int transactionId, int clientId, int cellFroId, int featureStateHsdpaMc) throws FroNotAccessibleException, FroRequestFailedException {
        MessageLog.traceEnter(this.getClass(), "setHsdpaMultiCarrier()");
        ChcSetHsdpaMultiCarrierReqS reqSig = new ChcSetHsdpaMultiCarrierReqS(transactionId, clientId, cellFroId, featureStateHsdpaMc);
        this.sendAndRec(reqSig);
    }

    public void setCellFeatureState(int transactionId, int clientId, int cellFroId, int featureId, int featureState) throws FroNotAccessibleException, FroRequestFailedException {
        MessageLog.traceEnter(this.getClass(), "setCellFeatureState()");
        ChcSetCellFeatureStateReqS reqSig = new ChcSetCellFeatureStateReqS(transactionId, clientId, cellFroId, featureId, featureState);
        this.sendAndRec(reqSig);
    }

    private ChcSubscrCellFaultRspS subscrAlarms() throws FroRequestFailedException, FroNotAccessibleException {
        ChcServiceNameT chcServiceName = new ChcServiceNameT(this.signalPort.getServiceName());
        ChcSubscrCellFaultReqS reqSig = new ChcSubscrCellFaultReqS(this.clientID, chcServiceName, 0);
        return (ChcSubscrCellFaultRspS)this.sendAndRec(reqSig);
    }

    public void subscribeToFroNotification() {
        MessageLog.traceEnter(this.getClass(), "subscribeToFroNotification");
        try {
            this.subscrAlarms();
        }
        catch (FroRequestFailedException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
        catch (FroNotAccessibleException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
    }

    public ChcGetCarrierPmDlCodeRspS getCellCarrierPmUsedDlCodes(int clientId, int froId) throws FroRequestFailedException, FroNotAccessibleException {
        ChcGetCarrierPmDlCodeReqS reqSig = new ChcGetCarrierPmDlCodeReqS(clientId, froId);
        return (ChcGetCarrierPmDlCodeRspS)this.sendAndRec(reqSig);
    }

    public ChcGetCellFeatCapParamRspS getCellFeatCapParam(long transactionId, long clientId, long cellFroId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "getCellFeatCapParam()<---");
        ChcGetCellFeatCapParamReqS reqSig = new ChcGetCellFeatCapParamReqS(transactionId, clientId, cellFroId);
        return (ChcGetCellFeatCapParamRspS)this.sendAndRec(reqSig);
    }

    public void chcCellCarrierStartPm(int clientId2, int measType, int froId, int granularityPeriod) throws FroRequestFailedException, FroNotAccessibleException {
        ChcCellCarrierStartPmReqS reqSig = new ChcCellCarrierStartPmReqS(clientId2, froId, measType, granularityPeriod);
        this.sendAndRec(reqSig);
    }

    public void chcCellCarrierStopPm(int clientId2, int measType, int froId) throws FroRequestFailedException, FroNotAccessibleException {
        ChcCellCarrierStopPmReqS reqSig = new ChcCellCarrierStopPmReqS(clientId2, froId, measType);
        this.sendAndRec(reqSig);
    }
}

