/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.common;

import enea.ose.io.SignalInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetPmRspS;
import se.ericsson.wcdma.rbs.boam.fpx.common.PmCounterTableManager;
import se.ericsson.wcdma.rbs.boam.fpx.proxies.ScannedValue;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.InternalErrorException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.ParameterValueErrorException;

public abstract class ChcGetPmRspEnDecoder {
    private static final Class THIS_CLASS = ChcGetPmRspEnDecoder.class;

    public static List decode(SignalInputStream in, ChcGetPmRspS chcGetPmRspS) throws ParameterValueErrorException {
        ArrayList<ScannedValue> counterList = new ArrayList<ScannedValue>();
        try {
            int pmDataLength;
            chcGetPmRspS.clientId = in.readS32();
            chcGetPmRspS.result = in.readS32();
            chcGetPmRspS.errorCode = in.readS32();
            chcGetPmRspS.index = in.readS32();
            chcGetPmRspS.measType = in.readS32();
            chcGetPmRspS.pmDataLength = pmDataLength = in.readS32();
            MessageLog.trace((int)3, (Class)THIS_CLASS, (String)("ChcGetPmRspS initReceive pmDataLength " + pmDataLength));
            int counterId = -1;
            int counterSize = -1;
            int pmDataSize = -1;
            if (0 != pmDataLength % 4) {
                throw new ParameterValueErrorException("Wrong pmDataLength " + pmDataLength + " in ChcGetPmRsp");
            }
            pmDataSize = pmDataLength / 4;
            for (int coursor = 0; coursor < pmDataSize; coursor += 2 + counterSize) {
                counterId = in.readS32();
                MessageLog.trace((int)3, (Class)THIS_CLASS, (String)("ChcGetPmRspS initReceive counterId " + counterId));
                String counterName = PmCounterTableManager.getCounterNameFromCounterId(counterId);
                if (null == counterName) {
                    throw new ParameterValueErrorException("Wrong counterId " + counterId + " in ChcGetPmRsp or no counterId defined in PmCounterTable");
                }
                MessageLog.trace((int)3, (Class)THIS_CLASS, (String)("ChcGetPmRspS initReceive counterName " + counterName));
                counterSize = in.readS32();
                counterList.add(new ScannedValue(counterName, in.readS32Array(counterSize)));
            }
            MessageLog.trace((int)3, (Class)THIS_CLASS, (String)("ChcGetPmRspS initReceive counterList " + counterList));
        }
        catch (IOException e) {
            MessageLog.traceError((Class)THIS_CLASS, (String)("initReceive failed in ChcGetPmRspS: " + e));
        }
        catch (InternalErrorException e) {
            MessageLog.traceError((Class)THIS_CLASS, (String)("Got unexpected counterName or counterValues in ScannedValue: " + (Object)((Object)e)));
        }
        return counterList;
    }
}

