/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies;

import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EcGenericProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsCreatePodsReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsCreatePodsRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsDeletePodsReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsDeletePodsRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsGetPodsParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsGetPodsParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsPodsFaultCeaseIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsPodsFaultIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsSetPodsParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsSetPodsParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsSubscPodsFaultReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.LrsSubscPodsFaultRspS;

public class EcPowerDistributeProxy
extends EcGenericProxy {
    private static final String SERVICE_NAME = "lrsPowerResMgr";
    private static EcPowerDistributeProxy theOneAndOnly = null;

    private EcPowerDistributeProxy() {
        super(SERVICE_NAME);
        MessageLog.traceEnter(this.getClass(), "Constructor");
        this.boamSignalPort.addSignalObserver(this, LrsPodsFaultIndS.class);
        this.boamSignalPort.addSignalObserver(this, LrsPodsFaultCeaseIndS.class);
    }

    public static synchronized EcPowerDistributeProxy instance() {
        if (theOneAndOnly == null) {
            theOneAndOnly = new EcPowerDistributeProxy();
        }
        return theOneAndOnly;
    }

    private LrsSubscPodsFaultRspS subscPodsFault(int clientId, int subscribeOperation) throws FroRequestFailedException, FroNotAccessibleException {
        LrsSubscPodsFaultReqS reqSig = new LrsSubscPodsFaultReqS(clientId, subscribeOperation, this.signalPort.getServiceName());
        return (LrsSubscPodsFaultRspS)this.sendAndRec(reqSig);
    }

    public LrsCreatePodsRspS createPods(int transactionId, int clientId, int currentOverloadAlarmLevel, int currentOverloadAlarmCeaseOffset, int inputOvervoltageAlarmLevel, int inputOvervoltageAlarmCeaseOffset, int inputUndervoltageAlarmLevel, int inputUndervoltageAlarmCeaseOffset, int systemOvervoltageAlarmLevel, int systemOvervoltageAlarmCeaseOffset, int systemUndervoltageAlarmLevel, int systemUndervoltageAlarmCeaseOffset) throws FroRequestFailedException, FroNotAccessibleException {
        LrsCreatePodsReqS reqSig = new LrsCreatePodsReqS(transactionId, clientId, currentOverloadAlarmLevel, currentOverloadAlarmCeaseOffset, inputOvervoltageAlarmLevel, inputOvervoltageAlarmCeaseOffset, inputUndervoltageAlarmLevel, inputUndervoltageAlarmCeaseOffset, systemOvervoltageAlarmLevel, systemOvervoltageAlarmCeaseOffset, systemUndervoltageAlarmLevel, systemUndervoltageAlarmCeaseOffset);
        return (LrsCreatePodsRspS)this.sendAndRec(reqSig);
    }

    public LrsDeletePodsRspS deletePods(int transactionId, int clientId, int podsFroId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsDeletePodsReqS reqSig = new LrsDeletePodsReqS(transactionId, clientId, podsFroId);
        return (LrsDeletePodsRspS)this.sendAndRec(reqSig);
    }

    public LrsGetPodsParamRspS getPodsParam(int transactionId, int clientId, int podsFroId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsGetPodsParamReqS reqSig = new LrsGetPodsParamReqS(transactionId, clientId, podsFroId);
        return (LrsGetPodsParamRspS)this.sendAndRec(reqSig);
    }

    public LrsSetPodsParamRspS setPodsParam(int transactionId, int clientId, int podsFroId, int paramId, int value) throws FroRequestFailedException, FroNotAccessibleException {
        LrsSetPodsParamReqS reqSig = new LrsSetPodsParamReqS(transactionId, clientId, podsFroId, paramId, value);
        return (LrsSetPodsParamRspS)this.sendAndRec(reqSig);
    }

    public void subscribeToFroNotification() {
        try {
            int CLIENT_ID = 0;
            this.subscPodsFault(CLIENT_ID, 0);
        }
        catch (FroRequestFailedException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
        catch (FroNotAccessibleException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
    }

    public String getErrorCodeServiceName() {
        return "lrsPodsResMgr";
    }
}

