/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies;

import se.ericsson.cello.support.sigutil.PortManager;
import se.ericsson.cello.support.sigutil.SignalPort;
import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EcGenericProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcCreateSaReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcCreateSaRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcDeleteSaReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcDeleteSaRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcGetSaParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcGetSaParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcSaPrimFaultCeaseIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcSaPrimFaultIndS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcSetAntennaTypeReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcSetAntennaTypeRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcSetRiuParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcSetRiuParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcSubscrSaFaultReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsServiceNameT;

public class EqcSectorAntennaProxy
extends EcGenericProxy {
    private static final Class SELF = EqcSectorAntennaProxy.class;
    protected static final SignalPort portManager = PortManager.instance();
    private static EqcSectorAntennaProxy theOneAndOnly = null;
    private static final String SERVICE_NAME = "EqcBdhBoardDeviceHandler";

    private EqcSectorAntennaProxy() {
        super(SERVICE_NAME);
        this.boamSignalPort.addSignalObserver(this, EcSaPrimFaultIndS.class);
        this.boamSignalPort.addSignalObserver(this, EcSaPrimFaultCeaseIndS.class);
    }

    public static synchronized EqcSectorAntennaProxy instance() {
        if (theOneAndOnly == null) {
            theOneAndOnly = new EqcSectorAntennaProxy();
        }
        return theOneAndOnly;
    }

    public EcCreateSaRspS createAntenna(int transactionId, int clientId, int sectorFroId, boolean externalAntenna) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(SELF, "createSectorAntenna()");
        EcCreateSaReqS reqSig = new EcCreateSaReqS(transactionId, clientId, sectorFroId, externalAntenna ? 1 : 0);
        return (EcCreateSaRspS)this.sendAndRec(reqSig);
    }

    public EcSetAntennaTypeRspS setAntennaType(int transactionId, int clientId, int saFroId, int antennaType) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(SELF, "setAntennaType()");
        EcSetAntennaTypeReqS reqSig = new EcSetAntennaTypeReqS(transactionId, clientId, saFroId, antennaType);
        return (EcSetAntennaTypeRspS)this.sendAndRec(reqSig);
    }

    public EcGetSaParamRspS getSaParam(int transactionId, int clientId, int saFroId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(SELF, "getSaParam()");
        EcGetSaParamReqS reqSig = new EcGetSaParamReqS(transactionId, clientId, saFroId);
        return (EcGetSaParamRspS)this.sendAndRec(reqSig);
    }

    public EcDeleteSaRspS deleteSectorAntenna(int transactionId, int clientId, int froId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(SELF, "deleteSectorAntenna()");
        EcDeleteSaReqS reqSig = new EcDeleteSaReqS(transactionId, clientId, froId);
        return (EcDeleteSaRspS)this.sendAndRec(reqSig);
    }

    public EcSetRiuParamRspS createDeleteRiu(int transactionId, int clientId, int saFroid, boolean create) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(SELF, "createDeleteRiu(), create: " + create);
        EcSetRiuParamReqS reqSig = new EcSetRiuParamReqS(transactionId, clientId, saFroid, create ? 1 : 0);
        return (EcSetRiuParamRspS)this.sendAndRec(reqSig);
    }

    public void subscribeToFroNotification() {
        MessageLog.traceEnter(SELF, "subscribeToFroNotification()");
        try {
            this.subscSa(0, 0);
        }
        catch (FroRequestFailedException e) {
            MessageLog.traceError(SELF, "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
        catch (FroNotAccessibleException e) {
            MessageLog.traceError(SELF, "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
    }

    private void subscSa(int clientId, int subscriptionRequest) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(SELF, "subscSa()");
        RbsServiceNameT rbsServiceName = new RbsServiceNameT();
        rbsServiceName.serviceName = this.signalPort.getServiceName();
        EcSubscrSaFaultReqS reqSig = new EcSubscrSaFaultReqS(clientId, rbsServiceName, subscriptionRequest);
        this.sendAndRec(reqSig);
    }
}

