/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies;

import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EcGenericProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcSectorGetParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcSectorGetParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcSectorSetParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcAddSectorCarrierReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcAddSectorCarrierRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateSectorReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateSectorRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcDeleteSectorReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcDeleteSectorRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcInitSectorReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcInitSectorRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcUninitSectorReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcUninitSectorRspS;

public class EqcSectorProxy
extends EcGenericProxy {
    private static EqcSectorProxy theOneAndOnly = null;
    private static final String SERVICE_NAME = "EqcBdhBoardDeviceHandler";
    public static final String CURRENT_CLASS = EqcSectorProxy.class.getName();

    private EqcSectorProxy() {
        super(SERVICE_NAME);
    }

    public static synchronized EqcSectorProxy instance() {
        if (theOneAndOnly == null) {
            theOneAndOnly = new EqcSectorProxy();
        }
        return theOneAndOnly;
    }

    public EqcCreateSectorRspS createSector(int transactionId, int clientId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "createSector()");
        EqcCreateSectorReqS reqSig = new EqcCreateSectorReqS(transactionId, clientId);
        return (EqcCreateSectorRspS)this.sendAndRec(reqSig);
    }

    public EqcDeleteSectorRspS deleteSector(int transactionId, int clientId, int sectorFroId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "deleteSector()");
        EqcDeleteSectorReqS reqSig = new EqcDeleteSectorReqS(transactionId, clientId, sectorFroId);
        return (EqcDeleteSectorRspS)this.sendAndRec(reqSig);
    }

    public EqcInitSectorRspS initSector(int transactionId, int clientId, int sectorFroId, int frequencyPlanes, int noOfTxBranches, int withTma, int withRet, int txDiversity) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "initSector()");
        EqcInitSectorReqS reqSig = new EqcInitSectorReqS(transactionId, clientId, sectorFroId, frequencyPlanes, noOfTxBranches, withTma, withRet, txDiversity);
        return (EqcInitSectorRspS)this.sendAndRec(reqSig);
    }

    public EqcUninitSectorRspS uninitSector(int transactionId, int clientId, int sectorFroId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "uninitSector()");
        EqcUninitSectorReqS reqSig = new EqcUninitSectorReqS(transactionId, clientId, sectorFroId);
        return (EqcUninitSectorRspS)this.sendAndRec(reqSig);
    }

    public EqcAddSectorCarrierRspS addSectorCarrier(int transactionId, int clientId, int sectorFroId, int frequencyPlane) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "addSectorCarrier()");
        EqcAddSectorCarrierReqS reqSig = new EqcAddSectorCarrierReqS(transactionId, clientId, sectorFroId, frequencyPlane);
        return (EqcAddSectorCarrierRspS)this.sendAndRec(reqSig);
    }

    public void setSectorParam(int transactionId, int clientId, int sectorFroId, int sectorId, int radioBuildingBlock, int lineRate, int sectorGroup, int noOfConfiguration, int[] configuration, int noiseFigure) throws FroNotAccessibleException, FroRequestFailedException {
        MessageLog.traceEnter(this.getClass(), "sectorSetParam()");
        EcSectorSetParamReqS reqSig = new EcSectorSetParamReqS(transactionId, clientId, sectorFroId, sectorId, radioBuildingBlock, lineRate, sectorGroup, noOfConfiguration, configuration, noiseFigure);
        this.sendAndRec(reqSig);
    }

    public EcSectorGetParamRspS sectorGetParam(int transactionId, int clientId, int sectorFroId) throws FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "sectorGetParam()");
        EcSectorGetParamReqS reqSig = new EcSectorGetParamReqS(transactionId, clientId, sectorFroId);
        return (EcSectorGetParamRspS)this.sendAndRec(reqSig);
    }
}

