/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs;

import enea.ose.io.SignalInputStream;
import enea.ose.io.SignalOutputStream;
import enea.ose.system.UnlinkedSignal;
import java.io.IOException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsServiceNameT;

public class EcSubscrGroupAvcReqS
extends UnlinkedSignal {
    public static final int SIG_NO = 16815070;
    public long clientId;
    public int subscribeOperation;
    public RbsServiceNameT receiverServiceName = new RbsServiceNameT();

    public EcSubscrGroupAvcReqS() {
        super(16815070);
    }

    public EcSubscrGroupAvcReqS(long clientId, int subscribeOperation, RbsServiceNameT receiverServiceName) {
        super(16815070);
        this.clientId = clientId;
        this.subscribeOperation = subscribeOperation;
        this.receiverServiceName = receiverServiceName;
    }

    public void initReceive() {
        SignalInputStream in = this.getSignalInputStream();
        try {
            this.clientId = in.readU32();
            this.subscribeOperation = in.readS32();
            this.receiverServiceName.serviceName = in.readString();
            long bytesToSkip = 64 - this.receiverServiceName.serviceName.length() - 1;
            if (in.skip(bytesToSkip) != bytesToSkip) {
                MessageLog.traceError(((Object)((Object)this)).getClass(), (String)"skip() could not skip the requested amount of bytes");
            }
        }
        catch (IOException e) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), (String)("initReceive failed in EcSubscrGroupAvcReqS: " + e));
        }
    }

    public void initSend() {
        SignalOutputStream out = this.getSignalOutputStream();
        try {
            out.writeU32(this.clientId);
            out.writeS32(this.subscribeOperation);
            out.writeString(this.receiverServiceName.serviceName);
            out.writeU8Array(new int[64 - this.receiverServiceName.serviceName.length() - 1]);
        }
        catch (IOException e) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), (String)("initSend failed in EcSubscrGroupAvcReqS: " + e));
        }
    }
}

