/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs;

import enea.ose.io.SignalInputStream;
import enea.ose.io.SignalOutputStream;
import enea.ose.system.UnlinkedSignal;
import java.io.IOException;
import se.ericsson.wcdma.rbs.boam.common.Strings;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcGpehEventS;

public class BcGpehScanActReqS
extends UnlinkedSignal {
    public static final int SIG_NO = 16777816;
    public static final int BC_GPEH_MAX_USER_LABEL_LENGTH = 200;
    public static final int BC_GPEH_MAX_LOGICAL_NAME_LENGTH = 200;
    public static final int BC_GPEH_MAX_NUMBER_OF_EVENTS = 8;
    public int clientId;
    public long maxStorageSize;
    public long maxFileSize;
    public String meUserLabel;
    public String meLogicalName;
    public int numberOfGpehEvents;
    public BcGpehEventS[] gpehEvent = new BcGpehEventS[8];
    public String gpehFileLocation;

    public BcGpehScanActReqS() {
        super(16777816);
        this.meUserLabel = "";
        this.meLogicalName = "";
        BcGpehEventS dummyEvent = new BcGpehEventS(-1, -1);
        for (int i = 0; i < 8; ++i) {
            this.gpehEvent[i] = dummyEvent;
        }
        this.gpehFileLocation = "";
    }

    public BcGpehScanActReqS(int clientId, long maxStorageSize, long maxFileSize, String meUserLabel, String meLogicalName, int numberOfGpehEvents, BcGpehEventS[] gpehEvent, String gpehFileLocation) {
        super(16777816);
        this.clientId = clientId;
        this.maxStorageSize = maxStorageSize;
        this.maxFileSize = maxFileSize;
        this.meUserLabel = meUserLabel;
        this.meLogicalName = meLogicalName;
        this.numberOfGpehEvents = numberOfGpehEvents;
        for (int i = 0; i < numberOfGpehEvents && i < 8; ++i) {
            this.gpehEvent[i] = gpehEvent[i];
        }
        BcGpehEventS dummyEvent = new BcGpehEventS(-1, -1);
        for (int i = numberOfGpehEvents; i < 8; ++i) {
            this.gpehEvent[i] = dummyEvent;
        }
        this.gpehFileLocation = gpehFileLocation;
    }

    public void initReceive() {
        SignalInputStream in = this.getSignalInputStream();
        try {
            this.clientId = in.readS32();
            this.maxStorageSize = in.readU32();
            this.maxFileSize = in.readU32();
            this.meUserLabel = Strings.toString(in.readS8Array(200));
            this.meLogicalName = Strings.toString(in.readS8Array(200));
            this.numberOfGpehEvents = in.readS32();
            for (int i = 0; i < 8; ++i) {
                this.gpehEvent[i].eventId = in.readS32();
                this.gpehEvent[i].pmsId = in.readS32();
            }
            this.gpehFileLocation = in.readString();
        }
        catch (IOException e) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), "initReceive failed in BcGpehScanActReqS: " + e);
        }
    }

    public void initSend() {
        SignalOutputStream out = this.getSignalOutputStream();
        try {
            out.writeS32(this.clientId);
            out.writeU32(this.maxStorageSize);
            out.writeU32(this.maxFileSize);
            out.writeS8Array(Strings.getBytes(this.meUserLabel, 200));
            out.writeS8Array(Strings.getBytes(this.meLogicalName, 200));
            out.writeS32(this.numberOfGpehEvents);
            for (int i = 0; i < 8; ++i) {
                out.writeS32(this.gpehEvent[i].eventId);
                out.writeS32(this.gpehEvent[i].pmsId);
            }
            out.writeString(this.gpehFileLocation);
        }
        catch (IOException e) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), "initSend failed in BcGpehScanActReqS: " + e);
        }
    }
}

