/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs;

import enea.ose.io.SignalInputStream;
import enea.ose.io.SignalOutputStream;
import java.io.IOException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.wcdma.rbs.boam.common.AvcIndication;
import se.ericsson.wcdma.rbs.boam.common.Strings;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.SccRetDeviceDataS;

public class SccRetAvcIndS
extends AvcIndication {
    public static final int SIG_NO = 16802078;
    public int clientId;
    public SccRetDeviceDataS newDeviceData = new SccRetDeviceDataS();

    public SccRetAvcIndS() {
        super(16802078);
    }

    public SccRetAvcIndS(int clientId, int retDeviceFroId, SccRetDeviceDataS newDeviceData) {
        super(16802078);
        this.clientId = clientId;
        this.froId = retDeviceFroId;
        this.newDeviceData = newDeviceData;
    }

    public void initReceive() {
        SignalInputStream in = this.getSignalInputStream();
        try {
            this.clientId = in.readS32();
            this.froId = in.readS32();
            this.newDeviceData.antennaModelNumber = Strings.toString(in.readS8Array(16));
            this.newDeviceData.antennaSerialNumber = Strings.toString(in.readS8Array(18));
            this.newDeviceData.antennaOperatingBand = in.readU16();
            this.newDeviceData.beamwidth = in.readU16Array(4);
            this.newDeviceData.gain = in.readU8Array(4);
            this.newDeviceData.maxTilt = in.readS16();
            this.newDeviceData.minTilt = in.readS16();
            this.newDeviceData.installationDate = Strings.toString(in.readS8Array(7));
            this.newDeviceData.installerID = Strings.toString(in.readS8Array(6));
            this.newDeviceData.baseStationID = Strings.toString(in.readS8Array(33));
            this.newDeviceData.sectorID = Strings.toString(in.readS8Array(33));
            this.newDeviceData.antennaBearing = in.readU16();
            this.newDeviceData.installedMechanicalTilt = in.readS16();
        }
        catch (IOException e) {
            MessageLog.traceError(this.getClass(), (String)("initReceive failed in SccRetAvcIndS: " + e));
        }
    }

    public void initSend() {
        SignalOutputStream out = this.getSignalOutputStream();
        try {
            out.writeS32(this.clientId);
            out.writeS32(this.froId);
            out.writeS8Array(Strings.getBytes(this.newDeviceData.antennaModelNumber, 16));
            out.writeS8Array(Strings.getBytes(this.newDeviceData.antennaSerialNumber, 18));
            out.writeU16(this.newDeviceData.antennaOperatingBand);
            out.writeU16Array(this.newDeviceData.beamwidth);
            out.writeU8Array(this.newDeviceData.gain);
            out.writeS16(this.newDeviceData.maxTilt);
            out.writeS16(this.newDeviceData.minTilt);
            out.writeS8Array(Strings.getBytes(this.newDeviceData.installationDate, 7));
            out.writeS8Array(Strings.getBytes(this.newDeviceData.installerID, 6));
            out.writeS8Array(Strings.getBytes(this.newDeviceData.baseStationID, 33));
            out.writeS8Array(Strings.getBytes(this.newDeviceData.sectorID, 33));
            out.writeU16(this.newDeviceData.antennaBearing);
            out.writeS16(this.newDeviceData.installedMechanicalTilt);
        }
        catch (IOException e) {
            MessageLog.traceError(this.getClass(), (String)("initSend failed in SccRetAvcIndS: " + e));
        }
    }
}

