/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos;

import edu.emory.mathcs.backport.java.util.concurrent.TimeoutException;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.wcdma.rbs.boam.common.log.AiMessageLog;
import se.ericsson.wcdma.rbs.boam.common.xmlutil.NlhFileEncryptDecryption;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.IpHostLinkConfigure;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.UpgradePackageHelp;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.XmlFileAttrParser;

public class UpgradePackageHandler {
    private static final String OAM_IP_CONFIGURATION_DATA = "OamIpConfigurationData";
    private static final String SUBNET_MASK = "subnetMask";
    private static final String IP_ADDRESS = "ipAddress";
    private static final String DEFAULT_ROUTER = "defaultRouter0";
    private static final String SMRS_DATA = "SmrsData";
    private static final String ADDRESS = "address";
    private static final String PASSWORD = "password";
    private static final String USER_NAME = "userName";
    private static final String SUMMARY_FILE_PATH = "summaryFilePath";
    private static final String WCDMA_CONFIGURATION_FILES = "WcdmaConfigurationFiles";
    private static final String UP_FILE_PATH = "upFilePathOnFtpServer";
    private String siteInstallationFilePath;
    private String subnetMask;
    private String ipAddress;
    private String defaultRouter;
    private String address;
    private String password;
    private String userName;
    private String summaryFilePath;
    private String upFilePathOnFtpServer;

    public UpgradePackageHandler(String siteInstallationFilePath) {
        this.siteInstallationFilePath = siteInstallationFilePath;
    }

    public boolean startUpgrade() throws TransactionRolledBackException, InactiveTransactionException, MoAccessException, TimeoutException, InterruptedException, IpHostLinkConfigure.CreateMoException {
        AiMessageLog.traceEnter(this.getClass(), "Parse file and upgrade.");
        this.parseSiteInstallationFileAndSetAttributes();
        this.parseSummaryFileAndSetAttributes();
        if (null != this.upFilePathOnFtpServer && !this.upFilePathOnFtpServer.equals("")) {
            IpHostLinkConfigure ipHostLinkConfigure = new IpHostLinkConfigure();
            ipHostLinkConfigure.startConfigureIpHostLinkMo(this.ipAddress, this.defaultRouter, this.subnetMask);
            UpgradePackageHelp upgradePackageHelp = new UpgradePackageHelp();
            boolean upgradePackageStatus = upgradePackageHelp.upgradePackageInit(this.upFilePathOnFtpServer, this.address, this.userName, this.password);
            if (upgradePackageStatus) {
                ipHostLinkConfigure.deleteMo();
                return true;
            }
            return false;
        }
        return true;
    }

    private void parseSiteInstallationFileAndSetAttributes() {
        XmlFileAttrParser siteInstallationFileParser = null;
        String encryptKey = null;
        boolean decryptRet = false;
        File file = new File(this.siteInstallationFilePath);
        if (!file.exists()) {
            return;
        }
        encryptKey = NlhFileEncryptDecryption.getXmlEncryptionKey();
        if (encryptKey == null) {
            AiMessageLog.traceError(this.getClass(), "Error occurred when getting the encrypt key, decrypt SiteInstallation file unsuccessfully.");
            return;
        }
        siteInstallationFileParser = new XmlFileAttrParser(file);
        decryptRet = siteInstallationFileParser.decryptAndParseXML(encryptKey);
        if (!decryptRet) {
            AiMessageLog.traceError(this.getClass(), "Decrypt and parse siteInstallation file unsuccessfully.");
            return;
        }
        AiMessageLog.info(this.getClass(), "Decrypt and parse siteInstallation file successfully.");
        siteInstallationFileParser.parseAndValidate();
        this.subnetMask = siteInstallationFileParser.getAttributeValue(OAM_IP_CONFIGURATION_DATA, SUBNET_MASK);
        this.ipAddress = siteInstallationFileParser.getAttributeValue(OAM_IP_CONFIGURATION_DATA, IP_ADDRESS);
        this.defaultRouter = siteInstallationFileParser.getAttributeValue(OAM_IP_CONFIGURATION_DATA, DEFAULT_ROUTER);
        this.address = siteInstallationFileParser.getAttributeValue(SMRS_DATA, ADDRESS);
        this.password = siteInstallationFileParser.getAttributeValue(SMRS_DATA, PASSWORD);
        this.userName = siteInstallationFileParser.getAttributeValue(SMRS_DATA, USER_NAME);
        this.summaryFilePath = siteInstallationFileParser.getAttributeValue(SMRS_DATA, SUMMARY_FILE_PATH);
        if (decryptRet) {
            try {
                siteInstallationFileParser.encryptXmlFile(encryptKey);
            }
            catch (GeneralSecurityException e) {
                String msg = "Failure when doing encryption for file:" + this.siteInstallationFilePath;
                AiMessageLog.traceError(this.getClass(), msg, e);
            }
            catch (IOException e) {
                String msg = "Failure when doing encryption for file:" + this.siteInstallationFilePath;
                AiMessageLog.traceError(this.getClass(), msg, e);
            }
        }
    }

    private void parseSummaryFileAndSetAttributes() {
        if (null == this.summaryFilePath) {
            return;
        }
        File file = new File(this.summaryFilePath);
        if (!file.exists()) {
            return;
        }
        XmlFileAttrParser summaryFileParser = new XmlFileAttrParser(file);
        summaryFileParser.decryptAndParseXML();
        summaryFileParser.parseAndValidate();
        this.upFilePathOnFtpServer = summaryFileParser.getAttributeValue(WCDMA_CONFIGURATION_FILES, UP_FILE_PATH);
    }
}

